/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.ws.pmi.server.ModuleConfigParser;
import java.io.File;
import java.util.HashMap;
import javax.management.ObjectName;

public class PerfModules
implements PmiConstants {
    public static final String[] moduleIDs50 = new String[]{"beanModule", "cacheModule", "connectionPoolModule", "j2cModule", "jvmRuntimeModule", "orbPerfModule", "systemModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule", "wlmModule", "webServicesModule", "wsgwModule"};
    public static final String[] moduleIDs40 = new String[]{"beanModule", "connectionPoolModule", "jvmRuntimeModule", "jvmpiModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule"};
    public static String[] moduleIDs = moduleIDs50;
    private static String modulePrefix = "com.ibm.websphere.pmi.xml.";
    private static HashMap moduleConfigs = new HashMap();
    private static ModuleConfigParser parser = new ModuleConfigParser();
    static final int MODULE_INDEX = 1;
    static final int SUBMODULE_INDEX = 3;
    static final int METHOD_PATH = 5;

    private static synchronized void initConfigs() {
        for (int i = 0; i < moduleIDs.length; ++i) {
            PerfModules.addModuleInfo(moduleIDs[i], modulePrefix);
        }
    }

    public static PmiModuleConfig getConfig(String string) {
        PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)moduleConfigs.get(string);
        if (pmiModuleConfig == null) {
            PerfModules.addModuleInfo(string, modulePrefix);
        }
        return (PmiModuleConfig)moduleConfigs.get(string);
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            if (!pmiModuleConfigArray[i].getShortName().equals(string)) continue;
            return pmiModuleConfigArray[i];
        }
        return null;
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        String string = objectName.getKeyProperty("type");
        if (string.equals("Servlet")) {
            string = "WebModule";
        } else if (string.equals("EntityBean") || string.equals("StatefulSessionBean") || string.equals("StatelessSessionBean") || string.equals("MessageDrivenBean")) {
            string = "EJBModule";
        }
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            if (!pmiModuleConfigArray[i].getMbeanType().equals(string)) continue;
            return pmiModuleConfigArray[i];
        }
        return null;
    }

    public static PmiModuleConfig getConfigFromXMLFile(String string) {
        String string2;
        PmiModuleConfig pmiModuleConfig;
        File file = new File(string);
        String string3 = file.getName();
        int n = string3.lastIndexOf(".");
        if (n != -1 && (pmiModuleConfig = (PmiModuleConfig)moduleConfigs.get(string2 = string3.substring(0, n - 1))) != null) {
            return pmiModuleConfig;
        }
        pmiModuleConfig = parser.parse(string, true);
        if (pmiModuleConfig != null) {
            pmiModuleConfig.setMbeanType("");
            string2 = pmiModuleConfig.getShortName();
            moduleConfigs.put(string2, pmiModuleConfig);
            return pmiModuleConfig;
        }
        return null;
    }

    public static PmiModuleConfig[] getConfigs40() {
        int n = modulePrefix.indexOf("xml.");
        if (n > 0) {
            moduleIDs = moduleIDs40;
            modulePrefix = modulePrefix.substring(0, n);
            moduleConfigs = new HashMap();
        }
        PerfModules.initConfigs();
        return PerfModules.getConfigs();
    }

    public static String getDataName(String string, int n) {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfig(string);
        if (pmiModuleConfig == null) {
            return null;
        }
        PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
        if (pmiDataInfo == null) {
            return null;
        }
        return pmiDataInfo.getName();
    }

    public static int getDataId(String string, String string2) {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfig(string);
        if (string2.indexOf(46) < 0) {
            string2 = string + "." + string2;
        }
        if (pmiModuleConfig != null) {
            return pmiModuleConfig.getDataId(string2);
        }
        return -1;
    }

    public static PmiModuleConfig[] getConfigs() {
        if (moduleConfigs.size() == 0) {
            PerfModules.initConfigs();
        }
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[moduleConfigs.size()];
        Object[] objectArray = moduleConfigs.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            pmiModuleConfigArray[i] = (PmiModuleConfig)objectArray[i];
        }
        return pmiModuleConfigArray;
    }

    public static synchronized boolean addModuleInfo(String string, String string2) {
        if (moduleConfigs.containsKey(string)) {
            return false;
        }
        PmiModuleConfig pmiModuleConfig = parser.parse(PerfModules.getXmlFileName(string2 + string));
        if (pmiModuleConfig == null) {
            return false;
        }
        moduleConfigs.put(string, pmiModuleConfig);
        return true;
    }

    public static String getGroupName(PerfLevelSpec perfLevelSpec) {
        if (perfLevelSpec == null) {
            return null;
        }
        String string = perfLevelSpec.getModuleName();
        String[] stringArray = perfLevelSpec.getPath();
        if (stringArray != null && stringArray.length > 5 && stringArray[5].equals("beanModule.methods")) {
            return stringArray[5];
        }
        if (stringArray != null && stringArray.length >= 3) {
            if (string.equals("cacheModule") || string.equals("orbPerfModule") || string.equals("wlmModule")) {
                return stringArray[2];
            }
            if (stringArray.length > 3) {
                return stringArray[3];
            }
        }
        return null;
    }

    private static String getXmlFileName(String string) {
        String string2 = "/" + string.replace('.', '/') + ".xml";
        return string2;
    }
}

