/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.extutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.extutils.MultipleObjectNamesExistException;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.HashMap;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminUtilSrvImpl
implements AdminUtil {
    private AdminService as = null;
    private HashMap pmiDescToMbeanDesc = new HashMap();
    private HashMap mbeanDescToPmiDesc = new HashMap();
    private HashMap objectNameCache = new HashMap();
    private static final int BUFFER_LENGTH = 64;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$pmi$extutils$AdminUtilSrvImpl == null ? (class$com$ibm$websphere$pmi$extutils$AdminUtilSrvImpl = AdminUtilSrvImpl.class$("com.ibm.websphere.pmi.extutils.AdminUtilSrvImpl")) : class$com$ibm$websphere$pmi$extutils$AdminUtilSrvImpl), null, (String)"com.ibm.websphere.pmi.property.pmi");
    static /* synthetic */ Class class$com$ibm$websphere$pmi$extutils$AdminUtilSrvImpl;

    public AdminUtilSrvImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AdminUtilSrvImpl");
        }
        this.as = AdminServiceFactory.getAdminService();
        if (this.as != null) {
            PmiRegistry.nodeName = this.as.getNodeName();
            PmiRegistry.serverName = this.as.getProcessName();
        }
    }

    public ObjectName findObjectName(String string, String string2, String string3, String string4) throws MultipleObjectNamesExistException {
        Object object;
        String string5;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findObjectName: type=" + string2 + ", name=" + string));
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*");
        if (string != null) {
            stringBuffer.append(",name=").append(string);
        }
        if ((string5 = AdminServiceFactory.getAdminService().getProcessType()).equals("NodeAgent")) {
            object = AdminServiceFactory.getAdminService().getProcessName();
            String string6 = AdminServiceFactory.getAdminService().getNodeName();
            stringBuffer.append(",process=").append((String)object);
            stringBuffer.append(",node=").append(string6);
        } else if (string5.equals("DeploymentManager")) {
            object = AdminServiceFactory.getAdminService().getProcessName();
            String string7 = AdminServiceFactory.getAdminService().getNodeName();
            stringBuffer.append(",node=").append(string7);
            stringBuffer.append(",process=").append((String)object);
        }
        if (string2 != null) {
            stringBuffer.append(",type=").append(string2);
        }
        if ((object = this.queryName(stringBuffer.toString())) == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0018W", (Object)("findObjectName " + stringBuffer.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findObjectName(String name,String type, String node, String process)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName findObjectName(String string, String string2, String string3) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findObjectName: mbeanIdentifier=" + string));
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*,mbeanIdentifier=").append(string);
        String string4 = AdminServiceFactory.getAdminService().getProcessType();
        if (string4.equals("NodeAgent")) {
            object2 = AdminServiceFactory.getAdminService().getProcessName();
            object = AdminServiceFactory.getAdminService().getNodeName();
            stringBuffer.append(",process=").append((String)object2);
            stringBuffer.append(",node=").append((String)object);
        } else if (string4.equals("DeploymentManager")) {
            object2 = AdminServiceFactory.getAdminService().getProcessName();
            object = AdminServiceFactory.getAdminService().getNodeName();
            stringBuffer.append(",node=").append((String)object);
            stringBuffer.append(",process=").append((String)object2);
        }
        try {
            object = object2 = this.queryName(stringBuffer.toString());
            Object var9_9 = null;
        }
        catch (MultipleObjectNamesExistException multipleObjectNamesExistException) {
            try {
                object = null;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var9_11 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    Tr.exit((TraceComponent)tc, (String)"findObjectName(String mbeanIdentifier)");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findObjectName(String mbeanIdentifier)");
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findObjectName(String mbeanIdentifier)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName queryName(String string) throws MultipleObjectNamesExistException {
        if (string == null) {
            return null;
        }
        ObjectName objectName = (ObjectName)this.objectNameCache.get(string);
        if (objectName == null) {
            Set set = null;
            set = this.findObjectNamesInServer(string);
            if (set == null || set.size() == 0) {
                return null;
            }
            if (set.size() > 1) {
                throw new MultipleObjectNamesExistException("AdminUtilImpl:findObjectName - Supplied parameters were insuffient to make the ObjectName unique: query string= " + string);
            }
            objectName = (ObjectName)set.iterator().next();
            if (objectName != null) {
                HashMap hashMap = this.objectNameCache;
                synchronized (hashMap) {
                    this.objectNameCache.put(string, objectName);
                }
            }
        }
        return objectName;
    }

    private Set findObjectNamesInServer(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findObjectNamesInServer(StringBuffer oName)");
        }
        if (this.as != null) {
            try {
                Set set = this.as.queryNames(new ObjectName(string), null);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findObjectNamesInServer(StringBuffer oName)");
                }
                return set;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.pmi.extutils.findObjectNamesInServer", (String)"191", (Object)this);
                Tr.error((TraceComponent)tc, (String)"PMI0016W", (Object)malformedObjectNameException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.pmi.extutils.findObjectNamesInServer", (String)"196", (Object)this);
                Tr.error((TraceComponent)tc, (String)"PMI0016W", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findObjectNamesInServer(StringBuffer oName)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] findObjectNames(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findObjectNames(String name,String type,String node,String process)");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*");
        if (string != null) {
            stringBuffer.append(",name=").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(",type=").append(string2);
        }
        ObjectName[] objectNameArray = null;
        Set set = null;
        set = this.findObjectNamesInServer(stringBuffer.toString());
        if (set == null || set.size() == 0) {
            Tr.warning((TraceComponent)tc, (String)"PMI0018W", (Object)("findObjectNames " + stringBuffer.toString()));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findObjectNames(String name,String type,String node,String process)");
            }
            return null;
        }
        objectNameArray = new ObjectName[set.size()];
        int n = 0;
        Object object = set.iterator();
        while (object.hasNext()) {
            objectNameArray[n] = (ObjectName)object.next();
            ++n;
        }
        for (n = 0; n < objectNameArray.length; ++n) {
            stringBuffer = new StringBuffer(64);
            stringBuffer.append("WebSphere:*name=");
            if (string == null) {
                stringBuffer.append(objectNameArray[n].getKeyProperty("name"));
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(",type=");
            if (string2 == null) {
                stringBuffer.append(objectNameArray[n].getKeyProperty("type"));
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(",node=");
            if (string3 == null) {
                stringBuffer.append(objectNameArray[n].getKeyProperty("node"));
            } else {
                stringBuffer.append(string3);
            }
            stringBuffer.append(",process=");
            if (string4 == null) {
                stringBuffer.append(objectNameArray[n].getKeyProperty("process"));
            } else {
                stringBuffer.append(string4);
            }
            if (this.objectNameCache.containsKey(stringBuffer.toString())) continue;
            object = this.objectNameCache;
            synchronized (object) {
                this.objectNameCache.put(stringBuffer.toString(), objectNameArray[n]);
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findObjectNames(String name,String type,String node,String process)");
        }
        return objectNameArray;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        return null;
    }

    public Object getAttribute(ObjectName objectName, String string) {
        return null;
    }

    public AdminClient getAdminClient() {
        return null;
    }

    public AdminService getAdminService() {
        return this.as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String string, String string2, DataDescriptor dataDescriptor, MBeanStatDescriptor mBeanStatDescriptor) {
        if (dataDescriptor != null && mBeanStatDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setMapping: dd.toString()=" + dataDescriptor.toString() + ", msd.toString=" + mBeanStatDescriptor.toString()));
            }
            String string3 = PmiJmxMapper.StringArrayToString(dataDescriptor.getPath());
            Object object = this.pmiDescToMbeanDesc;
            synchronized (object) {
                this.pmiDescToMbeanDesc.put(string3, mBeanStatDescriptor);
            }
            object = mBeanStatDescriptor.getIdentifier();
            HashMap hashMap = this.mbeanDescToPmiDesc;
            synchronized (hashMap) {
                this.mbeanDescToPmiDesc.put(object, dataDescriptor);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setMapping: dd=" + dataDescriptor.toString() + ", mBeanKey=" + (String)object));
            }
        }
    }

    public DataDescriptor mBeanDescToPmiDesc_get(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        String string = mBeanStatDescriptor.getIdentifier();
        DataDescriptor dataDescriptor = (DataDescriptor)this.mbeanDescToPmiDesc.get(string);
        if (dataDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cache HIT 1 msd=" + string));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MISS, msd=" + string));
        }
        return dataDescriptor;
    }

    public MBeanStatDescriptor pmiDescToMBeanDesc_get(String string, String string2, DataDescriptor dataDescriptor) {
        String string3 = PmiJmxMapper.StringArrayToString(dataDescriptor.getPath());
        MBeanStatDescriptor mBeanStatDescriptor = (MBeanStatDescriptor)this.pmiDescToMbeanDesc.get(string3);
        if (mBeanStatDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cache HIT 1 dd=" + string3));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MISS, dd=" + string3));
        }
        return mBeanStatDescriptor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

