/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.factory.StatisticActionListener;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdDouble;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdDoubleAggregate;
import com.ibm.ws.pmi.server.data.SpdDoubleImpl;
import com.ibm.ws.pmi.server.data.SpdLoadAggregate;
import com.ibm.ws.pmi.server.data.SpdLoadImpl;
import com.ibm.ws.pmi.server.data.SpdLongAggregate;
import com.ibm.ws.pmi.server.data.SpdLongImpl;
import com.ibm.ws.pmi.server.data.SpdStatAggregate;
import com.ibm.ws.pmi.server.data.SpdStatImpl;
import com.ibm.ws.pmi.server.data.SpdStatisticAggregate;
import com.ibm.ws.pmi.server.data.SpdStatisticExternal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public abstract class PmiAbstractModule
implements PmiModule,
PmiConstants {
    protected String name = null;
    protected String instanceName = null;
    protected String submoduleName = null;
    protected String subinstanceName = null;
    protected String categoryName = null;
    protected ObjectName mbeanName = null;
    protected StatDescriptor sd = null;
    public PmiModuleConfig moduleConfig = null;
    protected int type = 14;
    public int currentLevel = -1;
    protected boolean aggregateModule = false;
    protected PmiCallback callback = null;
    protected StatisticActionListener statisticActionLsnr = null;
    protected HashMap nameDataTable = null;
    protected HashMap dataTable = new HashMap();
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$pmi$server$PmiAbstractModule == null ? (class$com$ibm$websphere$pmi$server$PmiAbstractModule = PmiAbstractModule.class$("com.ibm.websphere.pmi.server.PmiAbstractModule")) : class$com$ibm$websphere$pmi$server$PmiAbstractModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static int SET = 1;
    public static int INCREMENT = 2;
    public static int DECREMENT = 3;
    static /* synthetic */ Class class$com$ibm$websphere$pmi$server$PmiAbstractModule;

    public PmiAbstractModule(String string, String string2) {
        this(null, string, string2, null);
    }

    public PmiAbstractModule(String string, String string2, PmiCallback pmiCallback) {
        this(null, string, string2, pmiCallback);
    }

    public PmiAbstractModule(ObjectName objectName, String string, String string2, PmiCallback pmiCallback) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = string2;
            this.callback = pmiCallback;
            this.mbeanName = objectName;
            this.moduleConfig = PmiRegistry.getConfig(string);
            if (this.moduleConfig == null) {
                Tr.error((TraceComponent)tc, (String)"PMI0007W", (Object)string);
            }
        }
    }

    public PmiAbstractModule(PmiModuleConfig pmiModuleConfig, String string, StatisticActionListener statisticActionListener) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = string;
            this.moduleConfig = pmiModuleConfig;
            this.statisticActionLsnr = statisticActionListener;
        }
    }

    public PmiAbstractModule() {
    }

    public void init(Object[] objectArray) {
    }

    protected void registerModule(PmiModule pmiModule) {
        if (this.moduleConfig != null) {
            PmiRegistry.registerModule(pmiModule);
        }
    }

    protected void unregisterModule(PmiModule pmiModule) {
        this.dataTable = null;
        PmiRegistry.unregisterModule(pmiModule);
    }

    protected boolean longCreated(SpdLong spdLong) {
        return false;
    }

    protected boolean doubleCreated(SpdDouble spdDouble) {
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        return false;
    }

    protected boolean externalStatisticCreated(Statistic statistic) {
        return false;
    }

    protected void callbackRuntime(int n) {
    }

    protected void initializeMe(int n) {
    }

    protected synchronized void putToTable(SpdData spdData) {
        if (spdData == null) {
            return;
        }
        this.dataTable.put(new Integer(spdData.getId()), spdData);
        spdData.setDataInfo(this.moduleConfig);
    }

    protected synchronized void removeFromTable(SpdData spdData) {
        if (spdData == null) {
            return;
        }
        this.dataTable.remove(new Integer(spdData.getId()));
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo.getSubmoduleName() != null && this.type != 13 && this.type != 15 && this.type != 16) {
            return null;
        }
        if (this.type == 15 || this.type == 16) {
            if (pmiDataInfo.getSubmoduleName() == null) {
                return null;
            }
            if (!pmiDataInfo.getSubmoduleName().equals(this.submoduleName)) {
                return null;
            }
        }
        if (this.aggregateModule) {
            return this.createAggregateData(pmiDataInfo);
        }
        if (pmiDataInfo.getType() == 15) {
            return null;
        }
        if (!this.aggregateModule && this.type == 13 && pmiDataInfo.getSubmoduleName() != null) {
            return null;
        }
        if (!pmiDataInfo.getCategory().equals("all") && !this.isInCategory(this.categoryName, pmiDataInfo.getCategory())) {
            return null;
        }
        int n = pmiDataInfo.getId();
        if (pmiDataInfo.isUpdateOnRequest()) {
            SpdStatisticExternal spdStatisticExternal = null;
            if (this.statisticActionLsnr != null) {
                spdStatisticExternal = new SpdStatisticExternal(pmiDataInfo, this.statisticActionLsnr);
                this.externalStatisticCreated(spdStatisticExternal.getStatisticRef());
            }
            return spdStatisticExternal;
        }
        switch (pmiDataInfo.getType()) {
            case 2: {
                SpdLongImpl spdLongImpl = new SpdLongImpl(n);
                this.longCreated(spdLongImpl);
                return spdLongImpl;
            }
            case 3: {
                SpdDoubleImpl spdDoubleImpl = new SpdDoubleImpl(n);
                this.doubleCreated(spdDoubleImpl);
                return spdDoubleImpl;
            }
            case 4: {
                SpdStatImpl spdStatImpl = new SpdStatImpl(n);
                this.statCreated(spdStatImpl);
                return spdStatImpl;
            }
            case 5: {
                SpdLoadImpl spdLoadImpl = new SpdLoadImpl(n);
                this.loadCreated(spdLoadImpl);
                return spdLoadImpl;
            }
        }
        return null;
    }

    private boolean isInCategory(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    protected SpdData createAggregateData(PmiDataInfo pmiDataInfo) {
        if (!pmiDataInfo.isAggregatable()) {
            return null;
        }
        int n = pmiDataInfo.getId();
        if (pmiDataInfo.isUpdateOnRequest()) {
            return new SpdStatisticAggregate(pmiDataInfo);
        }
        switch (pmiDataInfo.getType()) {
            case 2: {
                SpdLongAggregate spdLongAggregate = new SpdLongAggregate(n);
                return spdLongAggregate;
            }
            case 3: {
                SpdDoubleAggregate spdDoubleAggregate = new SpdDoubleAggregate(n);
                return spdDoubleAggregate;
            }
            case 4: {
                SpdStatAggregate spdStatAggregate = new SpdStatAggregate(n);
                return spdStatAggregate;
            }
            case 5: {
                SpdLoadAggregate spdLoadAggregate = new SpdLoadAggregate(n);
                return spdLoadAggregate;
            }
        }
        return null;
    }

    protected void createData(int n) {
        if (this.moduleConfig == null) {
            return;
        }
        if (this.dataTable == null) {
            this.dataTable = new HashMap();
        }
        PmiDataInfo[] pmiDataInfoArray = this.moduleConfig.listData(this.submoduleName);
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            if (pmiDataInfoArray[i].getLevel() > n && (pmiDataInfoArray[i].getType() != 5 || pmiDataInfoArray[i].getLevel() != 7)) continue;
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(pmiDataInfoArray[i].getId()));
            if (spdData != null && pmiDataInfoArray[i].getLevel() <= n) {
                spdData.enable(n);
                continue;
            }
            if (spdData != null || (spdData = this.createOneData(pmiDataInfoArray[i])) == null) continue;
            this.putToTable(spdData);
            if (pmiDataInfoArray[i].getLevel() <= n) {
                spdData.enable(n);
                continue;
            }
            spdData.disable();
        }
    }

    protected synchronized void removeData(int n) {
        if (this.dataTable == null) {
            return;
        }
        Iterator iterator = this.dataTable.values().iterator();
        while (iterator.hasNext()) {
            SpdData spdData = (SpdData)iterator.next();
            if (this.moduleConfig.getDataInfo(spdData.getId()).getLevel() <= n) continue;
            spdData.disable();
        }
    }

    protected synchronized void createNameDataTable() {
        if (this.moduleConfig == null) {
            Tr.error((TraceComponent)tc, (String)"PMI0007W", (Object)this.getModuleID());
            return;
        }
        if (this.nameDataTable != null) {
            return;
        }
        PmiDataInfo[] pmiDataInfoArray = this.moduleConfig.listAllData();
        this.nameDataTable = new HashMap(pmiDataInfoArray.length * 2);
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            this.nameDataTable.put(pmiDataInfoArray[i].getName(), new Integer(pmiDataInfoArray[i].getId()));
        }
    }

    public abstract int getDefaultLevel();

    public abstract String getModuleID();

    public ObjectName getMBeanName() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.mbeanName;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return new MBeanStatDescriptor(this.mbeanName, this.sd);
    }

    public StatDescriptor getStatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.sd;
    }

    public void setMBeanName(ObjectName objectName) {
        this.mbeanName = objectName;
    }

    public void setMBeanName(ObjectName objectName, StatDescriptor statDescriptor) {
        this.mbeanName = objectName;
        this.sd = statDescriptor;
    }

    private void _findMBean() {
        if (this.isCustomModule() || this.mbeanName != null) {
            return;
        }
        MBeanStatDescriptor mBeanStatDescriptor = PmiRegistry.jmxMapper.getMBeanStatDescriptor(null, new DataDescriptor(this.getPath()));
        if (mBeanStatDescriptor != null) {
            this.mbeanName = mBeanStatDescriptor.getObjectName();
            this.sd = mBeanStatDescriptor.getStatDescriptor();
        } else {
            this.sd = new StatDescriptor(this.getPath());
            Tr.warning((TraceComponent)tc, (String)("PMI0006W" + this.getModuleID() + "," + this.getName()));
        }
    }

    public MBeanStatDescriptor[] listStatMembers() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String[] stringArray = this.getPath();
        this.name = stringArray == null || stringArray.length == 0 ? null : stringArray[stringArray.length - 1];
        return this.name;
    }

    public String[] getPath() {
        String[] stringArray = null;
        if (this.type == 13) {
            stringArray = new String[]{this.getModuleID()};
        } else if (this.categoryName == null) {
            if (this.type == 14) {
                stringArray = new String[]{this.getModuleID(), this.instanceName};
            } else if (this.type == 15) {
                stringArray = new String[]{this.getModuleID(), this.instanceName, this.submoduleName};
            } else if (this.type == 16) {
                stringArray = new String[]{this.getModuleID(), this.instanceName, this.submoduleName, this.subinstanceName};
            }
        } else if (this.type == 19) {
            stringArray = new String[]{this.getModuleID(), this.categoryName};
        } else if (this.type == 14) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName};
        } else if (this.type == 15) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName};
        } else if (this.type == 16) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName, this.subinstanceName};
        }
        return stringArray;
    }

    public int getType() {
        return this.type;
    }

    public int getInstrumentationLevel() {
        if (this.currentLevel == 2) {
            return 0;
        }
        return this.currentLevel;
    }

    public synchronized void setInstrumentationLevel(int n) {
        try {
            if (this.moduleConfig == null) {
                Tr.error((TraceComponent)tc, (String)"PMI0007W", (Object)this.getModuleID());
                return;
            }
            if (n == -1) {
                return;
            }
            if (n == this.currentLevel) {
                return;
            }
            if (n < this.currentLevel) {
                this.createData(n);
                this.removeData(n);
            } else if (n > this.currentLevel) {
                this.createData(n);
                this.initializeMe(n);
            }
            this.currentLevel = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void enableData(int n) {
        if (this.dataTable == null) {
            this.dataTable = new HashMap();
        }
        if (this.moduleConfig == null) {
            return;
        }
        if (n == -1) {
            this.setInstrumentationLevel(7);
            return;
        }
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData != null) {
            spdData.enable(this.currentLevel);
        } else {
            PmiDataInfo[] pmiDataInfoArray = this.moduleConfig.listAllData();
            PmiDataInfo pmiDataInfo = null;
            for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                if (pmiDataInfoArray[i].getId() != n) continue;
                pmiDataInfo = pmiDataInfoArray[i];
                break;
            }
            if (pmiDataInfo == null) {
                return;
            }
            if (this.currentLevel == 0) {
                this.currentLevel = 2;
            }
            if ((spdData = this.createOneData(pmiDataInfo)) != null) {
                this.putToTable(spdData);
            }
        }
    }

    public synchronized void disableData(int n) {
        if (this.dataTable == null) {
            return;
        }
        if (n == -1) {
            this.setInstrumentationLevel(0);
        } else {
            SpdData[] spdDataArray;
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
            if (spdData != null) {
                spdData.disable();
            }
            if (((spdDataArray = this.listData()) == null || spdDataArray.length == 0) && this.type != 13 && this.type != 15) {
                this.currentLevel = 0;
            }
        }
    }

    public SpdData[] listData() {
        SpdData[] spdDataArray;
        if (this.dataTable == null || this.currentLevel <= 0) {
            return null;
        }
        Iterator iterator = this.dataTable.values().iterator();
        ArrayList<SpdData[]> arrayList = new ArrayList<SpdData[]>();
        while (iterator.hasNext()) {
            spdDataArray = (SpdData[])iterator.next();
            if (!spdDataArray.isEnabled()) continue;
            arrayList.add(spdDataArray);
        }
        spdDataArray = new SpdData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            spdDataArray[i] = (SpdData)arrayList.get(i);
        }
        return spdDataArray;
    }

    public SpdData listData(int n) {
        if (this.dataTable == null) {
            return null;
        }
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData != null && spdData.isEnabled()) {
            return spdData;
        }
        return null;
    }

    public SpdData[] listData(int[] nArray) {
        if (this.dataTable == null || this.currentLevel <= 0) {
            return null;
        }
        if (nArray == null) {
            return this.listData();
        }
        ArrayList<SpdData> arrayList = new ArrayList<SpdData>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(nArray[i]));
            if (spdData == null || !spdData.isEnabled()) continue;
            arrayList.add(spdData);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SpdData[] spdDataArray = new SpdData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            spdDataArray[i] = (SpdData)arrayList.get(i);
        }
        return spdDataArray;
    }

    public ArrayList listStatistics() {
        if (this.dataTable == null || this.currentLevel <= 0) {
            return null;
        }
        Iterator iterator = this.dataTable.values().iterator();
        ArrayList<Statistic> arrayList = new ArrayList<Statistic>();
        while (iterator.hasNext()) {
            SpdData spdData = (SpdData)iterator.next();
            if (!spdData.isEnabled()) continue;
            arrayList.add(spdData.getStatistic());
        }
        return arrayList;
    }

    public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
        return new StatsImpl(this.getName(), this.type, this.currentLevel, arrayList, arrayList2);
    }

    public void updateData(int n, int n2, double d) {
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        this.updateData(spdData, n2, d);
    }

    public void updateData(String string, int n, double d) {
        if (this.nameDataTable == null) {
            this.createNameDataTable();
            if (this.nameDataTable == null) {
                return;
            }
        }
        Integer n2 = (Integer)this.nameDataTable.get(string);
        SpdData spdData = (SpdData)this.dataTable.get(n2);
        this.updateData(spdData, n, d);
    }

    public void updateData(SpdData spdData, int n, double d) {
        if (spdData == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0005W", (Object)("PmiAbstractModule.updateData, moduleID=" + this.getModuleID()));
            return;
        }
        if (spdData instanceof SpdLong) {
            if (n == SET) {
                ((SpdLong)spdData).set((long)d);
            } else if (n == INCREMENT) {
                ((SpdLong)spdData).increment((long)d);
            } else if (n == DECREMENT) {
                ((SpdLong)spdData).decrement((long)d);
            } else {
                Tr.warning((TraceComponent)tc, (String)"PMI0009W", (Object)"opType");
            }
        } else if (spdData instanceof SpdLoad) {
            if (n == SET) {
                ((SpdLoad)spdData).add(d);
            } else if (n == INCREMENT) {
                ((SpdLoad)spdData).increment(d);
            } else if (n == DECREMENT) {
                ((SpdLoad)spdData).decrement(d);
            } else {
                Tr.warning((TraceComponent)tc, (String)"PMI0009W", (Object)"opType");
            }
        } else if (spdData instanceof SpdStat) {
            if (n == SET) {
                ((SpdStat)spdData).add(d);
            } else {
                Tr.warning((TraceComponent)tc, (String)"PMI0009W", (Object)"opType");
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"PMI0009W", (Object)"dataType");
        }
    }

    public void cleanup() {
        if (this.mbeanName != null) {
            PmiRegistry.removeMBeanToModuleMap(new MBeanStatDescriptor(this.mbeanName, this.sd));
        }
        if (this.isCustomModule()) {
            StatsFactoryUtil.deactivateMBean(this.mbeanName);
        }
        if (this.dataTable != null) {
            this.dataTable.clear();
            this.dataTable = null;
        }
        if (this.nameDataTable != null) {
            this.nameDataTable.clear();
            this.nameDataTable = null;
        }
        this.instanceName = null;
        this.subinstanceName = null;
        this.categoryName = null;
        this.mbeanName = null;
        this.sd = null;
        this.moduleConfig = null;
        this.callback = null;
    }

    public void unregister() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unregister " + this.getModuleID() + ", " + this.getName()));
        }
        PmiRegistry.unregisterModule(this);
        this.currentLevel = 0;
        this.cleanup();
    }

    public boolean isCustomModule() {
        return false;
    }

    public PmiModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    protected void setStatisticEnabled(int n, boolean bl) {
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (bl) {
            if (spdData != null && !spdData.isEnabled()) {
                spdData.enable(15);
            }
        } else if (spdData != null) {
            spdData.disable();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

