/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.CountStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class CountStatisticImpl
extends StatisticImpl
implements CountStatistic {
    protected long count = 0L;
    private CountStatisticImpl baseValue = null;

    public CountStatisticImpl(int n) {
        super(n);
    }

    public CountStatisticImpl(int n, long l, long l2, long l3) {
        super(n, null, null, null, l2, l3);
        this.count = l;
    }

    public CountStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0L;
    }

    public void set(long l, long l2, long l3) {
        this.count = l;
        this.startTime = l2;
        this.lastSampleTime = l3;
    }

    public long getCount() {
        return this.count;
    }

    public void combine(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statistic;
        this.count += countStatisticImpl.count;
    }

    public void setCount(long l) {
        if (!this.enabled) {
            return;
        }
        this.count = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            ++this.count;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long l) {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            this.count += l;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            --this.count;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                --this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(long l) {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            this.count -= l;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= l;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("CountStatisticImpl: ");
        stringBuffer.append(super.toString(""));
        stringBuffer.append(" count=");
        stringBuffer.append(this.count);
        return stringBuffer.toString();
    }

    public void update(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statistic;
        if (this.baseValue == null) {
            this.count = countStatisticImpl.getCount();
            this.startTime = countStatisticImpl.getStartTime();
        } else {
            this.count = countStatisticImpl.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = countStatisticImpl.lastSampleTime;
    }

    public Statistic delta(Statistic statistic) {
        if (!this.validate(statistic)) {
            return null;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statistic;
        CountStatisticImpl countStatisticImpl2 = new CountStatisticImpl(this.id);
        countStatisticImpl2.count = this.count - countStatisticImpl.getCount();
        countStatisticImpl2.startTime = this.startTime;
        countStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return countStatisticImpl2;
    }

    public void resetOnClient(Statistic statistic) {
        if (statistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new CountStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(statistic)) {
            this.baseValue = (CountStatisticImpl)statistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic statistic) {
        if (statistic == null) {
            return false;
        }
        if (!(statistic instanceof CountStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be CountStatisticImpl");
            return false;
        }
        if (statistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + statistic.getId());
            return false;
        }
        return true;
    }
}

