/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.RangeStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic {
    protected long highWaterMark = -1L;
    protected long lowWaterMark = -1L;
    protected long current = 0L;
    protected long integral = 0L;
    private RangeStatisticImpl baseValue = null;

    public RangeStatisticImpl(int n) {
        super(n);
    }

    public RangeStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public RangeStatisticImpl(int n, long l, long l2, long l3, long l4, long l5, long l6) {
        super(n, null, null, null, l5, l6);
        this.lowWaterMark = l;
        this.highWaterMark = l2;
        this.current = l3;
        this.integral = l4;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.integral = 0L;
        this.lowWaterMark = -1L;
        this.highWaterMark = -1L;
    }

    public void set(long l, long l2, long l3, long l4, long l5, long l6) {
        this.current = l3;
        this.integral = l4;
        this.lowWaterMark = l;
        this.highWaterMark = l2;
        this.startTime = l5;
        this.lastSampleTime = l6;
    }

    public void setWaterMark(long l) {
        this.setWaterMark(l, System.currentTimeMillis());
    }

    protected void setWaterMark(long l, long l2) {
        this.lastSampleTime = l2;
        if (l < this.lowWaterMark || this.lowWaterMark < 0L) {
            this.lowWaterMark = l;
        }
        if (l > this.highWaterMark) {
            this.highWaterMark = l;
        }
        this.current = l;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getIntegral() {
        return this.integral;
    }

    public double getMean() {
        long l = this.lastSampleTime - this.startTime;
        if (l > 0L) {
            return (double)this.integral * 1.0 / (double)l;
        }
        return 0.0;
    }

    public void add(long l) {
        if (this.current == l) {
            return;
        }
        if (this.enabled) {
            long l2 = this.myupdate();
            this.setWaterMark(l, l2);
        } else {
            this.current = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long l = this.myupdate();
                this.setWaterMark(this.current + 1L, l);
            }
        } else {
            ++this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long l) {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long l2 = this.myupdate();
                this.setWaterMark(this.current + l, l2);
            }
        } else {
            this.current += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long l = this.myupdate();
                this.setWaterMark(this.current - 1L, l);
            }
        } else {
            --this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(long l) {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long l2 = this.myupdate();
                this.setWaterMark(this.current - l, l2);
            }
        } else {
            this.current -= l;
        }
    }

    public void add(long l, long l2) {
        if (this.current == l2) {
            return;
        }
        if (this.enabled) {
            this.myupdate(l);
            this.setWaterMark(l2, l);
        } else {
            this.current = l2;
        }
    }

    public void increment(long l, long l2) {
        if (this.enabled) {
            this.myupdate(l);
            this.setWaterMark(this.current + l2, l);
        } else {
            this.current += l2;
        }
    }

    public void decrement(long l, long l2) {
        if (this.enabled) {
            this.myupdate(l);
            this.setWaterMark(this.current - l2, l);
        } else {
            this.current -= l2;
        }
    }

    public long myupdate(long l) {
        long l2 = l - this.lastSampleTime;
        this.integral += l2 * this.current;
        return l;
    }

    public long myupdate() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastSampleTime;
        this.integral += l2 * this.current;
        return l;
    }

    public void setLastValue(long l) {
        this.current = l;
    }

    public void combine(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statistic;
        this.current += rangeStatisticImpl.current;
        long l = rangeStatisticImpl.myupdate();
        rangeStatisticImpl.setLastSampleTime(l);
        double d = (double)rangeStatisticImpl.getIntegral() * 1.0 / (double)(l - rangeStatisticImpl.getStartTime());
        this.integral += (long)(d * (double)(l - this.startTime));
        this.lastSampleTime = l;
    }

    public void cleanup() {
        this.current = 0L;
        this.integral = 0L;
        this.lastSampleTime = 0L;
        this.lowWaterMark = -1L;
        this.highWaterMark = -1L;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(super.toString(""));
        stringBuffer.append(" lowWaterMark=");
        stringBuffer.append(this.lowWaterMark);
        stringBuffer.append(" highWaterMark=");
        stringBuffer.append(this.highWaterMark);
        stringBuffer.append(" current=");
        stringBuffer.append(this.current);
        stringBuffer.append(" integral=");
        stringBuffer.append(this.integral);
        return stringBuffer.toString();
    }

    public void update(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statistic;
        if (this.baseValue == null) {
            this.integral = rangeStatisticImpl.integral;
            this.startTime = rangeStatisticImpl.startTime;
        } else {
            this.integral = rangeStatisticImpl.integral - this.baseValue.integral;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.current = rangeStatisticImpl.current;
        this.lowWaterMark = rangeStatisticImpl.lowWaterMark;
        this.highWaterMark = rangeStatisticImpl.highWaterMark;
        this.lastSampleTime = rangeStatisticImpl.lastSampleTime;
    }

    public Statistic delta(Statistic statistic) {
        if (!this.validate(statistic)) {
            return null;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statistic;
        RangeStatisticImpl rangeStatisticImpl2 = new RangeStatisticImpl(this.id);
        rangeStatisticImpl2.current = rangeStatisticImpl.current;
        rangeStatisticImpl2.integral = this.integral - rangeStatisticImpl.integral;
        rangeStatisticImpl2.startTime = rangeStatisticImpl.lastSampleTime;
        rangeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return rangeStatisticImpl2;
    }

    public void resetOnClient(Statistic statistic) {
        if (statistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new RangeStatisticImpl(this.id);
            }
            this.baseValue.set(this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(statistic)) {
            this.baseValue = (RangeStatisticImpl)statistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic statistic) {
        if (statistic == null) {
            return false;
        }
        if (!(statistic instanceof RangeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be CountStatistic");
            return false;
        }
        if (statistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + statistic.getId());
            return false;
        }
        return true;
    }
}

