/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import java.io.Serializable;

public class StatDescriptor
implements Serializable {
    public static final long serialVersionUID = -2844135786824830882L;
    String[] subPath;
    int dataId = -1;

    public StatDescriptor(String[] stringArray) {
        this.subPath = stringArray;
    }

    public StatDescriptor(String[] stringArray, int n) {
        this.subPath = stringArray;
        this.dataId = n;
    }

    public String[] getPath() {
        return this.subPath;
    }

    public String getName() {
        if (this.subPath == null || this.subPath.length == 0) {
            return null;
        }
        return this.subPath[this.subPath.length - 1];
    }

    public int getDataId() {
        return this.dataId;
    }

    public int getType() {
        if (this.dataId == -1) {
            return 17;
        }
        return 18;
    }

    public boolean isSame(StatDescriptor statDescriptor) {
        if (statDescriptor == null) {
            return false;
        }
        String[] stringArray = statDescriptor.getPath();
        if (this.subPath == null && stringArray == null) {
            return true;
        }
        if (this.subPath == null || stringArray == null) {
            return false;
        }
        if (this.subPath.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < this.subPath.length; ++i) {
            if (this.subPath[i].equals(stringArray[i])) continue;
            return false;
        }
        return this.dataId == statDescriptor.getDataId();
    }

    public String toString() {
        if (this.subPath == null || this.subPath.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.subPath.length; ++i) {
            stringBuffer.append(this.subPath[i]);
            if (i >= this.subPath.length - 1) continue;
            stringBuffer.append("/");
        }
        if (this.dataId > 0) {
            stringBuffer.append("/").append(this.dataId);
        }
        return stringBuffer.toString();
    }
}

