/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.ws.pmi.server.PmiUtil;
import java.io.Serializable;

public abstract class StatisticImpl
implements Statistic,
Serializable {
    public static final long serialVersionUID = 1358353157061734347L;
    int id;
    long startTime = 0L;
    long lastSampleTime = 0L;
    transient boolean enabled = true;
    transient boolean sync = false;
    transient Object syncObj = new Object();
    transient PmiDataInfo dataInfo = null;

    public StatisticImpl(int n) {
        this.id = n;
        this.lastSampleTime = this.startTime = PmiUtil.currentTime();
    }

    public StatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        this.id = n;
        this.startTime = l;
        this.lastSampleTime = l2;
        l = PmiUtil.currentTime();
    }

    public void enable(int n) {
        this.sync = n >= 15;
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
        this.sync = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.lastSampleTime = this.startTime = PmiUtil.currentTime();
        this.lastSampleTime = this.startTime;
    }

    public void setDataInfo(PmiModuleConfig pmiModuleConfig) {
        if (pmiModuleConfig != null) {
            this.dataInfo = pmiModuleConfig.getDataInfo(this.id);
        }
    }

    public void setDataInfo(PmiDataInfo pmiDataInfo) {
        this.dataInfo = pmiDataInfo;
    }

    public void setLastSampleTime(long l) {
        this.lastSampleTime = l;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public int getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public String getName() {
        if (this.dataInfo != null) {
            return this.dataInfo.getName();
        }
        return null;
    }

    public String getUnit() {
        if (this.dataInfo != null) {
            return this.dataInfo.getUnit();
        }
        return null;
    }

    public String getDescription() {
        if (this.dataInfo != null) {
            return this.dataInfo.getDescription();
        }
        return null;
    }

    public PmiDataInfo getDataInfo() {
        return this.dataInfo;
    }

    public String toXML() {
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("id=");
        stringBuffer.append(this.id);
        stringBuffer.append(" name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(" description=");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(" unit=");
        stringBuffer.append(this.getUnit());
        stringBuffer.append(" startTime=");
        stringBuffer.append(this.startTime);
        return stringBuffer.toString();
    }

    public abstract void update(Statistic var1);

    public abstract Statistic delta(Statistic var1);

    public abstract void combine(Statistic var1);

    public abstract void resetOnClient(Statistic var1);
}

