/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.TimeStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    protected long count = 0L;
    protected long min = -1L;
    protected long max = -1L;
    protected long total = 0L;
    protected long sumOfSquares = 0L;
    private TimeStatisticImpl baseValue = null;

    public TimeStatisticImpl(int n) {
        super(n);
    }

    public TimeStatisticImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(0);
        this.set(n, n2, n3, n4, n5, n6, n7);
    }

    public TimeStatisticImpl(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        super(n);
        this.set(l, l2, l3, l4, l5, l6, l7);
    }

    public TimeStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public void setDataId(int n) {
        this.id = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long l) {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            if (l > this.max) {
                this.max = l;
            }
            if (l < this.min || this.min < 0L) {
                this.min = l;
            }
            ++this.count;
            this.total += l;
            this.sumOfSquares += l * l;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                if (l > this.max) {
                    this.max = l;
                }
                if (l < this.min || this.min < 0L) {
                    this.min = l;
                }
                ++this.count;
                this.total += l;
                this.sumOfSquares += l * l;
            }
        }
    }

    public void set(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        this.count = l;
        this.min = l2;
        this.max = l3;
        this.total = l4;
        this.sumOfSquares = l5;
        this.startTime = l6;
        this.lastSampleTime = l7;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0L;
        this.total = 0L;
        this.sumOfSquares = 0L;
        this.min = -1L;
        this.max = -1L;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return (double)this.total * 1.0 / (double)this.count;
    }

    public long getTotalTime() {
        return this.total;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getMinTime() {
        return this.min;
    }

    public long getMaxTime() {
        return this.max;
    }

    public long getSumOfSquares() {
        return this.sumOfSquares;
    }

    public void combine(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statistic;
        this.count += timeStatisticImpl.count;
        this.total += timeStatisticImpl.total;
        this.sumOfSquares += timeStatisticImpl.sumOfSquares;
        if (this.min > timeStatisticImpl.min || this.min < 0L) {
            this.min = timeStatisticImpl.min;
        }
        if (this.max < timeStatisticImpl.max) {
            this.max = timeStatisticImpl.max;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("TimeStatisticImpl: ");
        stringBuffer.append(super.toString(""));
        stringBuffer.append(" min=");
        stringBuffer.append(this.min);
        stringBuffer.append(" max=");
        stringBuffer.append(this.max);
        stringBuffer.append(" count=");
        stringBuffer.append(this.count);
        stringBuffer.append(" total=");
        stringBuffer.append(this.total);
        stringBuffer.append(" sumOfSquares=");
        stringBuffer.append(this.sumOfSquares);
        return stringBuffer.toString();
    }

    public void update(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statistic;
        if (this.baseValue == null) {
            this.count = timeStatisticImpl.getCount();
            this.total = timeStatisticImpl.getTotal();
            this.sumOfSquares = timeStatisticImpl.sumOfSquares;
            this.startTime = timeStatisticImpl.getStartTime();
        } else {
            this.count -= timeStatisticImpl.getCount();
            this.total -= timeStatisticImpl.getTotal();
            this.sumOfSquares -= timeStatisticImpl.getSumOfSquares();
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.min = timeStatisticImpl.getMin();
        this.max = timeStatisticImpl.getMax();
        this.lastSampleTime = timeStatisticImpl.getLastSampleTime();
    }

    public Statistic delta(Statistic statistic) {
        if (!this.validate(statistic)) {
            return null;
        }
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statistic;
        TimeStatisticImpl timeStatisticImpl2 = new TimeStatisticImpl(this.id);
        timeStatisticImpl2.min = this.min;
        timeStatisticImpl2.max = this.max;
        timeStatisticImpl2.count = this.count - timeStatisticImpl.getCount();
        timeStatisticImpl2.total = this.total - timeStatisticImpl.getTotal();
        timeStatisticImpl2.sumOfSquares = this.sumOfSquares - timeStatisticImpl.sumOfSquares;
        timeStatisticImpl2.startTime = this.startTime;
        timeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return timeStatisticImpl2;
    }

    public void resetOnClient(Statistic statistic) {
        if (statistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new TimeStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(statistic)) {
            this.baseValue = (TimeStatisticImpl)statistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic statistic) {
        if (statistic == null) {
            return false;
        }
        if (!(statistic instanceof TimeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be TimeStatisticImpl");
            return false;
        }
        if (statistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + statistic.getId());
            return false;
        }
        return true;
    }
}

