/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.pmi.factory.StatsFactoryException;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.Properties;
import javax.management.ObjectName;

public class StatsFactoryUtil {
    public static final String DEFAULT_MBEAN = "CustomStats";
    private static final String DEFAULT_MBEAN_DESCRIPTOR = "com/ibm/ws/pmi/factory/CustomStats.xml";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$factory$StatsFactoryUtil == null ? (class$com$ibm$ws$pmi$factory$StatsFactoryUtil = StatsFactoryUtil.class$("com.ibm.ws.pmi.factory.StatsFactoryUtil")) : class$com$ibm$ws$pmi$factory$StatsFactoryUtil), null, (String)"com.ibm.websphere.pmi.property.pmi");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.pmi.property.pmi");
    static /* synthetic */ Class class$com$ibm$ws$pmi$factory$StatsFactoryUtil;

    public static MBeanStatDescriptor createMBean(Object object, String string, ObjectName objectName, boolean bl) throws StatsFactoryException {
        if (objectName != null) {
            return new MBeanStatDescriptor(objectName);
        }
        if (bl) {
            return new MBeanStatDescriptor(StatsFactoryUtil.createDefaultMBean(object, string));
        }
        return null;
    }

    private static ObjectName createDefaultMBean(Object object, String string) throws StatsFactoryException {
        try {
            String[] stringArray = ((PmiAbstractModule)object).getPath();
            Properties properties = new Properties();
            properties.put("name", string);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(object, string);
            return mBeanFactory.activateMBean(DEFAULT_MBEAN, (RuntimeCollaborator)defaultRuntimeCollaborator, StatsFactoryUtil.getMBeanID(stringArray), DEFAULT_MBEAN_DESCRIPTOR, properties);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"PMI0101W", (Object)string);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0101W", new Object[]{string}, "Unable to create default MBean for custom PMI module: {0}"));
        }
    }

    public static void registerModule(PmiModule pmiModule, MBeanStatDescriptor mBeanStatDescriptor) throws StatsFactoryException {
        ModuleItem moduleItem = PmiRegistry.registerModule(pmiModule);
        if (moduleItem == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0103W", (Object)pmiModule.getName());
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0103W", new Object[]{pmiModule.getName()}, "Unable to register custom PMI module due to duplicate name under the same parent or invalid PMI tree path: {0}"));
        }
        if (mBeanStatDescriptor == null) {
            ObjectName objectName = moduleItem.getParentMBean();
            if (objectName.getKeyProperty("type").equals("Server")) {
                mBeanStatDescriptor = new MBeanStatDescriptor(objectName, new StatDescriptor(pmiModule.getPath()));
            } else {
                String[] stringArray;
                String[] stringArray2 = PmiRegistry.findModuleItem(objectName).getInstance().getPath();
                if (stringArray2.length < (stringArray = pmiModule.getPath()).length) {
                    int n = stringArray.length - stringArray2.length;
                    String[] stringArray3 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray3[i] = stringArray[i + stringArray2.length];
                    }
                    mBeanStatDescriptor = new MBeanStatDescriptor(objectName, new StatDescriptor(stringArray3));
                }
            }
        }
        if (mBeanStatDescriptor == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0104W", (Object)pmiModule.getName());
            PmiRegistry.unregisterModule(moduleItem.getInstance());
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0104W", new Object[]{pmiModule.getName()}, "Cannot locate a parent MBean for the custom PMI module: {0}"));
        }
        StatsFactoryUtil.setMBeanMapping(moduleItem, mBeanStatDescriptor);
    }

    public static void setMBeanMapping(ModuleItem moduleItem, MBeanStatDescriptor mBeanStatDescriptor) {
        PmiRegistry.setMBeanToModuleMap(moduleItem, mBeanStatDescriptor);
    }

    public static void setMBeanMapping(ModuleItem moduleItem, ObjectName objectName) {
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(objectName);
        PmiRegistry.setMBeanToModuleMap(moduleItem, mBeanStatDescriptor);
    }

    private static String getMBeanID(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("#").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void unRegisterStats(PmiModule pmiModule, ObjectName objectName) throws StatsFactoryException {
        PmiRegistry.unregisterModule(pmiModule);
    }

    public static void deactivateMBean(ObjectName objectName) {
        String string;
        if (objectName != null && (string = objectName.getKeyProperty("type")).equals(DEFAULT_MBEAN)) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"PMI0201I", (Object)objectName.getKeyProperty("name"));
                }
                AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)tc, (String)"PMI0106W", (Object)exception.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

