/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleConfigParser
extends DefaultHandler
implements PmiConstants {
    public static final String STATS_DTD = "/com/ibm/websphere/pmi/xml/stats.dtd";
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.pmi.validateDescriptors";
    private PmiModuleConfig oneModule = null;
    private PmiDataInfo currentData;
    private PmiDataInfo submoduleData;
    private String currentChars = null;
    private final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$ModuleConfigParser == null ? (class$com$ibm$ws$pmi$server$ModuleConfigParser = ModuleConfigParser.class$("com.ibm.ws.pmi.server.ModuleConfigParser")) : class$com$ibm$ws$pmi$server$ModuleConfigParser), null, (String)"com.ibm.websphere.pmi.property.pmi");
    private String submoduleName = null;
    private boolean isModule = true;
    private Locator locator = null;
    private static String PERF_MODULE = "PerfModule";
    private static String STATS = "Stats";
    private static String PERF_LONG = "PerfLong";
    private static String COUNT_STAT = "CountStatistic";
    private static String PERF_DOUBLE = "PerfDouble";
    private static String DOUBLE_STAT = "DoubleStatistic";
    private static String PERF_LOAD = "PerfLoad";
    private static String BOUNDED_RANGE_STAT = "BoundedRangeStatistic";
    private static String PERF_STAT = "PerfStat";
    private static String TIME_STAT = "TimeStatistic";
    private static String PERF_SUBMODULE = "PerfSubModule";
    private static String UID = "UID";
    private static String DESCRIPTION = "description";
    private static String NAME = "name";
    private static String LEVEL = "level";
    private static String UNIT = "unit";
    private static String RESETTABLE = "resettable";
    private static String AGGREGATABLE = "aggregatable";
    private static String ON_REQUEST = "updateOnRequest";
    private static String CATEGORY = "category";
    private static String COMMENT = "comment";
    private static String MBEAN_TYPE = "mBeanType";
    private static String STATS_NLS_FILE = "resourceBundle";
    private static String TYPE = "type";
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$ModuleConfigParser;

    public PmiModuleConfig parse(String string) {
        return this.loadDescriptor(string, false);
    }

    public PmiModuleConfig parse(String string, boolean bl) {
        return this.loadDescriptor(string, bl);
    }

    public PmiModuleConfig loadDescriptor(String string, boolean bl) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"loadDescriptor", (Object)(string + ";DTD Validate=" + bl));
        }
        this.oneModule = null;
        this.currentData = null;
        this.submoduleName = null;
        this.submoduleData = null;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            Tr.error((TraceComponent)this.tc, (String)"PMI0010W", (Object)string);
            return null;
        }
        try {
            XMLReader xMLReader = ParserFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            xMLReader.setEntityResolver(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (Exception exception) {
            if (this.tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", (String)"97", (Object)this);
            return null;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"loadDescriptor");
        }
        return this.oneModule;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"resolveEntity", (Object)string2);
        }
        InputSource inputSource = null;
        try {
            if (string2.endsWith("stats.dtd")) {
                InputStream inputStream = this.getClass().getResourceAsStream(STATS_DTD);
                inputSource = new InputSource(inputStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.server.ModuleConfigParser.resolveEntity", (String)"126", (Object)this);
            Tr.error((TraceComponent)this.tc, (String)"PMI0010W", (Object)string2);
            return null;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"resolveEntity");
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"error", (Object)sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"startDocument");
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"endDocument");
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"endDocument");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)("startElement, localpart=" + string2));
        }
        if (string3.equals(PERF_MODULE)) {
            this.isModule = true;
            String string4 = attributes.getValue(UID);
            this.oneModule = new PmiModuleConfig(string4);
            return;
        }
        if (string3.equals(STATS)) {
            this.isModule = true;
            String string5 = attributes.getValue(TYPE);
            this.oneModule = new PmiModuleConfig(string5);
            return;
        }
        if (!string3.equals(DESCRIPTION) && !string3.equals(STATS_NLS_FILE)) {
            if (string3.equals(PERF_LONG) || string3.equals(PERF_LOAD) || string3.equals(PERF_STAT) || string3.equals(PERF_DOUBLE) || string3.equals(COUNT_STAT) || string3.equals(BOUNDED_RANGE_STAT) || string3.equals(TIME_STAT) || string3.equals(DOUBLE_STAT) || string3.equals(PERF_SUBMODULE)) {
                this.isModule = false;
                int n = Integer.parseInt(attributes.getValue("ID"));
                this.currentData = new PmiDataInfo(n);
                this.currentData.setName(attributes.getValue(NAME));
                this.currentData.setSubmoduleName(this.submoduleName);
                if (string3.equals(PERF_LONG) || string3.equals(COUNT_STAT)) {
                    this.currentData.setType(2);
                } else if (string3.equals(PERF_LOAD) || string3.equals(BOUNDED_RANGE_STAT)) {
                    this.currentData.setType(5);
                } else if (string3.equals(PERF_STAT) || string3.equals(TIME_STAT)) {
                    this.currentData.setType(4);
                } else if (string3.equals(PERF_DOUBLE) || string3.equals(DOUBLE_STAT)) {
                    this.currentData.setType(3);
                } else if (string3.equals(PERF_SUBMODULE)) {
                    this.currentData.setType(15);
                    this.submoduleName = this.currentData.getName();
                }
                this.oneModule.addData(this.currentData);
            } else if (string3.equals(LEVEL) || string3.equals(CATEGORY) || string3.equals(UNIT) || string3.equals(AGGREGATABLE) || string3.equals(RESETTABLE) || string3.equals(COMMENT)) {
                // empty if block
            }
        }
        this.currentChars = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("endElement={uri=" + string + ", localpart=" + string2 + ", rawName=" + string3 + ", chars=" + this.currentChars + '}'));
        }
        if (!string3.equals(PERF_MODULE) && !string3.equals(STATS)) {
            if (string3.equals(DESCRIPTION)) {
                if (this.isModule) {
                    this.oneModule.setDescription(this.currentChars);
                } else {
                    this.currentData.setDescription(this.currentChars);
                }
            } else if (string3.equals(STATS_NLS_FILE)) {
                if (this.isModule) {
                    this.oneModule.setResourceBundle(this.currentChars);
                }
            } else if (!(string3.equals(PERF_LONG) || string3.equals(PERF_LOAD) || string3.equals(PERF_STAT) || string3.equals(PERF_DOUBLE) || string3.equals(COUNT_STAT) || string3.equals(BOUNDED_RANGE_STAT) || string3.equals(TIME_STAT) || string3.equals(DOUBLE_STAT))) {
                if (string3.equals(PERF_SUBMODULE)) {
                    this.submoduleName = null;
                } else if (string3.equals(LEVEL)) {
                    if (this.currentChars.equals("low")) {
                        this.currentData.setLevel(1);
                    } else if (this.currentChars.equals("medium")) {
                        this.currentData.setLevel(3);
                    } else if (this.currentChars.equals("high")) {
                        this.currentData.setLevel(7);
                    } else if (this.currentChars.equals("maximum")) {
                        this.currentData.setLevel(15);
                    } else {
                        this.currentData.setLevel(1000);
                    }
                } else if (string3.equals(CATEGORY)) {
                    this.currentData.setCategory(this.currentChars);
                } else if (string3.equals(UNIT)) {
                    this.currentData.setUnit(this.currentChars);
                } else if (string3.equals(RESETTABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setResettable(false);
                    }
                } else if (string3.equals(AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setAggregatable(false);
                    }
                } else if (string3.equals(COMMENT)) {
                    this.currentData.setComment(this.currentChars);
                } else if (string3.equals(ON_REQUEST)) {
                    if (this.currentChars.equals("true")) {
                        this.currentData.setOnRequest(true);
                    }
                } else if (string3.equals(MBEAN_TYPE)) {
                    this.oneModule.setMbeanType(this.currentChars);
                    if (this.isModule) {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, null, this.currentChars);
                    } else {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, this.currentData.getName(), this.currentChars);
                    }
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"characters");
        }
        String string = new String(cArray, n, n2);
        this.currentChars = this.currentChars == null ? string : this.currentChars + string;
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"characters", (Object)this.currentChars);
        }
    }

    private String getXmlFileName(String string) {
        String string2 = "/" + string.replace('.', '/') + ".xml";
        return string2;
    }

    public static void main(String[] stringArray) {
        ModuleConfigParser moduleConfigParser = new ModuleConfigParser();
        moduleConfigParser.parse("/com/ibm/websphere/pmi/custom/test/PmiServletModule1.xml", true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

