/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PmiJmxMapParser
extends DefaultHandler
implements PmiConstants {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$PmiJmxMapParser == null ? (class$com$ibm$ws$pmi$server$PmiJmxMapParser = PmiJmxMapParser.class$("com.ibm.ws.pmi.server.PmiJmxMapParser")) : class$com$ibm$ws$pmi$server$PmiJmxMapParser), null, (String)"com.ibm.websphere.pmi.property.pmi");
    private static final String MAPPER = "Mapper";
    private static final String MBEAN_TYPE = "mbeanType";
    private static final String PERF_MODULE = "perfModule";
    private static final String PERF_SUBMODULE = "perfSubmodule";
    private static final String MODULE_ONLY = "moduleOnly";
    private PmiJmxMapper jmxMapper = null;
    private String mbeanType = null;
    private String perfModule = null;
    private String perfInstance = null;
    private String perfSubmodule = null;
    private boolean isModuleOnlyMapping = false;
    private String currentChars = null;
    private Locator locator = null;
    private InputStream istream;
    private XMLReader parser;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$PmiJmxMapParser;

    public PmiJmxMapParser(PmiJmxMapper pmiJmxMapper) {
        this.jmxMapper = pmiJmxMapper;
    }

    private void reInit() {
        this.mbeanType = null;
        this.perfModule = null;
        this.perfInstance = null;
        this.perfSubmodule = null;
        this.isModuleOnlyMapping = false;
        this.currentChars = null;
        this.locator = null;
    }

    public void parse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parse", (Object)string);
        }
        final String string2 = string;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                PmiJmxMapParser.this.istream = this.getClass().getResourceAsStream(string2);
                try {
                    PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
        this._parse(this.istream, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parse");
        }
    }

    public void parseExtensions() {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("pmiJmxMapperExtension.xml");
                    while (enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Loading pmiJmxMapperExtension: " + uRL.getFile()));
                        }
                        PmiJmxMapParser.this.istream = uRL.openStream();
                        PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                        PmiJmxMapParser.this._parse(PmiJmxMapParser.this.istream, uRL.getFile());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    private void _parse(InputStream inputStream, String string) {
        this.reInit();
        if (inputStream == null) {
            Tr.error((TraceComponent)tc, (String)"PMI0010W", (Object)string);
            return;
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            boolean bl = Boolean.getBoolean("com.ibm.websphere.pmi.validateDescriptors");
            this.parser.setFeature("http://xml.org/sax/features/validation", bl);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            this.parser.setEntityResolver(this);
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            this.parser.parse(inputSource);
            inputStream.close();
            this.parser = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.server.PmiJmxParser._parse", (String)"97", (Object)this);
            return;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"error", (Object)sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endDocument");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startElement", (Object)string2);
        }
        if (string3.equals(MAPPER)) {
            this.isModuleOnlyMapping = false;
            this.perfSubmodule = null;
            this.perfModule = null;
            this.mbeanType = null;
        } else if (string3.equals(MBEAN_TYPE) || string3.equals(PERF_MODULE) || string3.equals(PERF_SUBMODULE) || string3.equals(MODULE_ONLY)) {
            // empty if block
        }
        this.currentChars = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endElement={" + string + ',' + string2 + ',' + string3 + ", " + this.currentChars + '}'));
        }
        if (string3.equals(MAPPER)) {
            this.jmxMapper.setMapping(this.perfModule, this.perfInstance, this.perfSubmodule, this.mbeanType);
            if (this.isModuleOnlyMapping) {
                this.jmxMapper.setModuleOnlyMapping(this.perfModule, this.mbeanType);
            }
        } else if (string3.equals(MBEAN_TYPE)) {
            this.mbeanType = this.currentChars;
        } else if (string3.equals(PERF_MODULE)) {
            this.perfModule = this.currentChars;
        } else if (string3.equals(PERF_SUBMODULE)) {
            this.perfSubmodule = this.currentChars;
        } else if (string3.equals(MODULE_ONLY) && this.currentChars.equals("true")) {
            this.isModuleOnlyMapping = true;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"characters");
        }
        String string = new String(cArray, n, n2);
        this.currentChars = this.currentChars == null ? string : this.currentChars + string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"characters", (Object)this.currentChars);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

