/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.server.CustomPerfLevelDescriptor;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiJmxMapParser;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;

public class PmiRegistry
implements PmiConstants {
    public static final String COPYRIGHT = "Product 5639-D57,  (C) COPYRIGHT International Business Machines Corp., 2000, 2001\nAll Rights Reserved * Licensed Materials - Property of IBM\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean disabled = true;
    private static boolean initialized = false;
    private static boolean allLevelNone = true;
    private static boolean beanMethodDisabled = true;
    public static String nodeName = "mynode";
    public static String serverName = "myserver";
    private static ModuleItem moduleRoot;
    private static Hashtable moduleAggregates;
    private static HashMap mbeanToModuleMap;
    private static PerfLevelDescriptor[] plds;
    private static final TraceComponent tc;
    public static PmiJmxMapper jmxMapper;
    private static ObjectName serverMBean;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$PmiRegistry;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        moduleRoot = new ModuleItem();
        try {
            jmxMapper = new PmiJmxMapper(null, null, true);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"PMI0004W", (Object)exception.getMessage());
            disabled = true;
        }
        PmiJmxMapParser pmiJmxMapParser = new PmiJmxMapParser(jmxMapper);
        pmiJmxMapParser.parse("/com/ibm/websphere/pmi/xml/pmiJmxMapper.xml");
        pmiJmxMapParser.parseExtensions();
        AdminUtil adminUtil = jmxMapper.getAdminUtil();
        disabled = adminUtil == null;
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void disable() {
        disabled = true;
    }

    public static void enable() {
        disabled = false;
    }

    public static boolean isAllLevelNone() {
        return allLevelNone;
    }

    public static boolean isBeanMethodDisabled() {
        return beanMethodDisabled;
    }

    public static void setAllLevelNone(boolean bl) {
        allLevelNone = bl;
    }

    public static synchronized ModuleItem registerModule(PmiModule pmiModule) {
        if (disabled) {
            return null;
        }
        if (!PmiRegistry.validateModule(pmiModule)) {
            Tr.entry((TraceComponent)tc, (String)"registerModule");
            Tr.exit((TraceComponent)tc, (String)"registerModule - module is null");
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerModule: " + pmiModule.getModuleID() + ", " + pmiModule.getName()));
        }
        String[] stringArray = pmiModule.getPath();
        int n = -1;
        ModuleItem moduleItem = null;
        if (stringArray == null || stringArray.length == 0) {
            Tr.warning((TraceComponent)tc, (String)"PMI0001W", (Object)pmiModule.getName());
            return null;
        }
        if (stringArray.length == 1) {
            moduleItem = moduleRoot;
            n = PmiRegistry.moduleRoot.level;
        } else {
            String[] stringArray2 = PmiRegistry.getParentPath(stringArray);
            moduleItem = moduleRoot.add(stringArray2, 0);
            n = moduleItem.getInstance().getInstrumentationLevel();
        }
        int n2 = PmiRegistry.retrieveLevel(pmiModule.getPath());
        if (n2 == -1) {
            n2 = n;
        }
        if (n2 == -1) {
            n2 = pmiModule.getDefaultLevel();
        }
        pmiModule.setInstrumentationLevel(n2);
        ModuleItem moduleItem2 = new ModuleItem(pmiModule);
        if (!moduleItem.add(moduleItem2)) {
            Tr.warning((TraceComponent)tc, (String)"PMI0023W", (Object)pmiModule.getName());
            moduleItem2 = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerModule");
        }
        return moduleItem2;
    }

    public static synchronized void unregisterModule(PmiModule pmiModule) {
        if (disabled) {
            return;
        }
        if (pmiModule == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unregisterModule: " + pmiModule.getModuleID() + ", " + pmiModule.getName()));
        }
        String[] stringArray = pmiModule.getPath();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        ModuleItem moduleItem = moduleRoot.find(stringArray2, 0);
        if (moduleItem != null) {
            String[] stringArray3;
            moduleItem.remove(moduleItem.find(stringArray[stringArray.length - 1]));
            if (!(moduleItem.children != null && moduleItem.children.size() != 0 || moduleItem.getInstance() == null || (stringArray3 = moduleItem.getInstance().getPath()).length == 2 && stringArray3[0].equals("webAppModule"))) {
                moduleItem.getInstance().unregister();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterModule");
        }
    }

    private static boolean validateModule(PmiModule pmiModule) {
        return pmiModule != null;
    }

    private static String[] getParentPath(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 1) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    public static synchronized boolean addModuleInfo(String string, String string2) {
        return PerfModules.addModuleInfo(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModuleAggregate getModuleAggregate(String string) {
        ModuleAggregate moduleAggregate = (ModuleAggregate)moduleAggregates.get(string);
        if (moduleAggregate != null) {
            return moduleAggregate;
        }
        Hashtable hashtable = moduleAggregates;
        synchronized (hashtable) {
            moduleAggregate = (ModuleAggregate)moduleAggregates.get(string);
            if (moduleAggregate != null) {
                return moduleAggregate;
            }
            PmiModuleConfig pmiModuleConfig = PmiRegistry.getConfig(string);
            if (pmiModuleConfig == null) {
                return null;
            }
            moduleAggregate = new ModuleAggregate(string);
            moduleAggregates.put(string, moduleAggregate);
            return moduleAggregate;
        }
    }

    public static PmiModuleConfig getConfig(String string) {
        if (disabled) {
            return null;
        }
        return PerfModules.getConfig(string);
    }

    public static PmiModuleConfig[] getConfigs() {
        if (disabled) {
            return null;
        }
        PmiModuleConfig[] pmiModuleConfigArray = PerfModules.getConfigs();
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            if (pmiModuleConfigArray[i].getMbeanType() != null) continue;
            String string = jmxMapper.getMBeanType(pmiModuleConfigArray[i].getShortName());
            pmiModuleConfigArray[i].setMbeanType(string);
        }
        return pmiModuleConfigArray;
    }

    public static PmiModule findPmiModule(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getInstance();
    }

    public static PmiModule findPmiModule(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getInstance();
    }

    public static ModuleItem findModuleItem(ObjectName objectName) {
        DataDescriptor dataDescriptor;
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        String string = objectName.getKeyProperty("mbeanIdentifier");
        ModuleItem moduleItem = (ModuleItem)mbeanToModuleMap.get(string);
        if (moduleItem != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"PMI0001A", (Object)("findModuleItem() for: " + string));
            }
            return moduleItem;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"PMI0002A", (Object)string);
        }
        if ((dataDescriptor = jmxMapper.getDataDescriptor(objectName, null)) == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object)objectName.toString());
            return null;
        }
        moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object)dataDescriptor.toString());
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(moduleItem, new MBeanStatDescriptor(objectName));
        return moduleItem;
    }

    public static ModuleItem findModuleItem(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        if (mBeanStatDescriptor == null) {
            return null;
        }
        String string = mBeanStatDescriptor.getIdentifier();
        ModuleItem moduleItem = (ModuleItem)mbeanToModuleMap.get(string);
        if (moduleItem != null) {
            return moduleItem;
        }
        DataDescriptor dataDescriptor = PmiRegistry.mBeanToDataDescriptor(mBeanStatDescriptor);
        if (dataDescriptor == null) {
            return null;
        }
        if (dataDescriptor.getPath() == null) {
            return moduleRoot;
        }
        ModuleItem moduleItem2 = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem2 == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object)dataDescriptor.toString());
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(moduleItem2, mBeanStatDescriptor);
        return moduleItem2;
    }

    public static ModuleItem findModuleItem(String[] stringArray) {
        if (disabled) {
            return null;
        }
        if (stringArray == null || stringArray[0].equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(stringArray, 0);
    }

    public static ModuleItem findModuleItem(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        if (dataDescriptor == null || dataDescriptor.getModuleName().equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(dataDescriptor.getPath(), 0);
    }

    private static ModuleItem findParentModuleItem(DataDescriptor dataDescriptor) {
        String[] stringArray = dataDescriptor.getPath();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        return PmiRegistry.findModuleItem(new DataDescriptor(stringArray2));
    }

    public static DataDescriptor[] listMembers() {
        if (disabled) {
            return null;
        }
        ModuleItem[] moduleItemArray = moduleRoot.children();
        if (moduleItemArray == null) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[moduleItemArray.length];
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            dataDescriptorArray[i] = new DataDescriptor(new String[]{moduleItemArray[i].getInstance().getName()});
        }
        return dataDescriptorArray;
    }

    public static DataDescriptor[] listMembers(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        if (dataDescriptor == null || dataDescriptor.getPath() == null) {
            return PmiRegistry.listMembers();
        }
        if (dataDescriptor.getType() == -1) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.listMembers(dataDescriptor, false);
    }

    public static MBeanStatDescriptor[] listStatMembers(ObjectName objectName) {
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        return PmiRegistry.listStatMembers(new MBeanStatDescriptor(objectName));
    }

    public static MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem == null) {
            return null;
        }
        ModuleItem[] moduleItemArray = moduleItem.children();
        if (moduleItemArray == null || moduleItemArray.length == 0) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[moduleItemArray.length];
        for (int i = 0; i < moduleItemArray.length; ++i) {
            mBeanStatDescriptorArray[i] = moduleItemArray[i].getInstance().getMBeanStatDescriptor();
        }
        return mBeanStatDescriptorArray;
    }

    public static WpdCollection get(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        return (WpdCollection)((Object)PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptor), bl));
    }

    public static WpdCollection[] gets(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        WpdCollection[] wpdCollectionArray = new StatsImpl[dataDescriptorArray.length];
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            wpdCollectionArray[i] = (WpdCollection)((Object)PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptorArray[i]), bl));
        }
        return wpdCollectionArray;
    }

    private static Stats getServer(boolean bl) {
        if (!bl) {
            return null;
        }
        ModuleItem[] moduleItemArray = moduleRoot.children();
        if (moduleItemArray == null) {
            return new StatsImpl("server", 12, PmiRegistry.moduleRoot.level, null, null);
        }
        ArrayList<Stats> arrayList = new ArrayList<Stats>(moduleItemArray.length);
        for (int i = 0; i < moduleItemArray.length; ++i) {
            arrayList.add(moduleItemArray[i].getStats(bl));
        }
        StatsImpl statsImpl = new StatsImpl("server", 12, PmiRegistry.moduleRoot.level, null, arrayList);
        return statsImpl;
    }

    private static Stats getStats(ModuleItem moduleItem, boolean bl) {
        if (moduleItem == null) {
            return null;
        }
        if (moduleItem.getInstance() == null) {
            return PmiRegistry.getServer(bl);
        }
        return moduleItem.getStats(bl);
    }

    public static Stats getStats(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptor), bl);
    }

    public static Stats[] getStats(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        Stats[] statsArray = new StatsImpl[dataDescriptorArray.length];
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            statsArray[i] = PmiRegistry.getStats(dataDescriptorArray[i], bl);
        }
        return statsArray;
    }

    public static Stats getStats(MBeanStatDescriptor mBeanStatDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        if (mBeanStatDescriptor == null) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(mBeanStatDescriptor), bl);
    }

    public static Stats[] getStats(MBeanStatDescriptor[] mBeanStatDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        Stats[] statsArray = new StatsImpl[mBeanStatDescriptorArray.length];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            statsArray[i] = PmiRegistry.getStats(mBeanStatDescriptorArray[i], bl);
        }
        return statsArray;
    }

    public static Stats[] getStats(ObjectName[] objectNameArray, boolean bl) {
        if (disabled) {
            return null;
        }
        Stats[] statsArray = new StatsImpl[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            statsArray[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(objectNameArray[i]), bl);
        }
        return statsArray;
    }

    public static MBeanLevelSpec[] getMBeanLevelSpecs(ObjectName objectName, StatDescriptor statDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(new MBeanStatDescriptor(objectName, statDescriptor));
        if (moduleItem == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object)objectName.toString());
            return null;
        }
        if (!bl) {
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, statDescriptor, moduleItem.getInstance().getInstrumentationLevel());
            return new MBeanLevelSpec[]{mBeanLevelSpec};
        }
        ArrayList arrayList = moduleItem.getPerfLevelDescriptors(true);
        MBeanLevelSpec[] mBeanLevelSpecArray = new MBeanLevelSpec[arrayList.size()];
        for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
            mBeanLevelSpecArray[i] = (MBeanLevelSpec)arrayList.get(i);
        }
        return mBeanLevelSpecArray;
    }

    public static PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        if (!bl) {
            PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[1];
            String[] stringArray = moduleItem.getInstance().getPath();
            perfLevelDescriptorArray[0] = moduleItem.getInstance().getModuleID().equals(stringArray[0]) ? new PerfLevelDescriptor(moduleItem.getInstance().getPath(), moduleItem.getInstance().getInstrumentationLevel()) : new CustomPerfLevelDescriptor(moduleItem.getInstance().getPath(), moduleItem.getInstance().getInstrumentationLevel(), moduleItem.getInstance().getModuleID());
            return perfLevelDescriptorArray;
        }
        ArrayList arrayList = moduleItem.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = (PerfLevelDescriptor)arrayList.get(i);
        }
        return perfLevelDescriptorArray;
    }

    public static int getInstrumentationLevel(String[] stringArray) {
        if (disabled) {
            return -1;
        }
        DataDescriptor dataDescriptor = new DataDescriptor(stringArray);
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return -1;
        }
        return moduleItem.getInstance().getInstrumentationLevel();
    }

    public static PerfLevelDescriptor[] getAllInstrumentationLevels() {
        if (disabled) {
            return null;
        }
        ArrayList arrayList = moduleRoot.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = (PerfLevelDescriptor)arrayList.get(i);
        }
        return perfLevelDescriptorArray;
    }

    public static String getInstrumentationLevelString() {
        if (disabled) {
            return null;
        }
        Map map = PmiRegistry.moduleRoot.children;
        if (map == null) {
            return "";
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[map.size()];
        Iterator iterator = map.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PmiModule pmiModule = ((ModuleItem)iterator.next()).getInstance();
            perfLevelDescriptorArray[n++] = new PerfLevelDescriptor(pmiModule.getPath(), pmiModule.getInstrumentationLevel());
        }
        return PmiUtil.getStringFromPerfLevelSpecs(perfLevelDescriptorArray);
    }

    private static PerfLevelDescriptor[] getTreeInstrumentationLevels() {
        ArrayList arrayList = moduleRoot.getTreePerfLevelDescriptors(-1);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = (PerfLevelDescriptor)arrayList.get(i);
        }
        return perfLevelDescriptorArray;
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor perfLevelDescriptor, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.setLevel(perfLevelDescriptor, bl);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            PmiRegistry.setLevel(perfLevelDescriptorArray[i], bl);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static void setLevel(PerfLevelDescriptor perfLevelDescriptor, boolean bl) {
        if (perfLevelDescriptor == null) {
            return;
        }
        String[] stringArray = perfLevelDescriptor.getPath();
        ModuleItem moduleItem = null;
        if (stringArray == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0001W", (Object)"PmiRegistry.setLevel");
            return;
        }
        if (stringArray.length == 1 && stringArray[0].equals("pmi")) {
            moduleItem = moduleRoot;
        } else if (stringArray[0].equals("pmi")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            moduleItem = PmiRegistry.findModuleItem(new DataDescriptor(stringArray2));
        }
        if (moduleItem != null) {
            moduleItem.setInstanceLevel(perfLevelDescriptor.getLevel(), bl);
        }
    }

    public static void setMBeanLevel(MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (disabled) {
            return;
        }
        if (mBeanLevelSpec == null) {
            return;
        }
        PmiRegistry.setLevel(mBeanLevelSpec, bl);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setMBeanLevel(MBeanLevelSpec[] mBeanLevelSpecArray, boolean bl) {
        if (disabled) {
            return;
        }
        if (mBeanLevelSpecArray == null || mBeanLevelSpecArray.length == 0) {
            return;
        }
        for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
            if (mBeanLevelSpecArray[i] == null) continue;
            PmiRegistry.setLevel(mBeanLevelSpecArray[i], bl);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static void setLevel(MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (mBeanLevelSpec == null) {
            return;
        }
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(mBeanLevelSpec.getObjectName(), mBeanLevelSpec.getStatDescriptor());
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem != null) {
            moduleItem.setInstanceLevel(mBeanLevelSpec.getLevel(), bl);
        } else {
            Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object)mBeanLevelSpec.toString());
        }
    }

    private static boolean checkAllLevelNone(ModuleItem moduleItem) {
        if (moduleItem.instance != null && moduleItem.instance.getInstrumentationLevel() != 0) {
            return false;
        }
        if (moduleItem.children == null) {
            return true;
        }
        ModuleItem moduleItem2 = null;
        Iterator iterator = moduleItem.children.values().iterator();
        while (iterator.hasNext()) {
            moduleItem2 = (ModuleItem)iterator.next();
            if (PmiRegistry.checkAllLevelNone(moduleItem2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBeanMethodDisabled(ModuleItem moduleItem) {
        if (moduleItem.instance != null && !moduleItem.instance.getModuleID().equals("beanModule")) {
            return true;
        }
        if (moduleItem.instance != null && moduleItem.instance.getInstrumentationLevel() >= 7) {
            return false;
        }
        if (moduleItem.children == null) {
            return true;
        }
        ModuleItem moduleItem2 = null;
        Iterator iterator = moduleItem.children.values().iterator();
        while (iterator.hasNext()) {
            moduleItem2 = (ModuleItem)iterator.next();
            if (!moduleItem2.getInstance().getModuleID().equals("beanModule") || PmiRegistry.checkBeanMethodDisabled(moduleItem2)) continue;
            return false;
        }
        return true;
    }

    private static int retrieveLevel(String[] stringArray) {
        if (plds == null) {
            return -1;
        }
        boolean bl = false;
        String[] stringArray2 = null;
        if (stringArray == null || stringArray.length == 0) {
            stringArray2 = new String[]{"pmi"};
            bl = true;
        } else {
            stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = "pmi";
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        }
        for (int i = 0; i < plds.length; ++i) {
            if (plds[i].comparePath(stringArray2) != 0) continue;
            return plds[i].getLevel();
        }
        return -1;
    }

    public static void restorePmiLevel(String string) {
        String[] stringArray;
        int n;
        if (disabled) {
            return;
        }
        plds = PmiUtil.getPerfLevelSpecsFromString(string);
        if (plds == null) {
            return;
        }
        moduleRoot.setInstanceLevel(0, false);
        for (n = 0; n < plds.length; ++n) {
            stringArray = plds[n].getPath();
            if (stringArray == null || stringArray.length != 1 || !stringArray[0].equals("pmi")) continue;
            moduleRoot.setInstanceLevel(plds[n].getLevel(), false);
            break;
        }
        PmiRegistry.moduleRoot.level = PmiRegistry.retrieveLevel(null);
        for (n = 0; n < plds.length; ++n) {
            if (plds[n].getLevel() <= 0) continue;
            allLevelNone = false;
            break;
        }
        for (n = 0; n < plds.length; ++n) {
            stringArray = plds[n].getPath();
            if (stringArray == null || stringArray.length < 2 || !stringArray[1].startsWith("bean") || plds[n].getLevel() < 7) continue;
            beanMethodDisabled = false;
            break;
        }
    }

    public static void enableData(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dataDescriptorArray, true, bl);
    }

    public static void disableData(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dataDescriptorArray, false, bl);
    }

    private static void turnOnOffData(DataDescriptor[] dataDescriptorArray, boolean bl, boolean bl2) {
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptorArray[i]);
            if (moduleItem == null) continue;
            int[] nArray = dataDescriptorArray[i].getDataIds();
            if (nArray == null) {
                moduleItem.turnOnOffData(-1, bl, bl2);
                continue;
            }
            for (int j = 0; j < nArray.length; ++j) {
                moduleItem.turnOnOffData(nArray[j], bl, bl2);
            }
        }
    }

    public static PerfLevelDescriptor[] getDefaultPerfLevelSpecs() {
        String[] stringArray = PerfModules.moduleIDs;
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[stringArray.length + 1];
        perfLevelDescriptorArray[0] = new PerfLevelDescriptor(null, 0);
        for (int i = 0; i < stringArray.length; ++i) {
            perfLevelDescriptorArray[i + 1] = new PerfLevelDescriptor(new String[]{stringArray[i]}, 0);
        }
        return perfLevelDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMBeanToModuleMap(ModuleItem moduleItem, MBeanStatDescriptor mBeanStatDescriptor) {
        if (moduleItem == null || mBeanStatDescriptor == null) {
            return false;
        }
        HashMap hashMap = mbeanToModuleMap;
        synchronized (hashMap) {
            ModuleItem moduleItem2 = mbeanToModuleMap.put(mBeanStatDescriptor.getIdentifier(), moduleItem);
            if (moduleItem.getInstance() != null) {
                moduleItem.getInstance().setMBeanName(mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor());
            }
            if (moduleItem2 != null) {
                Tr.warning((TraceComponent)tc, (String)"PMI0024W", (Object)moduleItem2.getInstance().getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"", (Object)("setMBeanToModuleMap(): " + mBeanStatDescriptor.getIdentifier()));
            }
        }
        return true;
    }

    public static void removeMBeanToModuleMap(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"", (Object)("removeMBeanToModuleMap(): " + mBeanStatDescriptor.getIdentifier()));
            }
            mbeanToModuleMap.remove(mBeanStatDescriptor.getIdentifier());
        }
    }

    public static DataDescriptor mBeanToDataDescriptor(MBeanStatDescriptor mBeanStatDescriptor) {
        int n;
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor.getObjectName());
        if (moduleItem == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mBeanToDataDescriptor(): ModuleItem not found for key:" + mBeanStatDescriptor.getObjectName().toString()));
            }
            return null;
        }
        if (moduleItem.getInstance() == null) {
            StatDescriptor statDescriptor = mBeanStatDescriptor.getStatDescriptor();
            if (statDescriptor == null) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            String[] stringArray = mBeanStatDescriptor.getStatDescriptor().getPath();
            if (stringArray == null || stringArray.length == 0) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            return new DataDescriptor(stringArray);
        }
        int n2 = 0;
        String[] stringArray = moduleItem.getInstance().getPath();
        String[] stringArray2 = null;
        StatDescriptor statDescriptor = mBeanStatDescriptor.getStatDescriptor();
        if (statDescriptor != null) {
            stringArray2 = mBeanStatDescriptor.getStatDescriptor().getPath();
            n2 = stringArray2.length;
        }
        String[] stringArray3 = new String[stringArray.length + n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = stringArray.length; n < stringArray3.length; ++n) {
            stringArray3[n] = stringArray2[n - stringArray.length];
        }
        return new DataDescriptor(stringArray3);
    }

    public static boolean isDuplicateModule(String string) {
        return moduleRoot.find(string) != null;
    }

    public static void printpath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("PmiRegistry.printpath: ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append("/");
        }
        System.out.println(stringBuffer.toString());
    }

    public static ObjectName getServerMBean() {
        if (serverMBean == null) {
            serverMBean = jmxMapper.findObjectName(null, "Server", null, null);
        }
        return serverMBean;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        moduleAggregates = new Hashtable();
        mbeanToModuleMap = new HashMap();
        plds = null;
        tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$PmiRegistry == null ? (class$com$ibm$ws$pmi$server$PmiRegistry = PmiRegistry.class$("com.ibm.ws.pmi.server.PmiRegistry")) : class$com$ibm$ws$pmi$server$PmiRegistry), null, (String)"com.ibm.websphere.pmi.property.pmi");
        jmxMapper = null;
    }
}

