/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PmiUtil
implements PmiConstants {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$PmiUtil == null ? (class$com$ibm$ws$pmi$server$PmiUtil = PmiUtil.class$("com.ibm.ws.pmi.server.PmiUtil")) : class$com$ibm$ws$pmi$server$PmiUtil), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String mySeperator = ">";
    public static final char mySeperatorChar = '>';
    public static final int pmiStringMaxLength = 0;
    public static String SHORT_LEVEL_NONE_STRING = "N";
    public static String SHORT_LEVEL_LOW_STRING = "L";
    public static String SHORT_LEVEL_MEDIUM_STRING = "M";
    public static String SHORT_LEVEL_HIGH_STRING = "H";
    public static String SHORT_LEVEL_MAX_STRING = "X";
    static String[] compressModuleNames = new String[PerfModules.moduleIDs.length];
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$PmiUtil;

    public static long currentTime() {
        return System.currentTimeMillis() * 1L;
    }

    public static String getStringFromPerfLevelSpecs(PerfLevelDescriptor[] perfLevelDescriptorArray) {
        return PmiUtil.getStringFromPerfLevelSpecs(perfLevelDescriptorArray, true);
    }

    public static String getStringFromPerfLevelSpecs(PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        StringBuffer stringBuffer = null;
        if (perfLevelDescriptorArray == null) {
            return null;
        }
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            String string = PmiUtil.createPmiSpecString(perfLevelDescriptorArray[i]);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                continue;
            }
            if (string == null) continue;
            stringBuffer.append(":").append(string);
        }
        if (bl) {
            return PmiUtil.getCompressedPerfString(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static PerfLevelDescriptor[] getPerfLevelSpecsFromString(String string) {
        return PmiUtil.getPerfLevelSpecsFromString(string, true);
    }

    public static PerfLevelDescriptor[] getPerfLevelSpecsFromString(String string, boolean bl) {
        Object object;
        if (string == null || string.equals("") || string.equals("pmi=disable")) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            object = PmiUtil.getSpecFromString(stringTokenizer.nextToken());
            if (object == null) continue;
            arrayList.add(object);
        }
        if (bl) {
            object = null;
            PerfLevelDescriptor perfLevelDescriptor = null;
            int n = arrayList.size();
            PerfLevelDescriptor perfLevelDescriptor2 = null;
            for (int i = 0; i < n; ++i) {
                int n2;
                perfLevelDescriptor2 = null;
                object = (PerfLevelDescriptor)arrayList.get(i);
                if (object == null || ((PerfLevelDescriptor)object).getPath().length <= 2) continue;
                for (n2 = n - 1; n2 >= 0; --n2) {
                    if (i == n2 || !(perfLevelDescriptor = (PerfLevelDescriptor)arrayList.get(n2)).isSubPath((PerfLevelSpec)object)) continue;
                    if (perfLevelDescriptor.getPath().length == ((PerfLevelDescriptor)object).getPath().length - 1) {
                        perfLevelDescriptor2 = null;
                        break;
                    }
                    if (perfLevelDescriptor2 != null && perfLevelDescriptor.getPath().length <= perfLevelDescriptor2.getPath().length) continue;
                    perfLevelDescriptor2 = perfLevelDescriptor;
                }
                if (perfLevelDescriptor2 == null) continue;
                for (n2 = perfLevelDescriptor2.getPath().length + 1; n2 < ((PerfLevelDescriptor)object).getPath().length; ++n2) {
                    String[] stringArray = new String[n2];
                    for (int j = 0; j < n2; ++j) {
                        stringArray[j] = ((PerfLevelDescriptor)object).getPath()[j];
                    }
                    arrayList.add(new PerfLevelDescriptor(stringArray, perfLevelDescriptor2.getLevel()));
                }
            }
        }
        object = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < ((PerfLevelDescriptor[])object).length; ++i) {
            object[i] = (PerfLevelDescriptor)arrayList.get(i);
            String[] stringArray = object[i].getPath();
        }
        return object;
    }

    public static String updatePerfLevelSpecString(PmiJmxMapper pmiJmxMapper, String string, MBeanLevelSpec[] mBeanLevelSpecArray, boolean bl) {
        if (mBeanLevelSpecArray == null || mBeanLevelSpecArray.length == 0) {
            return string;
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[mBeanLevelSpecArray.length];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = pmiJmxMapper.getPerfLevelDescriptor(mBeanLevelSpecArray[i]);
        }
        return PmiUtil.updatePerfLevelSpecString(string, perfLevelDescriptorArray, bl);
    }

    public static String updatePerfLevelSpecString(String string, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        int n;
        Object[] objectArray;
        PerfLevelDescriptor[] perfLevelDescriptorArray2 = PmiUtil.getPerfLevelSpecsFromString(string, false);
        if (perfLevelDescriptorArray2 == null) {
            perfLevelDescriptorArray2 = PmiRegistry.getDefaultPerfLevelSpecs();
        }
        if (perfLevelDescriptorArray == null) {
            return string;
        }
        ArrayList<PerfLevelDescriptor> arrayList = new ArrayList<PerfLevelDescriptor>(perfLevelDescriptorArray.length);
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            if (perfLevelDescriptorArray[i] == null) continue;
            objectArray = perfLevelDescriptorArray[i].getPath();
            if (!bl && objectArray.length == 1 && ((String)objectArray[0]).equalsIgnoreCase("pmi")) continue;
            n = 0;
            for (int j = 0; j < perfLevelDescriptorArray2.length; ++j) {
                if (bl && perfLevelDescriptorArray[i].isSubPath(perfLevelDescriptorArray2[j])) {
                    perfLevelDescriptorArray2[j].setLevel(perfLevelDescriptorArray[i].getLevel());
                }
                if (perfLevelDescriptorArray[i].comparePath(perfLevelDescriptorArray2[j]) != 0) continue;
                n = 1;
                perfLevelDescriptorArray2[j].setLevel(perfLevelDescriptorArray[i].getLevel());
                if (!bl) break;
            }
            if (n != 0) continue;
            arrayList.add(perfLevelDescriptorArray[i]);
        }
        String string2 = PmiUtil.getStringFromPerfLevelSpecs(perfLevelDescriptorArray2, false);
        if (arrayList.size() > 0) {
            objectArray = new PerfLevelDescriptor[arrayList.size()];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = (PerfLevelDescriptor)arrayList.get(n);
            }
            String string3 = PmiUtil.getStringFromPerfLevelSpecs((PerfLevelDescriptor[])objectArray, false);
            if (string3 != null) {
                string2 = string2 + ":" + string3;
            }
        }
        return PmiUtil.getCompressedPerfString(string2);
    }

    public static String getCompressedPerfString(String string) {
        int n;
        int n2 = string.lastIndexOf(61);
        if (n2 < 0) {
            return string;
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString(string, false);
        ArrayList<PerfLevelDescriptor> arrayList = new ArrayList<PerfLevelDescriptor>(perfLevelDescriptorArray.length);
        for (n = 0; n < perfLevelDescriptorArray.length; ++n) {
            int n3 = -1;
            for (int i = perfLevelDescriptorArray.length - 1; i >= 0 && perfLevelDescriptorArray[n].getPath().length > 2; --i) {
                if (n == i || !perfLevelDescriptorArray[i].isSubPath(perfLevelDescriptorArray[n])) continue;
                if (perfLevelDescriptorArray[i].getPath().length == perfLevelDescriptorArray[n].getPath().length - 1) {
                    if (perfLevelDescriptorArray[i].level == perfLevelDescriptorArray[n].level) {
                        n3 = i;
                        break;
                    }
                    n3 = -1;
                    break;
                }
                if (n3 != -1 && !perfLevelDescriptorArray[n3].isSubPath(perfLevelDescriptorArray[i])) continue;
                n3 = i;
            }
            if (n3 != -1 && perfLevelDescriptorArray[n3].level == perfLevelDescriptorArray[n].level) continue;
            arrayList.add(perfLevelDescriptorArray[n]);
        }
        perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (n = 0; n < perfLevelDescriptorArray.length; ++n) {
            perfLevelDescriptorArray[n] = (PerfLevelDescriptor)arrayList.get(n);
        }
        String string2 = PmiUtil.getStringFromPerfLevelSpecs(perfLevelDescriptorArray, false);
        return string2;
    }

    private static String createPmiSpecString(PerfLevelDescriptor perfLevelDescriptor) {
        if (perfLevelDescriptor == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = perfLevelDescriptor.getPath();
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("pmi")) {
            stringBuffer.append("pmi");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0 && stringArray[i].equalsIgnoreCase("pmi")) continue;
                boolean bl = false;
                if (i == 0 || i == 1) {
                    for (int j = 0; j < PerfModules.moduleIDs.length; ++j) {
                        if (!stringArray[i].equals(PerfModules.moduleIDs[j])) continue;
                        bl = true;
                        stringBuffer.append(PerfModules.moduleIDs[j]);
                        break;
                    }
                }
                if (!bl) {
                    stringBuffer.append(stringArray[i]);
                }
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(mySeperator);
            }
        }
        if (perfLevelDescriptor.getLevel() == -1) {
            return null;
        }
        String string = "none";
        switch (perfLevelDescriptor.getLevel()) {
            case 0: {
                string = SHORT_LEVEL_NONE_STRING;
                break;
            }
            case 1: {
                string = SHORT_LEVEL_LOW_STRING;
                break;
            }
            case 3: {
                string = SHORT_LEVEL_MEDIUM_STRING;
                break;
            }
            case 7: {
                string = SHORT_LEVEL_HIGH_STRING;
                break;
            }
            case 15: {
                string = SHORT_LEVEL_MAX_STRING;
                break;
            }
            default: {
                Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object)("level=" + perfLevelDescriptor.getLevel()));
            }
        }
        stringBuffer.append("=").append(string);
        return stringBuffer.toString();
    }

    private static PerfLevelDescriptor getSpecFromString(String string) {
        int n;
        String[] stringArray = StrUtils.split((String)string, (int)61);
        if (string != null && !string.equals("") && stringArray.length != 2) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object)string);
            return null;
        }
        String[] stringArray2 = StrUtils.split((String)stringArray[0], (int)62);
        if (stringArray2 == null || stringArray2.length == 0) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object)string);
            return null;
        }
        String string2 = null;
        int n2 = -1;
        if (!stringArray2[0].equalsIgnoreCase("pmi")) {
            string2 = stringArray2[0];
            n2 = 0;
        } else if (stringArray2.length > 1) {
            string2 = stringArray2[1];
            n2 = 1;
        } else if (stringArray2.length == 1 && stringArray2[0].equalsIgnoreCase("pmi")) {
            string2 = "pmi";
            stringArray2 = null;
        }
        if (string2 != null) {
            boolean bl = false;
            if (string2.equals("pmi")) {
                bl = true;
            }
            if (!bl) {
                for (n = 0; n < PerfModules.moduleIDs.length; ++n) {
                    if (!string2.equals(PerfModules.moduleIDs[n]) && !string2.equals(compressModuleNames[n])) continue;
                    bl = true;
                    stringArray2[n2] = PerfModules.moduleIDs[n];
                    break;
                }
            }
        }
        String string3 = stringArray[1];
        n = -1;
        if (string3.equalsIgnoreCase(SHORT_LEVEL_NONE_STRING) || string3.equalsIgnoreCase("none")) {
            n = 0;
        } else if (string3.equalsIgnoreCase(SHORT_LEVEL_LOW_STRING) || string3.equalsIgnoreCase("low")) {
            n = 1;
        } else if (string3.equalsIgnoreCase(SHORT_LEVEL_MEDIUM_STRING) || string3.equalsIgnoreCase("medium")) {
            n = 3;
        } else if (string3.equalsIgnoreCase(SHORT_LEVEL_HIGH_STRING) || string3.equalsIgnoreCase("high")) {
            n = 7;
        } else if (string3.equalsIgnoreCase(SHORT_LEVEL_MAX_STRING) || string3.equalsIgnoreCase("maximum")) {
            n = 15;
        }
        if (n == -1) {
            Tr.warning((TraceComponent)tc, (String)"PMI0011W", (Object)string);
        }
        return new PerfLevelDescriptor(stringArray2, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < PerfModules.moduleIDs.length; ++i) {
            PmiUtil.compressModuleNames[i] = PerfModules.moduleIDs[i].substring(0, 4);
        }
    }
}

