/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.stat.Statistic;

public abstract class SpdDataImpl
implements SpdData,
PmiConstants {
    protected final int dataId;
    protected boolean enabled = true;
    protected boolean sync = false;

    public SpdDataImpl(PmiModuleConfig pmiModuleConfig, String string) {
        this.dataId = pmiModuleConfig != null ? pmiModuleConfig.getDataId(string) : -1;
    }

    public SpdDataImpl(int n) {
        this.dataId = n;
    }

    public int getId() {
        return this.dataId;
    }

    public void enable(int n) {
        this.sync = n >= 7;
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int compareTo(SpdData spdData) {
        if (this.dataId < spdData.getId()) {
            return -1;
        }
        if (this.dataId > spdData.getId()) {
            return 1;
        }
        return 0;
    }

    public void reset() {
        this.reset(true);
    }

    public void setDataInfo(PmiModuleConfig pmiModuleConfig) {
        Statistic statistic = this.getStatistic();
        if (statistic != null) {
            statistic.setDataInfo(pmiModuleConfig);
        }
    }

    public abstract void reset(boolean var1);

    public abstract Statistic getStatistic();
}

