/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.DoubleStatisticImpl;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.data.SpdGroupBase;

public class SpdStatisticAggregate
extends SpdGroupBase
implements PmiConstants {
    protected Statistic aggregateValue = null;
    protected int _type = -1;

    public SpdStatisticAggregate(PmiDataInfo pmiDataInfo) {
        super(pmiDataInfo.getId());
        this._type = pmiDataInfo.getType();
        switch (this._type) {
            case 2: {
                this.aggregateValue = new CountStatisticImpl(this.dataId);
                break;
            }
            case 3: {
                this.aggregateValue = new DoubleStatisticImpl(this.dataId);
                break;
            }
            case 4: {
                this.aggregateValue = new TimeStatisticImpl(this.dataId);
                break;
            }
            case 5: {
                this.aggregateValue = new BoundedRangeStatisticImpl(this.dataId);
                break;
            }
            default: {
                this._type = -1;
                System.err.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
    }

    public boolean add(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        return super.add(spdData);
    }

    public boolean remove(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        return super.remove(spdData);
    }

    public Statistic getStatistic() {
        Statistic statistic = this._getAggregate();
        statistic.setLastSampleTime(System.currentTimeMillis());
        return statistic;
    }

    private Statistic _getAggregate() {
        switch (this._type) {
            case 2: {
                ((CountStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 3: {
                ((DoubleStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 4: {
                ((TimeStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 5: {
                ((BoundedRangeStatisticImpl)this.aggregateValue).cleanup();
                break;
            }
            default: {
                this._type = -1;
                System.out.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
        for (int i = 0; i < this.members.size(); ++i) {
            Object e = this.members.get(i);
            if (e == null) continue;
            if (e instanceof SpdStatisticAggregate) {
                this.aggregateValue.combine(((SpdStatisticAggregate)e)._getAggregate());
                continue;
            }
            this.aggregateValue.combine(((SpdData)e).getStatistic());
        }
        return this.aggregateValue;
    }

    public void reset(boolean bl) {
    }
}

