/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.factory.StatisticActionListener;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.DoubleStatisticImpl;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.data.SpdDataImpl;

public class SpdStatisticExternal
extends SpdDataImpl {
    protected StatisticActionListener proxy;
    protected Statistic onReqStatistic;

    public SpdStatisticExternal(PmiDataInfo pmiDataInfo, StatisticActionListener statisticActionListener) {
        super(pmiDataInfo.getId());
        this.proxy = statisticActionListener;
        int n = pmiDataInfo.getType();
        switch (n) {
            case 2: {
                this.onReqStatistic = new CountStatisticImpl(this.dataId);
                break;
            }
            case 3: {
                this.onReqStatistic = new DoubleStatisticImpl(this.dataId);
                break;
            }
            case 4: {
                this.onReqStatistic = new TimeStatisticImpl(this.dataId);
                break;
            }
            case 5: {
                this.onReqStatistic = new BoundedRangeStatisticImpl(this.dataId);
                break;
            }
            default: {
                System.err.println("[SpdStatisticExternal] Invalid statistic type");
            }
        }
    }

    public Statistic getStatistic() {
        if (this.enabled) {
            if (this.proxy == null) {
                System.out.println("SpdStatisticExternal: null proxy");
            }
            this.proxy.updateStatisticOnRequest(this.dataId);
            return this.onReqStatistic;
        }
        return null;
    }

    public void reset(boolean bl) {
    }

    public Statistic getStatisticRef() {
        return this.onReqStatistic;
    }
}

