/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.jvmpi.JvmpiInfo;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;
import java.util.ArrayList;

public class JvmpiGroup {
    private ArrayList subGroups = new ArrayList();
    private static final int PMI_JVMPI_GC = 0;
    private static final int PMI_JVMPI_MONITOR = 1;
    private static final int PMI_JVMPI_THREAD = 2;
    private static final int PMI_JVMPI_OBJECT = 3;
    private static final String GC_NAME = "GC";
    private static final String MONITOR_NAME = "Monitor";
    private static final String THREAD_NAME = "Thread";
    private static final String OBJECT_NAME = "Object";

    public JvmpiGroup() {
        String[] stringArray = null;
        try {
            JvmpiJni.pmiinit();
            stringArray = JvmpiJni.getGroups();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            FFDCFilter.processException((Throwable)unsatisfiedLinkError, (String)"com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", (String)"160", (Object)this);
            stringArray = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", (String)"163", (Object)this);
            stringArray = null;
        }
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = -1;
            if (stringArray[i].equals(GC_NAME)) {
                n = 0;
            } else if (stringArray[i].equals(MONITOR_NAME)) {
                n = 1;
            } else if (stringArray[i].equals(THREAD_NAME)) {
                n = 2;
            } else if (stringArray[i].equals(OBJECT_NAME)) {
                n = 3;
            } else {
                System.err.println("WARNING: JvmpiGroup receives wrong group name");
            }
            if (n == -1) continue;
            this.subGroups.add(new JvmpiDataGroup(stringArray[i], n));
        }
    }

    public void setInstrumentationLevel(int n) {
        if (this.subGroups == null || this.subGroups.size() == 0) {
            return;
        }
        PmiModule pmiModule = null;
        for (int i = 0; i < this.subGroups.size(); ++i) {
            pmiModule = (PmiModule)this.subGroups.get(i);
            pmiModule.setInstrumentationLevel(n);
        }
    }

    static {
        try {
            if (System.getProperty("os.name").equals("OS/400")) {
                System.load("/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QEJBJVMPI.SRVPGM");
            } else {
                System.loadLibrary("pmiJvmpiProfiler");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            FFDCFilter.processException((Throwable)unsatisfiedLinkError, (String)"com.ibm.ws.pmi.server.jvmpi.JvmpiGroup", (String)"150");
        }
    }

    class JvmpiDataGroup
    extends PmiAbstractModule {
        final String moduleID = "jvmRuntimeModule";
        final int defaultLevel = 0;
        JvmpiInfo[] members = null;
        int groupId = -1;

        public JvmpiDataGroup(String string, int n) {
            super("jvmRuntimeModule", string);
            this.groupId = n;
            this.members = JvmpiJni.getMembers(n);
            this.registerModule(this);
        }

        public synchronized void setInstrumentationLevel(int n) {
            JvmpiJni.setLevel(this.groupId, n);
            for (int i = 0; i < this.members.length; ++i) {
                this.members[i].setLevel(n);
                if (this.members[i].pmiData == null) continue;
                this.putToTable(this.members[i].pmiData);
            }
            this.currentLevel = n;
        }

        public String getModuleID() {
            return "jvmRuntimeModule";
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

