/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdDoubleExternalValue;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;

public class JvmpiInfo
implements PmiConstants {
    private int dataId;
    private int dataType;
    private int code;
    private int level;
    protected SpdData pmiData = null;
    static final int DATAID_OFFSET = 10;
    static final int INT = 0;
    static final int LONG = 1;
    static final int DOUBLE = 2;
    static final int STAT = 3;

    public JvmpiInfo(int n, int n2, int n3, int n4) {
        this.dataId = n + 10;
        this.dataType = n2;
        this.code = n3;
        this.level = 15;
    }

    public void setLevel(int n) {
        if (n >= this.level) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        if (this.pmiData == null) {
            return;
        }
        this.pmiData.disable();
    }

    public void enable() {
        if (this.pmiData != null) {
            this.pmiData.enable(this.level);
            return;
        }
        switch (this.dataType) {
            case 1: {
                this.pmiData = new SpdLongExternal(this.dataId, new JvmpiLongData(this.code));
                break;
            }
            case 3: {
                this.pmiData = new SpdStatExternal(this.dataId, new JvmpiTimeStatistic(this.code));
                break;
            }
        }
    }

    class JvmpiTimeStatistic
    implements SpdStatExternalValue {
        private int code;
        private long startTime = 0L;

        public JvmpiTimeStatistic(int n) {
            this.code = n;
            this.startTime = PmiUtil.currentTime();
        }

        public TimeStatisticImpl getStatValue() {
            TimeStatisticImpl timeStatisticImpl = JvmpiJni.getStatData(this.code);
            timeStatisticImpl.setDataId(JvmpiInfo.this.dataId);
            timeStatisticImpl.setStartTime(this.startTime);
            timeStatisticImpl.setLastSampleTime(PmiUtil.currentTime());
            return timeStatisticImpl;
        }
    }

    class JvmpiDoubleData
    implements SpdDoubleExternalValue {
        private int code;

        public JvmpiDoubleData(int n) {
            this.code = n;
        }

        public double getDoubleValue() {
            return JvmpiJni.getDouble(this.code);
        }
    }

    class JvmpiLongData
    implements SpdLongExternalValue {
        private int code;

        public JvmpiLongData(int n) {
            this.code = n;
        }

        public long getLongValue() {
            return JvmpiJni.getLong(this.code);
        }
    }
}

