/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.TemplateModule;
import java.util.HashMap;

public class CachePerfModule
extends PmiAbstractModule
implements CachePerf {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$CachePerfModule == null ? (class$com$ibm$ws$pmi$server$modules$CachePerfModule = CachePerfModule.class$("com.ibm.ws.pmi.server.modules.CachePerfModule")) : class$com$ibm$ws$pmi$server$modules$CachePerfModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "cacheModule";
    private static final int defaultLevel = 0;
    public static final int cacheModule_maxInMemoryCacheSize = 1;
    public static final int cacheModule_inMemoryCacheSize = 2;
    public static final int cacheModule_totalTimeoutInvalidations = 3;
    public static final int UNSET = 0;
    public static final int DIRECT = 1;
    public static final int LRU = 2;
    public static final int TIMEOUT = 3;
    public static final int MEMORY = 1;
    public static final int REMOTE = 2;
    public static final int DISK = 3;
    public static final int NOOP = 4;
    public static final int LOCAL = 5;
    public static final int cacheModule_template = 20;
    public static final int cacheModule_template_hitsInMemory = 21;
    public static final int cacheModule_template_hitsOnDisk = 22;
    public static final int cacheModule_template_explicitInvalidations = 23;
    public static final int cacheModule_template_lruInvalidations = 24;
    public static final int cacheModule_template_timeoutInvalidations = 25;
    public static final int cacheModule_template_entries = 26;
    public static final int cacheModule_template_hitsRemote = 27;
    public static final int cacheModule_template_misses = 28;
    public static final int cacheModule_template_requestsFromClient = 29;
    public static final int cacheModule_template_requestsFromJVM = 30;
    public static final int cacheModule_template_explicitInvalidationsFromMemory = 31;
    public static final int cacheModule_template_explicitInvalidationsFromDisk = 32;
    public static final int cacheModule_template_explicitInvalidationsNoOp = 33;
    public static final int cacheModule_template_explicitInvalidationsLocal = 34;
    public static final int cacheModule_template_explicitInvalidationsRemote = 35;
    public static final int cacheModule_template_remoteCreations = 36;
    CountStatisticImpl maxInMemoryCacheSize = null;
    CountStatisticImpl inMemoryCacheSize = null;
    CountStatisticImpl totalTimeoutInvalidations = null;
    HashMap templates = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$CachePerfModule;

    public CachePerfModule() {
        this("Dynamic Cache", (PmiCallback)null);
    }

    public CachePerfModule(String string, PmiCallback pmiCallback) {
        super(moduleID, string, pmiCallback);
        if (!PmiRegistry.isDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new CachePerfModule, cacheName=" + string));
            }
            this.type = 13;
            this.registerModule(this);
            new ModuleAggregate(moduleID, null, "cacheModule.template");
        }
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.maxInMemoryCacheSize = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.inMemoryCacheSize = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.totalTimeoutInvalidations = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        Tr.warning((TraceComponent)tc, (String)"PMI00008W", (Object)("cacheModule, dataID=" + spdLong.getId()));
        return false;
    }

    public boolean isPMIEnabled() {
        int n = this.getInstrumentationLevel();
        return n != 1000 && n != -1 && n != 0;
    }

    public void updateCacheSizes(long l, long l2) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("udpateCacheSize, max=" + l + ", current=" + l2));
        }
        this.maxInMemoryCacheSize.setCount(l);
        this.inMemoryCacheSize.setCount(l2);
    }

    public void onCacheHit(String string, int n) {
        block12: {
            block11: {
                if (this.currentLevel <= 0) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("onCacheHit: template=" + string + " locality=" + n));
                }
                if (string == null) break block11;
                TemplateModule templateModule = (TemplateModule)this.templates.get(string);
                if (templateModule == null) {
                    templateModule = this.createTemplateModule(string);
                }
                if (templateModule.getInstrumentationLevel() <= 0) {
                    return;
                }
                switch (n) {
                    case 2: {
                        templateModule.hitsRemote.increment();
                        templateModule.entries.increment();
                        templateModule.remoteCreations.increment();
                        break block12;
                    }
                    case 1: {
                        templateModule.hitsInMemory.increment();
                        break block12;
                    }
                    case 3: {
                        templateModule.hitsOnDisk.increment();
                        break block12;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("onCacheHit() called with unrecognized locality " + n));
                        }
                        return;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("template was null: " + string));
            }
        }
    }

    public void onCacheMiss(String string, int n) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheMiss: template=" + string + " locality=" + n));
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (templateModule.getInstrumentationLevel() <= 0) {
                return;
            }
            templateModule.misses.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onCacheMiss: template was null");
        }
    }

    public void onEntryCreation(String string, int n) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onEntryCreation: template=" + string + " source=" + n));
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (templateModule.getInstrumentationLevel() <= 0) {
                return;
            }
            if (n == 2) {
                templateModule.remoteCreations.increment();
            }
            templateModule.entries.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onEntryCreation: template was null");
        }
    }

    public void onRequest(String string, int n) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onRequest: template=" + string + "source=" + n));
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (templateModule.getInstrumentationLevel() <= 0) {
                return;
            }
            if (n == 5) {
                templateModule.requestsFromClient.increment();
            } else if (n == 2) {
                templateModule.requestsFromJVM.increment();
            }
        }
    }

    public void batchOnInvalidate(String string, int n, int n2, int n3, int n4) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchOnInvalidate: " + string + ", " + n + ", " + n2 + ", " + n3 + ", " + n4));
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (templateModule.getInstrumentationLevel() <= 0) {
                return;
            }
            block0 : switch (n) {
                case 1: {
                    templateModule.explicitInvalidations.increment(n4);
                    switch (n2) {
                        case 1: {
                            templateModule.explicitInvalidationsFromMemory.increment(n4);
                            templateModule.entries.decrement(n4);
                            break;
                        }
                        case 3: {
                            templateModule.explicitInvalidationsFromDisk.increment(n4);
                            templateModule.entries.decrement(n4);
                        }
                    }
                    switch (n3) {
                        case 5: {
                            templateModule.explicitInvalidationsLocal.increment(n4);
                            break block0;
                        }
                        case 2: {
                            templateModule.explicitInvalidationsRemote.increment(n4);
                        }
                    }
                    break;
                }
                case 2: {
                    templateModule.lruInvalidations.increment(n4);
                    if (n2 == 3) break;
                    templateModule.entries.decrement(n4);
                    break;
                }
                case 3: {
                    templateModule.timeoutInvalidations.increment(n4);
                    this.totalTimeoutInvalidations.increment(n4);
                    templateModule.entries.decrement(n4);
                }
            }
        } else if (n == 3 && n2 == 3) {
            this.totalTimeoutInvalidations.increment(n4);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onInvalidate: template was null");
        }
    }

    public void onInvalidate(String string, int n, int n2, int n3) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onInvalidate: " + string + ", " + n + ", " + n2 + ", " + n3));
        }
        this.batchOnInvalidate(string, n, n2, n3, 1);
    }

    private synchronized TemplateModule createTemplateModule(String string) {
        TemplateModule templateModule = (TemplateModule)this.templates.get(string);
        if (templateModule == null) {
            templateModule = new TemplateModule(string);
            this.templates.put(string, templateModule);
        }
        return templateModule;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

