/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ConnPoolPerf;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ConnPoolModule
extends PmiAbstractModule
implements ConnPoolPerf {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$ConnPoolModule == null ? (class$com$ibm$ws$pmi$server$modules$ConnPoolModule = ConnPoolModule.class$("com.ibm.ws.pmi.server.modules.ConnPoolModule")) : class$com$ibm$ws$pmi$server$modules$ConnPoolModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "connectionPoolModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl numCreates = null;
    private CountStatisticImpl numDestroys = null;
    private CountStatisticImpl numAllocates = null;
    private CountStatisticImpl numReturns = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl freePoolSize = null;
    private BoundedRangeStatisticImpl concurrentWaiters = null;
    private TimeStatisticImpl avgWaitTime = null;
    private TimeStatisticImpl avgUseTime = null;
    private CountStatisticImpl faults = null;
    private CountStatisticImpl prepStmtDiscards = null;
    private BoundedRangeStatisticImpl percentMaxed = null;
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_ALLOCATES = 3;
    public static final int NUM_RETURNS = 4;
    public static final int POOL_SIZE = 5;
    public static final int FREE_POOL_SIZE = 6;
    public static final int CONCURRENT_WAITERS = 7;
    public static final int FAULTS = 8;
    public static final int PERCENT_USED = 9;
    public static final int PERCENT_MAXED = 10;
    public static final int AVG_USE_TIME = 12;
    public static final int AVG_WAIT_TIME = 13;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int PREPSTMT_DISCARDS = 21;
    ObjectName providerOName = null;
    ObjectName dsOName = null;
    String pName = null;
    private int localMaxPoolSize = 0;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$ConnPoolModule;

    public ConnPoolModule(String string, ObjectName objectName, ObjectName objectName2) {
        super(moduleID, string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConnPoolModule " + string));
        }
        if (objectName == null) {
            this.pName = "unknown";
        } else {
            DataDescriptor dataDescriptor;
            this.pName = objectName.getKeyProperty("name");
            if (this.pName == null) {
                this.pName = "undefined";
            }
            if (PmiRegistry.findPmiModule(dataDescriptor = new DataDescriptor(new String[]{moduleID, this.pName})) == null) {
                new ResourcePmiModule(moduleID, this.pName, objectName);
            }
        }
        this.providerOName = objectName;
        this.dsOName = objectName2;
        this.registerModule(this);
    }

    public String[] getPath() {
        if (this.pName != null) {
            String string = this.providerOName.getKeyProperty("name");
            return new String[]{moduleID, string, this.instanceName};
        }
        Tr.warning((TraceComponent)tc, (String)"getPath: Provider ObjectName is null");
        return new String[]{moduleID, this.instanceName};
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 9) {
            return new SpdLoadExternal(n, new PercentUsedData(n));
        }
        return super.createOneData(pmiDataInfo);
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.numCreates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.numDestroys = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.numAllocates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 4: {
                this.numReturns = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 8: {
                this.faults = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 21: {
                this.prepStmtDiscards = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 13: {
                this.avgWaitTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 12: {
                this.avgUseTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 5: {
                this.poolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 6: {
                this.freePoolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 7: {
                this.concurrentWaiters = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 10: {
                this.percentMaxed = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionCreated(int n) {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionCreated, connectionCount=" + n + ", ds=" + this.getName()));
            }
            this.numCreates.increment();
        }
        if (this.currentLevel < 7) {
            if (this.poolSize != null) {
                this.poolSize.increment();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.poolSize.increment(l, 1L);
                this.freePoolSize.increment(l, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDestroyed(int n) {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionDestroyed, connectionCount=" + n + ", ds=" + this.getName()));
            }
            this.numDestroys.increment();
        }
        if (this.currentLevel < 7) {
            if (this.poolSize != null) {
                this.poolSize.decrement();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.decrement();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.poolSize.decrement(l, 1L);
                this.freePoolSize.decrement(l, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAllocated(int n, int n2) {
        this.localMaxPoolSize = n;
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionAllocated, maxPoolSize=" + n + ",numConnectionsInUse=" + n2 + ", ds=" + this.getName()));
            }
            this.numAllocates.increment();
        }
        if (this.currentLevel < 7) {
            if (this.freePoolSize != null) {
                this.freePoolSize.decrement();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.freePoolSize.decrement(l, 1L);
                if (n2 >= n) {
                    this.percentMaxed.add(l, 100L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFreed(int n, int n2) {
        this.localMaxPoolSize = n;
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionFreed, maxPoolSize=" + n + ",numConnectionsInUse=" + n2 + ", ds=" + this.getName()));
            }
            this.numReturns.increment();
        }
        if (this.currentLevel < 7) {
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.freePoolSize.increment(l, 1L);
                if (n2 < n) {
                    this.percentMaxed.add(l, 0L);
                }
            }
        }
    }

    public void beginWaitForConnection() {
        if (this.currentLevel > 0 && this.concurrentWaiters != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("beginWaitForConnection, ds=" + this.getName()));
            }
            this.concurrentWaiters.increment();
        }
    }

    public void endWaitForConnection(long l) {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.currentLevel > 0 && this.avgWaitTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("endWaitForConnection, waitTime=" + l + ", ds=" + this.getName()));
            }
            this.avgWaitTime.add(l * 1L);
        }
    }

    public void endUseConnection(long l) {
        if (this.currentLevel > 0 && this.avgUseTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("endUseConnection, useTime=" + l + ", ds=" + this.getName()));
            }
            this.avgUseTime.add(l * 1L);
        }
    }

    public void connectionWaitTimeout() {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionWaitTimeout, ds=" + this.getName()));
            }
            this.faults.increment();
        }
    }

    public void preparedStmtCacheDiscard() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("preparedStmtCacheDiscard, ds=" + this.getName()));
            }
            this.prepStmtDiscards.increment();
        }
    }

    public void setConfigData(String string, long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConfigData, min=" + l + ", max=" + l2 + ", ds=" + this.getName()));
        }
        if (string.equalsIgnoreCase("PoolSize")) {
            if (this.poolSize != null) {
                this.poolSize.setLowerBound(l);
                this.poolSize.setUpperBound(l2);
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.setLowerBound(0L);
                this.freePoolSize.setUpperBound(l2);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"PMI0019W", (Object)string);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConfigData");
        }
    }

    public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
        JDBCConnectionPoolStatsImpl jDBCConnectionPoolStatsImpl = new JDBCConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
        jDBCConnectionPoolStatsImpl.setJdbcDataSource(this.dsOName);
        return jDBCConnectionPoolStatsImpl;
    }

    public ObjectName getMyMBean() {
        return this.dsOName;
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        if (this.poolSize != null) {
            l2 = this.poolSize.getCurrent();
        }
        long l3 = 0L;
        if (this.freePoolSize != null) {
            l3 = this.freePoolSize.getCurrent();
        }
        if (l3 < 0L) {
            this.freePoolSize.setLastValue(0L);
            l = l2;
        } else {
            l = l2 - l3;
        }
        long l4 = 0L;
        if (this.concurrentWaiters != null) {
            l4 = this.concurrentWaiters.getCurrent();
        }
        if (l4 < 0L) {
            this.concurrentWaiters.setLastValue(0L);
        }
        if (this.localMaxPoolSize > 0 && this.percentMaxed != null && l >= (long)this.localMaxPoolSize) {
            this.percentMaxed.add(100L);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PercentUsedData
    implements SpdLoadExternalValue {
        private BoundedRangeStatisticImpl percentUsedValue = null;

        public PercentUsedData(int n) {
            this.percentUsedValue = new BoundedRangeStatisticImpl(n);
        }

        public BoundedRangeStatisticImpl getLoadValue() {
            if (ConnPoolModule.this.poolSize == null || ConnPoolModule.this.freePoolSize == null || this.percentUsedValue == null) {
                return null;
            }
            if (ConnPoolModule.this.localMaxPoolSize == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: PercentUsedData localMaxPoolSize is 0");
                }
                this.percentUsedValue.set(0L, 0L, 0L, 0L, this.percentUsedValue.getStartTime(), ConnPoolModule.this.poolSize.getLastSampleTime());
            } else {
                long l = (ConnPoolModule.this.poolSize.getCurrent() - ConnPoolModule.this.freePoolSize.getCurrent()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                long l2 = ConnPoolModule.this.poolSize.myupdate();
                ConnPoolModule.this.poolSize.setLastSampleTime(l2);
                ConnPoolModule.this.freePoolSize.myupdate(l2);
                ConnPoolModule.this.freePoolSize.setLastSampleTime(l2);
                double d = (ConnPoolModule.this.poolSize.getIntegral() - ConnPoolModule.this.freePoolSize.getIntegral()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                long l3 = ConnPoolModule.this.poolSize.getLastSampleTime();
                long l4 = ((long)ConnPoolModule.this.localMaxPoolSize - ConnPoolModule.this.freePoolSize.getHighWaterMark()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                long l5 = ((long)ConnPoolModule.this.localMaxPoolSize - ConnPoolModule.this.freePoolSize.getLowWaterMark()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                this.percentUsedValue.set(l4, l5, l, (long)d, this.percentUsedValue.getStartTime(), ConnPoolModule.this.poolSize.getLastSampleTime());
            }
            return this.percentUsedValue;
        }
    }
}

