/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.websphere.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.ObjectName;

public class J2CModule
extends PmiAbstractModule
implements J2CPerf {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$J2CModule == null ? (class$com$ibm$ws$pmi$server$modules$J2CModule = J2CModule.class$("com.ibm.ws.pmi.server.modules.J2CModule")) : class$com$ibm$ws$pmi$server$modules$J2CModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public String moduleID = "j2cModule";
    private static final int defaultLevel = 0;
    private String mcfName = null;
    private CountStatisticImpl numManagedConnections = null;
    private CountStatisticImpl numConnectionHandles = null;
    private CountStatisticImpl numManagedConnectionsCreated = null;
    private CountStatisticImpl numManagedConnectionsDestroyed = null;
    private CountStatisticImpl numManagedConnectionsAllocated = null;
    private CountStatisticImpl numManagedConnectionsReleased = null;
    private CountStatisticImpl numManagedConnectionTimeouts = null;
    private BoundedRangeStatisticImpl freePoolSize = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl concurrentWaiters = null;
    private BoundedRangeStatisticImpl percentMaxed = null;
    private TimeStatisticImpl averageWait = null;
    private TimeStatisticImpl useTime = null;
    private TimeStatisticImpl jdbcOpTimer = null;
    private CountStatisticImpl numDiscardedStmts = null;
    private Hashtable connectionToStartTime = new Hashtable();
    private Hashtable jdbcOpTimerTable = new Hashtable();
    private long localMaxPoolSize = 0L;
    private long localMinPoolSize = 0L;
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_ALLOCATES = 3;
    public static final int NUM_FREES = 4;
    public static final int POOL_SIZE = 5;
    public static final int FREE_POOL_SIZE = 6;
    public static final int CONCURRENT_WAITERS = 7;
    public static final int NUM_FAULTS = 8;
    public static final int PERCENT_USED = 9;
    public static final int PERCENT_MAXED = 10;
    public static final int USE_TIME = 12;
    public static final int AVERAGE_WAIT = 13;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int PREPSTMT_DISCARDS = 21;
    public static final int JDBC_OPERATION_TIMER = 22;
    private String pName = null;
    private ObjectName providerOName = null;
    private ObjectName cfOName = null;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$J2CModule;

    public J2CModule(String string, String string2, ObjectName objectName, ObjectName objectName2) {
        super(string, string2);
        DataDescriptor dataDescriptor;
        this.moduleID = string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new J2CModule: " + string2));
        }
        this.pName = objectName == null ? "jmsConnections" : objectName.getKeyProperty("name");
        if (this.pName == null) {
            this.pName = "undefined";
        }
        if (PmiRegistry.findPmiModule(dataDescriptor = new DataDescriptor(new String[]{this.moduleID, this.pName})) == null) {
            new ResourcePmiModule(this.moduleID, this.pName, objectName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new J2CModule: modId=" + string + ", eis=" + string2 + "\n  provider=" + objectName + "\n  factory=" + objectName2 + "\n   pname=" + this.pName));
        }
        this.providerOName = objectName;
        this.cfOName = objectName2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("provider name=" + this.pName));
        }
        this.registerModule(this);
    }

    public String[] getPath() {
        if (this.pName != null) {
            return new String[]{this.moduleID, this.pName, this.instanceName};
        }
        return new String[]{this.moduleID, this.instanceName};
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 9) {
            return new SpdLoadExternal(n, new PercentUsedData(n));
        }
        return super.createOneData(pmiDataInfo);
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 14: {
                this.numManagedConnections = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 15: {
                this.numConnectionHandles = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 1: {
                this.numManagedConnectionsCreated = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.numManagedConnectionsDestroyed = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.numManagedConnectionsAllocated = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 4: {
                this.numManagedConnectionsReleased = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 8: {
                this.numManagedConnectionTimeouts = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 21: {
                this.numDiscardedStmts = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 6: {
                this.freePoolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 5: {
                this.poolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 10: {
                this.percentMaxed = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 7: {
                this.concurrentWaiters = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 13: {
                this.averageWait = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 12: {
                this.useTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 22: {
                this.jdbcOpTimer = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void incrementManagedConnectionCount() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"incrementManagedConnectionCount");
            }
            this.numManagedConnections.increment();
        }
    }

    public void decrementManagedConnectionCount() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decrementManagedConnectionCount");
            }
            this.numManagedConnections.decrement();
        }
    }

    public void incrementConnectionHandleCount() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"incrementConnectionHandleCount");
            }
            this.numConnectionHandles.increment();
        }
    }

    public void decrementConnectionHandleCount() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decrementConnectionHandleCount");
            }
            this.numConnectionHandles.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedConnectionCreated() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"managedConnectionCreated");
            }
            this.numManagedConnectionsCreated.increment();
            this.incrementManagedConnectionCount();
        }
        if (this.currentLevel < 7) {
            if (this.poolSize != null) {
                this.poolSize.increment();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.poolSize.increment(l, 1L);
                this.freePoolSize.increment(l, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedConnectionDestroyed() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"managedConnectionDestroyed");
            }
            this.numManagedConnectionsDestroyed.increment();
            this.decrementManagedConnectionCount();
        }
        if (this.currentLevel < 7) {
            if (this.poolSize != null) {
                this.poolSize.decrement();
            }
            if (this.freePoolSize != null && this.freePoolSize.getCurrent() > 0L) {
                this.freePoolSize.decrement();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.poolSize.decrement(l, 1L);
                if (this.freePoolSize.getCurrent() > 0L) {
                    this.freePoolSize.decrement(l, 1L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedConnectionAllocated() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"managedConnectionAllocated");
            }
            this.numManagedConnectionsAllocated.increment();
        }
        if (this.currentLevel < 7) {
            if (this.freePoolSize != null && this.freePoolSize.getCurrent() > 0L) {
                this.freePoolSize.decrement();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                if (this.freePoolSize.getCurrent() > 0L) {
                    this.freePoolSize.decrement(l, 1L);
                }
                long l2 = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.percentMaxed != null && this.localMaxPoolSize != 0L && l2 >= this.localMaxPoolSize) {
                    this.percentMaxed.add(l, 100L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedConnectionFreed() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"managedConnectionFreed");
            }
            this.numManagedConnectionsReleased.increment();
        }
        if (this.currentLevel < 7) {
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        } else {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.freePoolSize.increment(l, 1L);
                long l2 = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.percentMaxed != null && this.localMaxPoolSize != 0L && l2 < this.localMaxPoolSize) {
                    this.percentMaxed.add(0L);
                }
            }
        }
    }

    public void beginWaitForManagedConnection() {
        if (this.concurrentWaiters != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginWaitForManagedConnection");
            }
            this.concurrentWaiters.increment();
        }
    }

    public void endWaitForManagedConnection(long l) {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"endWaitForManagedConnection");
            }
            if (this.averageWait != null) {
                this.averageWait.add(l);
            }
        }
    }

    public void managedConnectionFault() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"managedConnectionFault");
            }
            this.numManagedConnectionTimeouts.increment();
        }
    }

    public void beginUseManagedConnection(Object object) {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginUseManagedConnection");
            }
            if (!this.connectionToStartTime.containsKey(object)) {
                this.connectionToStartTime.put(object, new Long(System.currentTimeMillis()));
            }
        }
    }

    public void endUseManagedConnection(Object object) {
        if (this.useTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"endUseManagedConnection");
            }
            if (this.connectionToStartTime.containsKey(object)) {
                long l = System.currentTimeMillis();
                Long l2 = (Long)this.connectionToStartTime.get(object);
                long l3 = l - l2;
                this.connectionToStartTime.remove(object);
                this.useTime.add(l3);
            }
        }
    }

    public void setMaxPoolSize(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMaxPoolSize, max=" + l));
        }
        this.setPoolSize(0L, l);
    }

    public void setPoolSize(long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPoolSize, min=" + l + ", max=" + l2));
        }
        this.localMaxPoolSize = l2;
        this.localMinPoolSize = l;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(this.localMinPoolSize);
            this.poolSize.setUpperBound(this.localMaxPoolSize);
        }
        if (this.freePoolSize != null) {
            this.freePoolSize.setLowerBound(0L);
            this.freePoolSize.setUpperBound(this.localMaxPoolSize);
        }
    }

    public void jdbcOperationCompleted() {
        if (this.currentLevel > 0 && this.jdbcOpTimer != null) {
            Long l = (Long)this.jdbcOpTimerTable.get(Thread.currentThread());
            if (l == null) {
                return;
            }
            long l2 = System.currentTimeMillis() - l;
            this.jdbcOpTimerTable.remove(Thread.currentThread());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jdbcOperationCompleted in " + l2 + " ms."));
            }
            this.jdbcOpTimer.add(l2);
        }
    }

    public void jdbcOperationStarted() {
        if (this.currentLevel > 0 && this.jdbcOpTimer != null) {
            Long l = new Long(System.currentTimeMillis());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jdbcOperationStarted at " + l + " ms."));
            }
            this.jdbcOpTimerTable.put(Thread.currentThread(), l);
        }
    }

    public void statementDiscardedFromCache(Object object) {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"statementDiscardedFromCach");
            }
            this.numDiscardedStmts.increment();
        }
    }

    public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
        if (this.moduleID.equals("j2cModule")) {
            JCAConnectionPoolStatsImpl jCAConnectionPoolStatsImpl = new JCAConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
            jCAConnectionPoolStatsImpl.setConnectionFactory(this.cfOName);
            return jCAConnectionPoolStatsImpl;
        }
        JDBCConnectionPoolStatsImpl jDBCConnectionPoolStatsImpl = new JDBCConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
        jDBCConnectionPoolStatsImpl.setJdbcDataSource(this.cfOName);
        return jDBCConnectionPoolStatsImpl;
    }

    public ObjectName getMyMBean() {
        return this.cfOName;
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        if (this.poolSize != null) {
            l2 = this.poolSize.getCurrent();
        }
        if (l2 < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long l3 = 0L;
        if (this.freePoolSize != null) {
            l3 = this.freePoolSize.getCurrent();
        }
        if (l3 < 0L) {
            this.freePoolSize.setLastValue(0L);
            l = l2;
        } else {
            l = l2 - l3;
        }
        long l4 = 0L;
        if (this.concurrentWaiters != null) {
            l4 = this.concurrentWaiters.getCurrent();
        }
        if (l4 < 0L) {
            this.concurrentWaiters.setLastValue(0L);
        }
        if (this.localMaxPoolSize > 0L && this.percentMaxed != null && l >= this.localMaxPoolSize) {
            this.percentMaxed.add(100L);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PercentUsedData
    implements SpdLoadExternalValue {
        private BoundedRangeStatisticImpl percentUsedValue = null;

        public PercentUsedData(int n) {
            this.percentUsedValue = new BoundedRangeStatisticImpl(n);
        }

        public BoundedRangeStatisticImpl getLoadValue() {
            if (J2CModule.this.poolSize == null || J2CModule.this.freePoolSize == null || this.percentUsedValue == null) {
                return null;
            }
            if (J2CModule.this.localMaxPoolSize == 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: PercentUsedData localMaxPoolSize is 0");
                }
                this.percentUsedValue.set(0L, 0L, 0L, 0L, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            } else {
                long l = (J2CModule.this.poolSize.getCurrent() - J2CModule.this.freePoolSize.getCurrent()) * 100L / J2CModule.this.localMaxPoolSize;
                long l2 = J2CModule.this.poolSize.myupdate();
                J2CModule.this.poolSize.setLastSampleTime(l2);
                J2CModule.this.freePoolSize.myupdate(l2);
                J2CModule.this.freePoolSize.setLastSampleTime(l2);
                double d = (J2CModule.this.poolSize.getIntegral() - J2CModule.this.freePoolSize.getIntegral()) * 100L / J2CModule.this.localMaxPoolSize;
                long l3 = J2CModule.this.poolSize.getLastSampleTime();
                long l4 = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getHighWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                long l5 = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getLowWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                this.percentUsedValue.set(l4, l5, l, (long)d, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            }
            return this.percentUsedValue;
        }
    }
}

