/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.Hashtable;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.InterceptorOperations;

public class OrbPerfModule
extends PmiAbstractModule
implements PMIPlugin {
    private static final String moduleID = "orbPerfModule";
    private static final int defaultLevel = 0;
    private TimeStatisticImpl referenceLookupTime = null;
    private CountStatisticImpl numRequests = null;
    private RangeStatisticImpl currentRequests = null;
    private Hashtable interceptorData = new Hashtable();
    private String orbIdentifier = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$OrbPerfModule == null ? (class$com$ibm$ws$pmi$server$modules$OrbPerfModule = OrbPerfModule.class$("com.ibm.ws.pmi.server.modules.OrbPerfModule")) : class$com$ibm$ws$pmi$server$modules$OrbPerfModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final int REFERENCE_LOOKUP_TIME = 1;
    public static final int TOTAL_NUM_REQUESTS = 2;
    public static final int CONCURRENT_REQUESTS = 3;
    public static final int INTERCEPTORS = 10;
    public static final int PROCESSING_TIME = 11;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$OrbPerfModule;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$OrbPerfModule$InterceptorPmiModule;

    public OrbPerfModule() throws Exception {
        super(moduleID, "ORB");
        if (PmiRegistry.isDisabled()) {
            throw new Exception("PMI is disabled and new OrbPerfModule should not be initiated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new OrbPerfModule");
        }
        this.type = 13;
    }

    public OrbPerfModule(ORB oRB) throws Exception {
        this();
        if (PmiRegistry.isDisabled()) {
            throw new Exception("PMI is disabled and new OrbPerfModule should not be initiated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new OrbPerfModule");
        }
        this.init(oRB);
    }

    public void init(ORB oRB) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init");
        }
        if (oRB != null && !PmiRegistry.isDisabled()) {
            this.moduleConfig = PmiRegistry.getConfig(moduleID);
            this.orbIdentifier = "IBM ORB:" + oRB.getTransientServerId();
            this.registerModule(this);
            new ModuleAggregate(moduleID, null, "orbPerfModule.interceptors");
        }
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void onInterceptorRegister(Interceptor interceptor) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onInterceptorRegister");
        }
        if (interceptor != null) {
            InterceptorPmiModule interceptorPmiModule;
            String string = this.interceptorName(interceptor);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("interceptorName=" + string));
            }
            if ((interceptorPmiModule = (InterceptorPmiModule)this.interceptorData.get(string)) == null) {
                interceptorPmiModule = this.recoverFromInterceptorNotFound(string);
            }
        }
    }

    public void preInterceptorRun(Interceptor interceptor) {
    }

    public void postInterceptorRun(Interceptor interceptor, long l) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (interceptor != null) {
            String string = this.interceptorName(interceptor);
            InterceptorPmiModule interceptorPmiModule = (InterceptorPmiModule)this.interceptorData.get(string);
            if (interceptorPmiModule == null) {
                interceptorPmiModule = this.recoverFromInterceptorNotFound(string);
            }
            interceptorPmiModule.addResponseTime(l);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("postInterceptorRun " + string));
            }
        }
    }

    public void preObjectReferenceLookup() {
    }

    public void postObjectReferenceLookup(long l) {
        if (this.currentLevel > 0 && this.referenceLookupTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("postObjectReferenceLookup, timeTaken=" + l));
            }
            this.referenceLookupTime.add(l);
        }
    }

    public void preRequestMarshalling() {
    }

    public void postRequestMarshalling(long l) {
    }

    public void newRequest() {
        if (this.currentRequests != null) {
            this.currentRequests.increment();
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"newRequest");
            }
            this.numRequests.increment();
        }
    }

    public void requestCompleted() {
        if (this.currentRequests != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestCompleted");
            }
            this.currentRequests.decrement();
        }
    }

    public void lsdLookupRequired() {
    }

    private String interceptorName(Interceptor interceptor) {
        String string = null;
        if (interceptor != null && ((string = interceptor.name()) == null || string.equals(""))) {
            string = interceptor.getClass().getName();
        }
        return string;
    }

    protected InterceptorPmiModule recoverFromInterceptorNotFound(String string) {
        InterceptorPmiModule interceptorPmiModule = new InterceptorPmiModule(this.orbIdentifier, string);
        this.interceptorData.put(string, interceptorPmiModule);
        return interceptorPmiModule;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 2: {
                this.numRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 3: {
                this.currentRequests = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 1: {
                this.referenceLookupTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public void onInterceptorRegister(InterceptorOperations interceptorOperations) {
    }

    public void preInterceptorRun(InterceptorOperations interceptorOperations) {
    }

    public void postInterceptorRun(InterceptorOperations interceptorOperations, long l) {
    }

    public void locationForwardResponseReceived() {
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        if (this.currentRequests != null) {
            l = this.currentRequests.getCurrent();
        }
        if (l < 0L) {
            this.currentRequests.setLastValue(0L);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class InterceptorPmiModule
    extends PmiAbstractModule {
        private final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$OrbPerfModule$InterceptorPmiModule == null ? (class$com$ibm$ws$pmi$server$modules$OrbPerfModule$InterceptorPmiModule = OrbPerfModule.class$("com.ibm.ws.pmi.server.modules.OrbPerfModule$InterceptorPmiModule")) : class$com$ibm$ws$pmi$server$modules$OrbPerfModule$InterceptorPmiModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
        TimeStatisticImpl processingTime = null;

        public InterceptorPmiModule(String string, String string2) {
            super(OrbPerfModule.moduleID, string);
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"new InterceptorPmiModule");
            }
            this.submoduleName = "orbPerfModule.interceptors";
            this.subinstanceName = string2;
            this.type = 16;
            this.registerModule(this);
        }

        public String[] getPath() {
            return new String[]{OrbPerfModule.moduleID, "orbPerfModule.interceptors", this.subinstanceName};
        }

        public void destroy() {
            this.processingTime = null;
            PmiRegistry.unregisterModule(this);
        }

        public void addResponseTime(long l) {
            if (this.currentLevel > 0 && this.processingTime != null) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("addResponseTime, time=" + l + ", ORB interceptor is " + this.subinstanceName));
                }
                this.processingTime.add(l);
            }
        }

        protected boolean statCreated(SpdStat spdStat) {
            switch (spdStat.getId()) {
                case 11: {
                    this.processingTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return OrbPerfModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

