/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdGroup;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.JVMStatsImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.jvmpi.JvmpiGroup;
import java.util.ArrayList;

public class RuntimeModule
extends PmiAbstractModule
implements PmiModuleAggregate {
    public static String moduleID = "jvmRuntimeModule";
    private static final int defaultLevel = 0;
    private SpdLoadExternal totalMemory = null;
    private SpdLongExternal freeMemory = null;
    private SpdLongExternal usedMemory = null;
    private SpdLong upTime = null;
    public static long jvmStartTime = 0L;
    public static final int MEMORY_TOTAL = 1;
    public static final int MEMORY_FREE = 2;
    public static final int MEMORY_USED = 3;
    public static final int UP_TIME = 4;
    private static boolean jvmpiLoaded = false;
    private static boolean init = false;

    public RuntimeModule() {
        super(moduleID, "jvm.memory");
        this.type = 13;
        jvmStartTime = System.currentTimeMillis();
        this.aggregateModule = true;
        this.registerModule(this);
        if (!jvmpiLoaded && this.currentLevel >= 15) {
            jvmpiLoaded = true;
            new JvmpiGroup();
        }
        init = true;
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 1) {
            this.totalMemory = new SpdLoadExternal(n, new JvmLoadData(n, 0L, 0L));
            return this.totalMemory;
        }
        if (n == 2) {
            this.freeMemory = new SpdLongExternal(n, new JvmData(2));
            return this.freeMemory;
        }
        if (n == 3) {
            this.usedMemory = new SpdLongExternal(n, new JvmData(3));
            return this.usedMemory;
        }
        if (n == 4) {
            this.upTime = new SpdLongExternal(n, new JvmData(4));
            return this.upTime;
        }
        SpdData spdData = this.createAggregateData(pmiDataInfo);
        return spdData;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public synchronized void add(PmiModule pmiModule) {
        if (pmiModule == null) {
            return;
        }
        this.add(pmiModule.listData());
    }

    public synchronized void remove(PmiModule pmiModule) {
        if (pmiModule == null) {
            return;
        }
        this.remove(pmiModule.listData());
    }

    public synchronized void add(SpdData[] spdDataArray) {
        if (spdDataArray == null || this.moduleConfig == null) {
            return;
        }
        for (int i = 0; i < spdDataArray.length; ++i) {
            int n = spdDataArray[i].getId();
            PmiDataInfo pmiDataInfo = this.moduleConfig.getDataInfo(n);
            if (pmiDataInfo == null || !pmiDataInfo.isAggregatable()) continue;
            SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(n));
            if (spdGroup == null) {
                spdGroup = (SpdGroup)this.createAggregateData(pmiDataInfo);
                if (spdGroup != null) {
                    this.putToTable(spdGroup);
                }
                if (pmiDataInfo.getLevel() > this.currentLevel) {
                    spdGroup.disable();
                }
            }
            spdGroup.add(spdDataArray[i]);
        }
    }

    public synchronized void remove(SpdData[] spdDataArray) {
        if (spdDataArray == null) {
            return;
        }
        for (int i = 0; i < spdDataArray.length; ++i) {
            SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(spdDataArray[i].getId()));
            if (spdGroup == null) continue;
            spdGroup.remove(spdDataArray[i]);
        }
    }

    public synchronized boolean remove(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(spdData.getId()));
        if (spdGroup == null) {
            return false;
        }
        return spdGroup.remove(spdData);
    }

    public void setInstrumentationLevel(int n) {
        int n2 = this.currentLevel;
        super.setInstrumentationLevel(n);
        if (init && n > n2 && n >= 15 && !jvmpiLoaded) {
            jvmpiLoaded = true;
            JvmpiGroup jvmpiGroup = new JvmpiGroup();
        }
    }

    public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
        return new JVMStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
    }

    private class JvmLoadData
    implements SpdLoadExternalValue {
        int type = this.type;
        BoundedRangeStatisticImpl data = null;

        public JvmLoadData(int n, long l, long l2) {
            this.data = new BoundedRangeStatisticImpl(n);
            this.data.setUpperBound(l2);
            this.data.setLowerBound(l);
            this.getLoadValue();
        }

        public BoundedRangeStatisticImpl getLoadValue() {
            long l = Runtime.getRuntime().totalMemory() / 1000L;
            this.data.add(l);
            long l2 = this.data.myupdate();
            this.data.setLastSampleTime(l2);
            return this.data;
        }
    }

    private class JvmData
    implements SpdLongExternalValue {
        int type = 0;

        public JvmData(int n) {
            this.type = n;
        }

        public long getLongValue() {
            long l = 0L;
            if (this.type == 2) {
                l = Runtime.getRuntime().freeMemory() / 1000L;
            } else if (this.type == 3) {
                l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L;
            } else if (this.type == 4) {
                l = (System.currentTimeMillis() - jvmStartTime) / 1000L;
            } else {
                l = 0L;
                System.err.println("WARNING: getLongValue, wrong type");
            }
            return l;
        }
    }
}

