/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.SessionMemoryInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.modules.RuntimeModule;

public class ServletSessionsModule
extends PmiAbstractModule
implements ServletSessionsPerf {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$ServletSessionsModule == null ? (class$com$ibm$ws$pmi$server$modules$ServletSessionsModule = ServletSessionsModule.class$("com.ibm.ws.pmi.server.modules.ServletSessionsModule")) : class$com$ibm$ws$pmi$server$modules$ServletSessionsModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "servletSessionsModule";
    public static final int defaultLevel = 0;
    private CountStatisticImpl createdSessions = null;
    private CountStatisticImpl invalidatedSessions = null;
    private CountStatisticImpl finalizedSessions = null;
    private TimeStatisticImpl sessionLifeTime = null;
    private TimeStatisticImpl sessionInvalidateTime = null;
    private RangeStatisticImpl activeSessions = null;
    private RangeStatisticImpl liveSessions = null;
    private boolean notPrinted = true;
    private CountStatisticImpl sessCreateErrors = null;
    private CountStatisticImpl cacheDiscards = null;
    private CountStatisticImpl affinityBreaks = null;
    private TimeStatisticImpl extReadTime = null;
    private TimeStatisticImpl extReadSize = null;
    private TimeStatisticImpl extWriteTime = null;
    private TimeStatisticImpl extWriteSize = null;
    private TimeStatisticImpl timeSinceLastActivated = null;
    private CountStatisticImpl invalidateViaTimeout = null;
    private CountStatisticImpl activateNonExistSession = null;
    private TimeStatisticImpl serializableObjSize = null;
    private TimeStatisticImpl myObjSize = null;
    public static final int CREATED_SESSIONS = 1;
    public static final int INVALIDATED_SESSIONS = 2;
    public static final int FINALIZED_SESSIONS = 3;
    public static final int SESSION_LIFE_TIME = 4;
    public static final int SESSION_INVALIDATE_TIME = 5;
    public static final int ACTIVE_SESSIONS = 6;
    public static final int LIVE_SESSIONS = 7;
    public static final int SESSION_CREATE_ERRORS = 8;
    public static final int CACHE_DISCARDS = 9;
    public static final int EXTERNAL_READ_TIME = 10;
    public static final int EXTERNAL_READ_SIZE = 11;
    public static final int EXTERNAL_WRITE_TIME = 12;
    public static final int EXTERNAL_WRITE_SIZE = 13;
    public static final int AFFINITY_BREAKS = 14;
    public static final int TIME_SINCE_LAST_ACTIVATED = 15;
    public static final int INVALIDATE_VIA_TIMEOUT = 16;
    public static final int INVALIDATE_NONEXIST_SESSION = 17;
    public static final int SERIALIZABLE_SESSOBJ_SIZE = 18;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$ServletSessionsModule;

    public ServletSessionsModule(String string, PmiCallback pmiCallback) {
        super(moduleID, string, pmiCallback);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new ServletSessionsModule, webapp=" + string));
        }
        this.registerModule(this);
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.createdSessions = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.invalidatedSessions = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.finalizedSessions = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 8: {
                this.sessCreateErrors = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 9: {
                this.cacheDiscards = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 14: {
                this.affinityBreaks = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 16: {
                this.invalidateViaTimeout = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 17: {
                this.activateNonExistSession = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 4: {
                this.sessionLifeTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 5: {
                this.sessionInvalidateTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 10: {
                this.extReadTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 11: {
                this.extReadSize = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 12: {
                this.extWriteTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 13: {
                this.extWriteSize = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 15: {
                this.timeSinceLastActivated = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 6: {
                this.activeSessions = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 7: {
                this.liveSessions = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 18) {
            this.myObjSize = new TimeStatisticImpl(n);
            return new SpdStatExternal(n, new SessionObjSize());
        }
        return super.createOneData(pmiDataInfo);
    }

    public void sessionCreated() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sessionCreated");
            }
            this.createdSessions.increment();
        }
    }

    public void sessionActivated() {
        if (this.activeSessions != null) {
            this.activeSessions.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sessionActivated");
        }
    }

    public void sessionActivated(long l) {
        if (this.activeSessions != null) {
            this.activeSessions.increment();
        }
        if (this.currentLevel > 0 && this.timeSinceLastActivated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sessionActivated, timeAfterLastActivation=" + l));
            }
            if (l >= 0L) {
                this.timeSinceLastActivated.add(l);
            }
        }
    }

    public void sessionInactivated() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sessionInactivated");
        }
        if (this.activeSessions != null) {
            this.activeSessions.decrement();
        }
    }

    public void sessionInvalidated(long l) {
        if (l < RuntimeModule.jvmStartTime) {
            return;
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sessionInvalidated, creationTime=" + l));
            }
            this.invalidatedSessions.increment();
            if (l > 0L && this.sessionLifeTime != null) {
                this.sessionLifeTime.add(System.currentTimeMillis() - l * 1L);
            }
        }
    }

    public void sessionFinalized(long l) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sessionFinalized, invalidationTime=" + l));
        }
        if (this.notPrinted) {
            System.err.println("WARNING: sessionFinalized is called");
            this.notPrinted = false;
        }
        this.finalizedSessions.increment();
        if (l > 0L && this.sessionInvalidateTime != null) {
            this.sessionInvalidateTime.add(System.currentTimeMillis() - l * 1L);
        }
    }

    public void sessionAdded() {
        if (this.liveSessions != null) {
            this.liveSessions.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sessionAdded");
            }
        }
    }

    public void sessionRemoved() {
        if (this.liveSessions != null) {
            this.liveSessions.decrement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sessionRemoved");
            }
        }
    }

    public void noRoomForNewSession() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"noRoomForNewSession");
            }
            this.sessCreateErrors.increment();
        }
    }

    public void discardCache() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"discardCache");
            }
            this.cacheDiscards.increment();
        }
    }

    public void readExternal(long l, long l2) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readExternal, time=" + l + ", size=" + l2));
        }
        if (this.extReadTime != null && l >= 0L) {
            this.extReadTime.add(l * 1L);
        }
        if (this.extReadSize != null && l2 >= 0L) {
            this.extReadSize.add(l2);
        }
    }

    public void writeExternal(long l, long l2) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeExternal, time=" + l + ", size=" + l2));
        }
        if (this.extWriteTime != null && l >= 0L) {
            this.extWriteTime.add(l * 1L);
        }
        if (this.extWriteSize != null && l2 >= 0L) {
            this.extWriteSize.add(l2);
        }
    }

    public void affinityBreak() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"affinityBreak");
            }
            this.affinityBreaks.increment();
        }
    }

    public void invalidatedViaTimeout() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidatedViaTimeout");
            }
            this.invalidateViaTimeout.increment();
        }
    }

    public void attempToActiveNonExistSession() {
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempToActiveNonExistSession");
            }
            this.activateNonExistSession.increment();
        }
    }

    public void unregister() {
        PmiRegistry.unregisterModule(this);
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        if (this.activeSessions != null) {
            l = this.activeSessions.getCurrent();
        }
        if (l < 0L) {
            this.activeSessions.setLastValue(0L);
        }
        l = 0L;
        if (this.liveSessions != null) {
            l = this.liveSessions.getCurrent();
        }
        if (l < 0L) {
            this.liveSessions.setLastValue(0L);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SessionObjSize
    implements SpdStatExternalValue {
        private SessionObjSize() {
        }

        public TimeStatisticImpl getStatValue() {
            if (ServletSessionsModule.this.callback == null) {
                ServletSessionsModule.this.myObjSize.set(0L, 0L, 0L, 0L, 0L, ServletSessionsModule.this.myObjSize.getStartTime(), System.currentTimeMillis());
                return ServletSessionsModule.this.myObjSize;
            }
            SessionMemoryInfo sessionMemoryInfo = (SessionMemoryInfo)ServletSessionsModule.this.callback.getRuntimeInfo();
            long l = sessionMemoryInfo.getTotal() * 1L;
            ServletSessionsModule.this.myObjSize.set(sessionMemoryInfo.getCount(), sessionMemoryInfo.getMin(), sessionMemoryInfo.getMax(), l, l * l, ServletSessionsModule.this.myObjSize.getStartTime(), System.currentTimeMillis());
            return ServletSessionsModule.this.myObjSize;
        }
    }
}

