/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatImpl;
import com.ibm.ws.pmi.server.system.SystemData;

public class SystemModule
extends PmiAbstractModule {
    public static String moduleID = "systemModule";
    private static final int defaultLevel = 0;
    private SpdLongExternal freeMemory;
    private SpdLongExternal cpuUtilization;
    private SpdStat avgCpuUtilization;
    public static final int CPU_UTILIZATION = 1;
    public static final int AVG_CPU_UTILIZATION = 2;
    public static final int FREE_MEMORY = 3;
    private SystemData systemData;
    private TimeStatisticImpl stat;
    private boolean firstTime;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$SystemModule == null ? (class$com$ibm$ws$pmi$server$modules$SystemModule = SystemModule.class$("com.ibm.ws.pmi.server.modules.SystemModule")) : class$com$ibm$ws$pmi$server$modules$SystemModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$SystemModule;

    public SystemModule(String string) {
        boolean bl;
        block5: {
            super(moduleID, string);
            this.freeMemory = null;
            this.cpuUtilization = null;
            this.avgCpuUtilization = null;
            this.systemData = null;
            this.stat = null;
            this.firstTime = true;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"new SysteModuleName");
            }
            this.type = 13;
            bl = true;
            try {
                this.systemData = new SystemData();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"SystemModule constructor failed");
            }
        }
        if (bl) {
            super.registerModule(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"new SysteModuleName");
        }
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 3) {
            this.freeMemory = new SpdLongExternal(n, new SystemPerfData(3, this.systemData));
            return this.freeMemory;
        }
        if (n == 1) {
            this.cpuUtilization = new SpdLongExternal(n, new SystemPerfData(1, this.systemData));
            return this.cpuUtilization;
        }
        if (n == 2) {
            this.avgCpuUtilization = new SpdStatImpl(n);
            return this.avgCpuUtilization;
        }
        if (tc.isDebugEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"PMI0008W", (Object)("dataID=" + n));
        }
        return null;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SystemPerfData
    implements SpdLongExternalValue {
        int type = 0;
        private SystemData systemData;

        public SystemPerfData(int n, SystemData systemData) {
            this.type = n;
            this.systemData = systemData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLongValue() {
            long l = 0L;
            if (this.type == 1) {
                l = this.systemData.getCpuUtilization();
                if (SystemModule.this.firstTime) {
                    l = 0L;
                    SystemModule.this.firstTime = false;
                } else if (SystemModule.this.avgCpuUtilization != null) {
                    SpdStat spdStat = SystemModule.this.avgCpuUtilization;
                    synchronized (spdStat) {
                        long l2;
                        long l3 = System.currentTimeMillis();
                        SystemModule.this.stat = (TimeStatisticImpl)SystemModule.this.avgCpuUtilization.getStatistic();
                        if (SystemModule.this.stat != null && (l2 = (l3 - SystemModule.this.stat.getLastSampleTime()) / 1000L) != 0L) {
                            long l4 = SystemModule.this.stat.getMin();
                            long l5 = SystemModule.this.stat.getMax();
                            if (l4 < 0L) {
                                l4 = l;
                            } else if (l < l4) {
                                l4 = l;
                            }
                            if (l > l5) {
                                l5 = l;
                            }
                            SystemModule.this.stat.set(SystemModule.this.stat.getCount() + l2, l4, l5, SystemModule.this.stat.getTotal() + l * l2, 0L, SystemModule.this.stat.getStartTime(), l3);
                        }
                    }
                }
            } else if (this.type == 3) {
                l = this.systemData.getFreeMemory();
            } else {
                l = 0L;
                if (tc.isDebugEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"PMI0008W", (Object)("dataId=" + this.type));
                }
            }
            return l;
        }
    }
}

