/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.PmiAttribute;
import com.ibm.ws.pmi.server.PmiCallback;

public class ThreadPoolModule
extends PmiAbstractModule
implements ThreadPoolPerf {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$ThreadPoolModule == null ? (class$com$ibm$ws$pmi$server$modules$ThreadPoolModule = ThreadPoolModule.class$("com.ibm.ws.pmi.server.modules.ThreadPoolModule")) : class$com$ibm$ws$pmi$server$modules$ThreadPoolModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "threadPoolModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl threadCreates = null;
    private CountStatisticImpl threadDestroys = null;
    private BoundedRangeStatisticImpl activeThreads = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl percentMaxed = null;
    private CountStatisticImpl declaredThreadHung = null;
    private CountStatisticImpl declaredThreadHangCleared = null;
    private BoundedRangeStatisticImpl concurrentlyHungThreads = null;
    private TimeStatisticImpl activeTime = null;
    public static final int THREAD_CREATES = 1;
    public static final int THREAD_DESTROYS = 2;
    public static final int ACTIVE_THREADS = 3;
    public static final int POOL_SIZE = 4;
    public static final int PERCENT_MAXED = 5;
    public static final int THREAD_HUNG = 6;
    public static final int HANG_CLEARED = 7;
    public static final int CONCURRENT_HUNG = 8;
    public static final int ACTIVE_TIME = 9;
    private boolean isThreadHangDetectionEnabled = false;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$ThreadPoolModule;

    public ThreadPoolModule(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ThreadPoolModule(String string, int n, int n2, PmiCallback pmiCallback) {
        super(moduleID, string, pmiCallback);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new ThreadPoolModule, pool=" + string));
        }
        this.registerModule(this);
        this.maxPoolSize = n2;
        this.minPoolSize = n;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(n);
            this.poolSize.setUpperBound(n2);
        }
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.threadCreates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.threadDestroys = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 6: {
                this.declaredThreadHung = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 7: {
                this.declaredThreadHangCleared = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 3: {
                this.activeThreads = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 4: {
                this.poolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 5: {
                this.percentMaxed = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 8: {
                this.concurrentlyHungThreads = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 9: {
                this.activeTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void threadCreated(int n) {
        if (this.currentLevel <= 0) {
            if (this.poolSize != null) {
                this.poolSize.setLastValue(n);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("threadCreated, numThreadsInPool=" + n));
            }
            if (this.poolSize != null) {
                this.poolSize.add(n);
            }
            this.threadCreates.increment();
        }
    }

    public void threadDestroyed(int n) {
        if (this.currentLevel <= 0) {
            if (this.poolSize != null) {
                this.poolSize.setLastValue(n);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("threadDestroyed, numThreadsInPool=" + n));
            }
            this.threadDestroys.increment();
            if (this.poolSize != null) {
                this.poolSize.add(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStarted(int n, int n2) {
        if (this.currentLevel < 7) {
            if (this.activeThreads != null) {
                this.activeThreads.setLastValue(n);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("threadStarted, numActiveThreads=" + n + ", maxSize=" + n2));
            }
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.activeThreads.add(l, n);
                if (n >= n2) {
                    this.percentMaxed.add(l, 100L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadReturned(int n, int n2) {
        if (this.currentLevel < 7) {
            if (this.activeThreads != null) {
                this.activeThreads.setLastValue(n);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("threadReturned, numActiveThreads=" + n + ", maxSize=" + n2));
            }
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                long l = System.currentTimeMillis();
                this.activeThreads.add(l, n);
                if (n == n2 - 1) {
                    this.percentMaxed.add(l, 0L);
                }
            }
        }
    }

    public void threadCreated() {
        if (this.poolSize != null) {
            this.poolSize.increment();
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"threadCreated");
            }
            this.threadCreates.increment();
        }
    }

    public void threadDestroyed() {
        if (this.poolSize != null) {
            this.poolSize.decrement();
        }
        if (this.currentLevel > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"threadDestroyed");
            }
            this.threadDestroys.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStarted(int n) {
        if (this.currentLevel < 7) {
            if (this.activeThreads != null) {
                this.activeThreads.increment();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"threadStarted");
            }
            long l = 0L;
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                long l2 = System.currentTimeMillis();
                this.activeThreads.increment(l2, 1L);
                l = this.activeThreads.getCurrent();
                if (l >= (long)n) {
                    this.percentMaxed.add(l2, 100L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadReturned(int n) {
        if (this.currentLevel < 7) {
            if (this.activeThreads != null) {
                this.activeThreads.decrement();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"threadReturned");
            }
            long l = 0L;
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                long l2 = System.currentTimeMillis();
                this.activeThreads.decrement(l2, 1L);
                l = this.activeThreads.getCurrent();
                if (l == (long)(n - 1)) {
                    this.percentMaxed.add(l2, 0L);
                }
            }
        }
    }

    protected void callbackRuntime(int n) {
        Tr.debug((TraceComponent)tc, (String)"callbackRuntime");
        if (n < 7) {
            Tr.exit((TraceComponent)tc, (String)"callbackRuntime - level is not high enough");
            return;
        }
        if (this.callback == null) {
            Tr.exit((TraceComponent)tc, (String)"callbackRuntime - callback is null");
            return;
        }
        PmiAttribute[] pmiAttributeArray = this.callback.getPmiAttributes();
        for (int i = 0; i < pmiAttributeArray.length; ++i) {
            if (!pmiAttributeArray[i].getName().equals("NumThreadsInPool")) continue;
            long l = pmiAttributeArray[i].getValue();
            if (this.poolSize == null) continue;
            this.poolSize.add(l);
        }
        Tr.exit((TraceComponent)tc, (String)"callbackRuntime");
    }

    public void setConfigData(String string, long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConfigData, min=" + l + ", maxSize=" + l2));
        }
        if (string.equalsIgnoreCase("PoolSize")) {
            if (this.poolSize != null) {
                this.poolSize.setLowerBound(l);
                this.poolSize.setUpperBound(l2);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"setConfigData: wrong config data name");
        }
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initializeMe");
        }
        long l = 0L;
        if (this.poolSize != null) {
            l = this.poolSize.getCurrent();
        }
        if (l < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long l2 = 0L;
        if (this.activeThreads != null) {
            l2 = this.activeThreads.getCurrent();
        }
        if (l2 < 0L) {
            this.activeThreads.setLastValue(0L);
        }
        if (this.maxPoolSize > 0 && l2 >= (long)this.maxPoolSize && this.percentMaxed != null) {
            this.percentMaxed.add(100L);
        }
    }

    public void threadHangDetected() {
        if (this.currentLevel < 15) {
            return;
        }
        this.declaredThreadHung.increment();
        this.concurrentlyHungThreads.increment();
    }

    public void threadHangCleared(long l) {
        if (this.currentLevel < 15) {
            return;
        }
        this.declaredThreadHangCleared.increment();
        this.declaredThreadHung.decrement();
        this.concurrentlyHungThreads.decrement();
        this.activeTime.add(l);
    }

    public synchronized void setInstrumentationLevel(int n) {
        super.setInstrumentationLevel(n);
        if (n == 15 && !this.isThreadHangDetectionEnabled) {
            this.setStatisticEnabled(6, false);
            this.setStatisticEnabled(7, false);
            this.setStatisticEnabled(8, false);
            this.setStatisticEnabled(9, false);
        }
    }

    public void setThreadMonitorServiceEnabled(boolean bl) {
        if (this.isThreadHangDetectionEnabled != bl) {
            this.isThreadHangDetectionEnabled = bl;
            this.setStatisticEnabled(6, bl);
            this.setStatisticEnabled(7, bl);
            this.setStatisticEnabled(8, bl);
            this.setStatisticEnabled(9, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

