/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.JTAStatsImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.Transaction.JtsPerformanceMetrics;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import java.util.ArrayList;

public class TransactionModule
extends PmiAbstractModule {
    public static final String moduleID = "transactionModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl gTransBegun = null;
    private CountStatisticImpl gTransInvolved = null;
    private CountStatisticImpl lTransBegun = null;
    private CountStatisticImpl activeGTrans = null;
    private CountStatisticImpl activeLTrans = null;
    private TimeStatisticImpl gTranRt = null;
    private TimeStatisticImpl lTranRt = null;
    private TimeStatisticImpl gBeforeCompDuration = null;
    private TimeStatisticImpl gPrepareDuration = null;
    private TimeStatisticImpl gCommitDuration = null;
    private TimeStatisticImpl lBeforeCompDuration = null;
    private TimeStatisticImpl lCommitDuration = null;
    private CountStatisticImpl numOptim = null;
    private CountStatisticImpl gTransCommitted = null;
    private CountStatisticImpl lTransCommitted = null;
    private CountStatisticImpl gTransRollback = null;
    private CountStatisticImpl lTransRollback = null;
    private CountStatisticImpl gTransTimeout = null;
    private CountStatisticImpl lTransTimeout = null;
    private String containerName = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$TransactionModule == null ? (class$com$ibm$ws$pmi$server$modules$TransactionModule = TransactionModule.class$("com.ibm.ws.pmi.server.modules.TransactionModule")) : class$com$ibm$ws$pmi$server$modules$TransactionModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final int G_TRANS_BEGUN = 1;
    public static final int G_TRANS_INVOLVED = 2;
    public static final int L_TRANS_BEGUN = 3;
    public static final int ACTIVE_G_TRANS = 4;
    public static final int ACTIVE_L_TRANS = 5;
    public static final int G_TRAN_RT = 6;
    public static final int L_TRAN_RT = 7;
    public static final int G_BEFORE_COMPLETION = 8;
    public static final int G_PREPARE = 9;
    public static final int G_COMMIT = 10;
    public static final int L_BEFORE_COMPLETION = 11;
    public static final int L_COMMIT = 12;
    public static final int NUM_OPTIM = 13;
    public static final int G_TRANS_COMMITTED = 14;
    public static final int L_TRANS_COMMITTED = 15;
    public static final int G_TRANS_ROLL_BACK = 16;
    public static final int L_TRANS_ROLL_BACK = 17;
    public static final int G_TRANS_TIMEOUT = 18;
    public static final int L_TRANS_TIMEOUT = 19;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$TransactionModule;

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.gTransBegun = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.gTransInvolved = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.lTransBegun = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 13: {
                this.numOptim = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 14: {
                this.gTransCommitted = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 15: {
                this.lTransCommitted = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 16: {
                this.gTransRollback = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 17: {
                this.lTransRollback = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 18: {
                this.gTransTimeout = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 19: {
                this.lTransTimeout = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 4: {
                this.activeGTrans = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 5: {
                this.activeLTrans = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 6: {
                this.gTranRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 7: {
                this.lTranRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 8: {
                this.gBeforeCompDuration = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 9: {
                this.gPrepareDuration = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 10: {
                this.gCommitDuration = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 11: {
                this.lBeforeCompDuration = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 12: {
                this.lCommitDuration = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        return true;
    }

    public TransactionModule() {
        super(moduleID, "Jts");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new TransactionModule");
        }
        this.type = 13;
        this.registerModule(this);
    }

    public void init(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        WebSphereTransactionManager webSphereTransactionManager = (WebSphereTransactionManager)objectArray[0];
        if (webSphereTransactionManager != null) {
            GlobalTran globalTran = new GlobalTran();
            LocalTran localTran = new LocalTran();
            webSphereTransactionManager.registerPerformanceMetrics((JtsPerformanceMetrics)globalTran, (JtsPerformanceMetrics)localTran);
        }
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
        return new JTAStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class LocalTran
    implements JtsPerformanceMetrics {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long started() {
            if (TransactionModule.this.currentLevel <= 0) {
                return 0L;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"started local");
            }
            TransactionModule.this.lTransBegun.increment();
            CountStatisticImpl countStatisticImpl = TransactionModule.this.activeLTrans;
            synchronized (countStatisticImpl) {
                TransactionModule.this.activeLTrans.increment();
            }
            if (TransactionModule.this.lTranRt != null) {
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public void imported() {
            System.err.println("ERROR: local tran imported() should not be called");
        }

        public long commitRequested() {
            if (TransactionModule.this.currentLevel > 0 && TransactionModule.this.lBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"commitRequested local");
                }
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public long preparing(long l) {
            return 0L;
        }

        public long committing(long l) {
            long l2 = 0L;
            if (TransactionModule.this.currentLevel > 0 && TransactionModule.this.lBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"committing local");
                }
                l2 = System.currentTimeMillis();
                if (l > 0L) {
                    TransactionModule.this.lBeforeCompDuration.add(l2 - l);
                }
            }
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(long l, long l2, boolean bl) {
            if (TransactionModule.this.currentLevel <= 0) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"completed local");
            }
            if (TransactionModule.this.lCommitDuration != null || TransactionModule.this.lTranRt != null) {
                long l3 = System.currentTimeMillis();
                if (TransactionModule.this.lCommitDuration != null && l > 0L) {
                    TransactionModule.this.lCommitDuration.add(l3 - l);
                }
                if (l2 > 0L && TransactionModule.this.lTranRt != null) {
                    TransactionModule.this.lTranRt.add(l3 - l2);
                }
            }
            CountStatisticImpl countStatisticImpl = TransactionModule.this.activeLTrans;
            synchronized (countStatisticImpl) {
                TransactionModule.this.activeLTrans.decrement();
            }
            if (bl) {
                TransactionModule.this.lTransCommitted.increment();
            } else {
                TransactionModule.this.lTransRollback.increment();
            }
        }

        public void timeout() {
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"timeout local");
                }
                TransactionModule.this.lTransTimeout.increment();
            }
        }

        public void onePhase() {
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"onePhase local");
                }
                TransactionModule.this.numOptim.increment();
            }
        }
    }

    public class GlobalTran
    implements JtsPerformanceMetrics {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long started() {
            long l = 0L;
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"started");
                }
                TransactionModule.this.gTransBegun.increment();
                CountStatisticImpl countStatisticImpl = TransactionModule.this.activeGTrans;
                synchronized (countStatisticImpl) {
                    TransactionModule.this.activeGTrans.increment();
                }
                if (TransactionModule.this.gTranRt != null) {
                    l = System.currentTimeMillis();
                }
            }
            return l;
        }

        public void imported() {
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"imported");
                }
                TransactionModule.this.gTransInvolved.increment();
            }
        }

        public long commitRequested() {
            if (TransactionModule.this.currentLevel > 0 && TransactionModule.this.gBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"commitRequested");
                }
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public long preparing(long l) {
            long l2 = 0L;
            if (TransactionModule.this.currentLevel > 0 && TransactionModule.this.gBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"preparing");
                }
                l2 = System.currentTimeMillis();
                if (l > 0L) {
                    TransactionModule.this.gBeforeCompDuration.add(l2 - l);
                }
            }
            return l2;
        }

        public long committing(long l) {
            long l2 = 0L;
            if (TransactionModule.this.currentLevel > 0 && TransactionModule.this.gPrepareDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"committing");
                }
                l2 = System.currentTimeMillis();
                if (l > 0L) {
                    TransactionModule.this.gPrepareDuration.add(l2 - l);
                }
            }
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(long l, long l2, boolean bl) {
            if (TransactionModule.this.currentLevel <= 0) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"startCommitting");
            }
            if (TransactionModule.this.gCommitDuration != null || TransactionModule.this.gTranRt != null) {
                long l3 = System.currentTimeMillis();
                if (TransactionModule.this.gCommitDuration != null && l > 0L) {
                    TransactionModule.this.gCommitDuration.add(l3 - l);
                }
                if (l2 > 0L && TransactionModule.this.gTranRt != null) {
                    TransactionModule.this.gTranRt.add(l3 - l2);
                }
            }
            CountStatisticImpl countStatisticImpl = TransactionModule.this.activeGTrans;
            synchronized (countStatisticImpl) {
                TransactionModule.this.activeGTrans.decrement();
            }
            if (bl) {
                TransactionModule.this.gTransCommitted.increment();
            } else {
                TransactionModule.this.gTransRollback.increment();
            }
        }

        public void timeout() {
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"timeout");
                }
                TransactionModule.this.gTransTimeout.increment();
            }
        }

        public void onePhase() {
            if (TransactionModule.this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"onePhase");
                }
                TransactionModule.this.numOptim.increment();
            }
        }
    }
}

