/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import java.util.HashSet;
import java.util.Set;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class WLMModule
extends PmiAbstractModule
implements WLMPerf {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$WLMModule == null ? (class$com$ibm$ws$pmi$server$modules$WLMModule = WLMModule.class$("com.ibm.ws.pmi.server.modules.WLMModule")) : class$com$ibm$ws$pmi$server$modules$WLMModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "wlmModule";
    public static final int defaultLevel = 0;
    private int localConcurrentRequests = 0;
    private String moduleName = null;
    private Set clientSet = new HashSet();
    private static ThreadLocal serverStartTime = new ThreadLocal();
    private static ThreadLocal clientStartTime = new ThreadLocal();
    public static final int NUM_INCOMING_REQUESTS = 11;
    public static final int NUM_STRONG_AFFINITY_REQUESTS = 12;
    public static final int NUM_WEAK_AFFINITY_REQUESTS = 13;
    public static final int NUM_NON_AFFINITY_REQUESTS = 14;
    public static final int NUM_NON_WLM_OBJECT_REQUESTS = 15;
    public static final int NUM_SERVER_CLUSTER_UPDATES = 16;
    public static final int NUM_CLIENTS_SERVICED = 17;
    public static final int NUM_CONCURRENT_REQUESTS = 18;
    public static final int SERVER_RESPONSE_TIME = 19;
    public static final int NUM_OUTGOING_REQUESTS = 51;
    public static final int NUM_CLIENT_CLUSTER_UPDATES = 52;
    public static final int CLIENT_RESPONSE_TIME = 53;
    public static final byte STRONG_AFFINITY = 2;
    public static final byte WEAK_AFFINITY = 1;
    public static final byte NO_AFFINITY = 0;
    CountStatisticImpl numIncomingRequests = null;
    CountStatisticImpl numIncomingStrongAffinityRequests = null;
    CountStatisticImpl numIncomingWeakAffinityRequests = null;
    CountStatisticImpl numIncomingNonAffinityRequests = null;
    CountStatisticImpl numIncomingNonWLMObjectRequests = null;
    CountStatisticImpl numServerClusterUpdates = null;
    CountStatisticImpl numClientsServiced = null;
    RangeStatisticImpl numConcurrentRequests = null;
    TimeStatisticImpl serverResponseTime = null;
    CountStatisticImpl numOutgoingRequests = null;
    CountStatisticImpl numClientClusterUpdates = null;
    TimeStatisticImpl clientResponseTime = null;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$WLMModule;

    public WLMModule(String string) {
        super(moduleID, string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CTOR:submoduleName=" + string));
        }
        this.submoduleName = string;
        this.type = 15;
        this.registerModule(this);
    }

    public String[] getPath() {
        return new String[]{moduleID, this.submoduleName};
    }

    public void onIncomingWLMRequest(ServerRequestInfo serverRequestInfo, int n, int n2) {
        if (this.numConcurrentRequests != null) {
            this.numConcurrentRequests.increment();
        }
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onIncomingWLMRequest:currentLevel=" + this.currentLevel));
        }
        serverStartTime.set(new Long(System.currentTimeMillis()));
        this.numIncomingRequests.increment();
        if (n == -1) {
            this.numIncomingNonWLMObjectRequests.increment();
            this.numIncomingNonAffinityRequests.increment();
        } else {
            if (n2 == 2) {
                this.numIncomingStrongAffinityRequests.increment();
            } else if (n2 == 1) {
                this.numIncomingWeakAffinityRequests.increment();
            } else if (n2 == 0) {
                this.numIncomingNonAffinityRequests.increment();
            }
            Integer n3 = new Integer(n);
            if (!this.clientSet.contains(n3)) {
                this.clientSet.add(n3);
                this.numClientsServiced.setCount(this.clientSet.size());
            }
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onIncomingWLMRequest:method=" + serverRequestInfo.operation() + ":requestId=" + serverRequestInfo.request_id() + ":clientId=" + n + ":affinityType=" + n2 + ":concurrent=" + this.numConcurrentRequests.getCurrent() + ":numRequests=" + this.numIncomingRequests.getCount()));
        }
    }

    public void onOutgoingWLMReply(ServerRequestInfo serverRequestInfo) {
        Long l;
        if (this.numConcurrentRequests != null) {
            this.numConcurrentRequests.decrement();
        }
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onOutgoingWLMReply:currentLevel=" + this.currentLevel));
        }
        if (serverRequestInfo.reply_status() == 1) {
            return;
        }
        long l2 = 0L;
        if (this.serverResponseTime != null && (l = (Long)serverStartTime.get()) != null) {
            long l3 = l;
            l2 = System.currentTimeMillis() - l3;
            this.serverResponseTime.add(l2 * 1L);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onOutgoingWLMReply:method=" + serverRequestInfo.operation() + ":requestId=" + serverRequestInfo.request_id() + ":concurrent=" + this.numConcurrentRequests.getCurrent() + ":numServiced=" + this.clientSet.size() + ":responseTm=" + l2));
        }
    }

    public void onOutgoingWLMRequest(ClientRequestInfo clientRequestInfo) {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onOutgoingWLMRequest:currentLevel=" + this.currentLevel));
        }
        this.numOutgoingRequests.increment();
        clientStartTime.set(new Long(System.currentTimeMillis()));
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onOutgoingWLMRequest:method=" + clientRequestInfo.operation() + ":requestId=" + clientRequestInfo.request_id() + ":numRequests=" + this.numOutgoingRequests.getCount()));
        }
    }

    public void onIncomingWLMReply(ClientRequestInfo clientRequestInfo) {
        Long l;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onIncomingWLMReply:currentLevel=" + this.currentLevel));
        }
        long l2 = 0L;
        if (this.clientResponseTime != null && (l = (Long)clientStartTime.get()) != null) {
            long l3 = l;
            l2 = System.currentTimeMillis() - l3;
            this.clientResponseTime.add(l2);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onIncomingWLMReply:method=" + clientRequestInfo.operation() + ":requestId=" + clientRequestInfo.request_id() + ":responseTm=" + l2));
        }
    }

    public void onServerClusterUpdate() {
        if (this.currentLevel <= 0) {
            return;
        }
        this.numServerClusterUpdates.increment();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onServerClusterUpdate:numServerClusterUpdates=" + this.numServerClusterUpdates.getCount()));
        }
    }

    public void onClientClusterUpdate() {
        if (this.currentLevel <= 0) {
            return;
        }
        this.numClientClusterUpdates.increment();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("onClientClusterUpdate:numClientClusterUpdates=" + this.numClientClusterUpdates.getCount()));
        }
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 11: {
                this.numIncomingRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 12: {
                this.numIncomingStrongAffinityRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 13: {
                this.numIncomingWeakAffinityRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 14: {
                this.numIncomingNonAffinityRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 15: {
                this.numIncomingNonWLMObjectRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 16: {
                this.numServerClusterUpdates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 17: {
                this.numClientsServiced = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 51: {
                this.numOutgoingRequests = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 52: {
                this.numClientClusterUpdates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 18: {
                this.numConcurrentRequests = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 19: {
                this.serverResponseTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 53: {
                this.clientResponseTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        if (this.numConcurrentRequests != null) {
            l = this.numConcurrentRequests.getCurrent();
        }
        if (l < 0L) {
            this.numConcurrentRequests.setLastValue(0L);
        }
        this.clientSet.clear();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("initializeMe:concurrentRequests=" + this.numConcurrentRequests.getCurrent()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

