/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebAppPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.ServletStatsImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.ArrayList;
import java.util.Hashtable;

public class WebAppModule
extends PmiAbstractModule
implements WebAppPerf {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$WebAppModule == null ? (class$com$ibm$ws$pmi$server$modules$WebAppModule = WebAppModule.class$("com.ibm.ws.pmi.server.modules.WebAppModule")) : class$com$ibm$ws$pmi$server$modules$WebAppModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "webAppModule";
    public static final int defaultLevel = 0;
    private CountStatisticImpl sgLoadedServlets = null;
    private CountStatisticImpl sgNumReloads = null;
    private Hashtable servletData = null;
    private int hashtableMaxSize = 256;
    private String appName = null;
    private String appPmiName = null;
    public static final int LOADED_SERVLETS = 1;
    public static final int NUM_RELOADS = 2;
    public static final int SERVLETS = 10;
    public static final int TOTAL_REQUESTS = 11;
    public static final int CONCURRENT_REQUESTS = 12;
    public static final int RESPONSE_TIME = 13;
    public static final int NUM_ERRORS = 14;
    public static final int LOADED_SINCE = 15;
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$WebAppModule;

    public WebAppModule(String string) {
        super(moduleID, string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new WebAppModule, webapp=" + string));
        }
        this.appName = string;
        this.appPmiName = string;
        this.servletData = new Hashtable();
        this.registerModule(this);
        new ModuleAggregate(moduleID, this.appPmiName, "webAppModule.servlets");
    }

    public void onApplicationAvailableForService() {
    }

    public void onApplicationUnavailableForService() {
    }

    public void onApplicationStart() {
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onApplicationStart()");
        }
        this.sgNumReloads.increment();
    }

    public void onApplicationEnd() {
    }

    public void onServletStartService(String string) {
        ServletPmiModule servletPmiModule;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onServletStartService()");
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) == null) {
            servletPmiModule = this.RecoverFromServletNotFound(string);
        }
        servletPmiModule.incRequests();
    }

    public void onServletFinishService(String string, long l) {
        ServletPmiModule servletPmiModule;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onServletFinishService()");
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) == null) {
            servletPmiModule = this.RecoverFromServletNotFound(string);
        }
        servletPmiModule.decRequests(l);
    }

    public void onServletStartInit(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onServletStartInit(): " + string2));
        }
        ServletPmiModule servletPmiModule = new ServletPmiModule(this.appPmiName, string2);
        this.servletData.put(string2, servletPmiModule);
        if (this.currentLevel <= 0) {
            return;
        }
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment();
        }
    }

    public void onServletFinishInit(String string) {
    }

    public void onServletStartDestroy(String string) {
    }

    public void onServletFinishDestroy(String string) {
    }

    public void onServletUnloaded(String string) {
        ServletPmiModule servletPmiModule;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onServletUnloaded()");
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) == null) {
            servletPmiModule = this.RecoverFromServletNotFound(string);
        }
        servletPmiModule.destroy();
        this.servletData.remove(string);
        this.sgLoadedServlets.increment(-1L);
    }

    public void onServletAvailableForService(String string) {
    }

    public void onServletUnavailableForService(String string) {
    }

    public void onServletInitError(String string) {
    }

    public void onServletServiceError(String string) {
        ServletPmiModule servletPmiModule;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onServletServiceError(), servletName=" + string));
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) == null) {
            servletPmiModule = this.RecoverFromServletNotFound(string);
        }
        servletPmiModule.incNumErrors();
    }

    public void onServletServiceDenied(String string) {
    }

    public void onServletDestroyError(String string) {
    }

    public ServletPmiModule RecoverFromServletNotFound(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoverFromServletNotFound()");
        }
        ServletPmiModule servletPmiModule = new ServletPmiModule(this.appPmiName, string);
        this.servletData.put(string, servletPmiModule);
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment();
        }
        return servletPmiModule;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.sgLoadedServlets = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.sgNumReloads = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ServletPmiModule
    extends PmiAbstractModule {
        CountStatisticImpl numErrors = null;
        CountStatisticImpl totalRequests = null;
        RangeStatisticImpl currentRequests = null;
        TimeStatisticImpl responseTime = null;

        public ServletPmiModule(String string, String string2) {
            super(WebAppModule.moduleID, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new ServletPmiModule, servlet=" + string2));
            }
            this.submoduleName = "webAppModule.servlets";
            this.subinstanceName = string2;
            this.type = 16;
            this.registerModule(this);
        }

        public void decRequests(long l) {
            if (this.currentRequests != null) {
                this.currentRequests.decrement();
            }
            if (this.currentLevel > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decRequests, execTime=" + l));
                }
                if (this.responseTime != null && l >= 0L) {
                    this.responseTime.add(l * 1L);
                }
            }
        }

        public void incRequests() {
            if (this.currentRequests != null) {
                this.currentRequests.increment();
            }
            if (this.currentLevel > 0) {
                this.totalRequests.increment();
            }
        }

        public void destroy() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"destroy()");
            }
            this.currentLevel = 0;
            PmiRegistry.unregisterModule(this);
        }

        public void incNumErrors() {
            if (this.currentLevel > 0) {
                this.numErrors.increment();
            }
        }

        protected boolean longCreated(SpdLong spdLong) {
            switch (spdLong.getId()) {
                case 11: {
                    this.totalRequests = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
                case 14: {
                    this.numErrors = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat spdStat) {
            switch (spdStat.getId()) {
                case 13: {
                    this.responseTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean loadCreated(SpdLoad spdLoad) {
            switch (spdLoad.getId()) {
                case 12: {
                    this.currentRequests = (RangeStatisticImpl)spdLoad.getStatistic();
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return WebAppModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }

        public Stats getStats(ArrayList arrayList, ArrayList arrayList2) {
            return new ServletStatsImpl(this.name, this.type, this.currentLevel, arrayList, arrayList2);
        }
    }
}

