/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import java.util.Hashtable;

public class WebServicesModule
extends PmiAbstractModule
implements WebServicesPerf {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$pmi$server$modules$WebServicesModule == null ? (class$com$ibm$ws$pmi$server$modules$WebServicesModule = WebServicesModule.class$("com.ibm.ws.pmi.server.modules.WebServicesModule")) : class$com$ibm$ws$pmi$server$modules$WebServicesModule), null, (String)"com.ibm.websphere.pmi.property.pmi");
    public static final String moduleID = "webServicesModule";
    public static final int defaultLevel = 0;
    private CountStatisticImpl numLoadedServices = null;
    public static final int PMI_ID_NUMBER_LOADED_SERVICES = 1;
    public static final int PMI_LEVEL_NUMBER_LOADED_SERVICES = 1;
    private Hashtable serviceData = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ws$pmi$server$modules$WebServicesModule;

    public static final String buildInstanceName(String string, String string2) {
        return string + "." + string2;
    }

    public WebServicesModule(String string, String string2) {
        this(WebServicesModule.buildInstanceName(string, string2));
    }

    public WebServicesModule(String string) {
        super(moduleID, string);
        this.registerModule(this);
        new ModuleAggregate(moduleID, string, "webServicesModule.services");
    }

    public void onServiceLoad(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("onServiceLoad(" + string + ")"));
        }
        new ServicePMIModule(this.instanceName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onServiceLoad()");
        }
    }

    public void onServiceUnload(String string) {
        ServicePMIModule servicePMIModule;
        if (this.currentLevel <= 0) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("onServiceUnload(" + string + ")"));
        }
        if ((servicePMIModule = (ServicePMIModule)this.serviceData.get(string)) != null) {
            servicePMIModule.destroy();
        } else {
            Tr.warning((TraceComponent)tc, (String)(string + " not found"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onServiceUnload()");
        }
    }

    public WebServicesPerf.ServicePerf getService(String string) {
        ServicePMIModule servicePMIModule;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getService(" + string + ")"));
        }
        if ((servicePMIModule = (ServicePMIModule)this.serviceData.get(string)) == null) {
            Tr.warning((TraceComponent)tc, (String)("onServiceLoad(" + string + ") should have been called already!"));
            servicePMIModule = new ServicePMIModule(this.instanceName, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getService()");
        }
        return servicePMIModule;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.numLoadedServices = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private final void loadService(String string, ServicePMIModule servicePMIModule) {
        this.serviceData.put(string, servicePMIModule);
        if (this.currentLevel > 0 && this.numLoadedServices != null) {
            this.numLoadedServices.increment();
        }
    }

    private final void unloadService(String string) {
        this.serviceData.remove(string);
        if (this.currentLevel > 0 && this.numLoadedServices != null) {
            this.numLoadedServices.increment(-1L);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ServicePMIModule
    extends PmiAbstractModule
    implements WebServicesPerf.ServicePerf {
        CountStatisticImpl numberReceived = null;
        CountStatisticImpl numberDispatched = null;
        CountStatisticImpl numberSuccessfull = null;
        TimeStatisticImpl responseTime = null;
        TimeStatisticImpl requestResponseTime = null;
        TimeStatisticImpl dispatchResponseTime = null;
        TimeStatisticImpl replyResponseTime = null;
        TimeStatisticImpl size = null;
        TimeStatisticImpl requestSize = null;
        TimeStatisticImpl replySize = null;
        public static final int PMI_ID_SERVICES = 10;
        public static final int PMI_ID_NUMBER_RECEIVED = 11;
        public static final int PMI_ID_NUMBER_DISPATCHED = 12;
        public static final int PMI_ID_NUMBER_SUCCESSFULL = 13;
        public static final int PMI_ID_AVERAGE_RESPONSE_TIME = 14;
        public static final int PMI_ID_AVERAGE_REQUEST_RESPONSE_TIME = 15;
        public static final int PMI_ID_AVERAGE_DISPATCH_RESPONSE_TIME = 16;
        public static final int PMI_ID_AVERAGE_REPLY_RESPONSE_TIME = 17;
        public static final int PMI_ID_AVERAGE_SIZE = 18;
        public static final int PMI_ID_AVERAGE_REQUEST_SIZE = 19;
        public static final int PMI_ID_AVERAGE_REPLY_SIZE = 20;

        public ServicePMIModule(String string, String string2) {
            super(WebServicesModule.moduleID, string);
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("ServicePMIModule(" + string + "," + string2 + ")"));
            }
            this.submoduleName = "webServicesModule.services";
            this.subinstanceName = string2;
            this.type = 16;
            this.registerModule(this);
            WebServicesModule.this.loadService(this.subinstanceName, this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ServicePMIModule()");
            }
        }

        public void destroy() {
            this.currentLevel = 0;
            Tr.entry((TraceComponent)tc, (String)"destroy()");
            this.numberReceived = null;
            this.numberDispatched = null;
            this.numberSuccessfull = null;
            this.responseTime = null;
            this.requestResponseTime = null;
            this.dispatchResponseTime = null;
            this.replyResponseTime = null;
            this.size = null;
            this.requestSize = null;
            this.replySize = null;
            WebServicesModule.this.unloadService(this.subinstanceName);
            this.unregisterModule(this);
            Tr.exit((TraceComponent)tc, (String)"destroy()");
        }

        public void onServiceReceiveRequest(long l) {
            if (this.getPMILevel() >= 1) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceReceiveRequest()"));
                }
                this.incrementReceived();
                if (this.getPMILevel() >= 7) {
                    this.addPayloadSize(l);
                    this.addRequestPayloadSize(l);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceReceiveRequest()"));
                }
            }
        }

        public void onServiceSendRequest(long l) {
            if (this.getPMILevel() >= 1) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceSendRequest()"));
                }
                this.incrementDispatched();
                if (this.getPMILevel() >= 3) {
                    this.addRequestResponseTime(l);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceSendRequest()"));
                }
            }
        }

        public void onServiceReceiveReply(long l, long l2) {
            if (this.getPMILevel() >= 1) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceReceiveReply()"));
                }
                if (this.getPMILevel() >= 3) {
                    this.addDispatchResponseTime(l2);
                }
                if (this.getPMILevel() >= 7) {
                    this.addPayloadSize(l);
                    this.addReplyPayloadSize(l);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceReceiveReply()"));
                }
            }
        }

        public void onServiceSendReply(long l, long l2) {
            if (this.getPMILevel() >= 1) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceSendReply()"));
                }
                this.incrementSuccessfull();
                if (this.getPMILevel() >= 3) {
                    this.addReplyResponseTime(l);
                    this.addResponseTime(l2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(this.subinstanceName + ".onServiceSendReply()"));
                }
            }
        }

        public int getPMILevel() {
            return this.currentLevel;
        }

        private final void increment(String string, CountStatisticImpl countStatisticImpl) {
            if (countStatisticImpl != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("increment(" + string + ")"));
                }
                countStatisticImpl.increment();
                Tr.exit((TraceComponent)tc, (String)"increment()");
            }
        }

        private final void add(String string, TimeStatisticImpl timeStatisticImpl, long l) {
            if (timeStatisticImpl != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("add(" + string + ", time=" + l + ")"));
                }
                timeStatisticImpl.add(l * 1L);
                Tr.exit((TraceComponent)tc, (String)"add()");
            }
        }

        private void incrementReceived() {
            this.increment("numberReceived", this.numberReceived);
        }

        private void incrementDispatched() {
            this.increment("numberDispatched", this.numberDispatched);
        }

        private void incrementSuccessfull() {
            this.increment("numberSuccessfull", this.numberSuccessfull);
        }

        private void addResponseTime(long l) {
            this.add("responseTime", this.responseTime, l);
        }

        private void addRequestResponseTime(long l) {
            this.add("requestResponseTime", this.requestResponseTime, l);
        }

        private void addDispatchResponseTime(long l) {
            this.add("dispatchResponseTime", this.dispatchResponseTime, l);
        }

        private void addReplyResponseTime(long l) {
            this.add("replyResponseTime", this.replyResponseTime, l);
        }

        private void addPayloadSize(long l) {
            this.add("payloadSize", this.size, l);
        }

        private void addRequestPayloadSize(long l) {
            this.add("requestPayloadSize", this.requestSize, l);
        }

        private void addReplyPayloadSize(long l) {
            this.add("replyPayloadSize", this.replySize, l);
        }

        protected boolean longCreated(SpdLong spdLong) {
            switch (spdLong.getId()) {
                case 11: {
                    this.numberReceived = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
                case 12: {
                    this.numberDispatched = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
                case 13: {
                    this.numberSuccessfull = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat spdStat) {
            switch (spdStat.getId()) {
                case 14: {
                    this.responseTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 16: {
                    this.dispatchResponseTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 15: {
                    this.requestResponseTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 17: {
                    this.replyResponseTime = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 18: {
                    this.size = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 19: {
                    this.requestSize = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
                case 20: {
                    this.replySize = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return WebServicesModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

