/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;

public class NotificationImpl
implements Notification,
NotificationChain {
    public static final int PRIMITIVE_TYPE_OBJECT = -1;
    public static final int PRIMITIVE_TYPE_BOOLEAN = 0;
    public static final int PRIMITIVE_TYPE_BYTE = 1;
    public static final int PRIMITIVE_TYPE_CHAR = 2;
    public static final int PRIMITIVE_TYPE_DOUBLE = 3;
    public static final int PRIMITIVE_TYPE_FLOAT = 4;
    public static final int PRIMITIVE_TYPE_INT = 5;
    public static final int PRIMITIVE_TYPE_LONG = 6;
    public static final int PRIMITIVE_TYPE_SHORT = 7;
    protected static final int IS_SET_CHANGE_INDEX = -2;
    protected int primitiveType;
    protected int eventType;
    protected Object oldValue;
    protected Object newValue;
    protected long oldSimplePrimitiveValue;
    protected long newSimplePrimitiveValue;
    protected double oldIEEEPrimitiveValue;
    protected double newIEEEPrimitiveValue;
    protected int position;
    protected NotificationChain next;

    public NotificationImpl(int n, Object object, Object object2) {
        this(n, object, object2, -1);
    }

    public NotificationImpl(int n, Object object, Object object2, boolean bl) {
        this(n, object, object2, bl ? -2 : -1);
    }

    public NotificationImpl(int n, Object object, Object object2, int n2) {
        this.eventType = n;
        this.oldValue = object;
        this.newValue = object2;
        this.position = n2;
        this.primitiveType = -1;
    }

    public NotificationImpl(int n, boolean bl, boolean bl2, boolean bl3) {
        this(n, bl, bl2);
        if (bl3) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, boolean bl, boolean bl2) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = bl ? 1L : 0L;
        this.newSimplePrimitiveValue = bl2 ? 1L : 0L;
        this.position = -1;
        this.primitiveType = 0;
    }

    public NotificationImpl(int n, byte by, byte by2, boolean bl) {
        this(n, by, by2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, byte by, byte by2) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = by;
        this.newSimplePrimitiveValue = by2;
        this.position = -1;
        this.primitiveType = 1;
    }

    public NotificationImpl(int n, char c, char c2, boolean bl) {
        this(n, c, c2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, char c, char c2) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = c;
        this.newSimplePrimitiveValue = c2;
        this.position = -1;
        this.primitiveType = 2;
    }

    public NotificationImpl(int n, double d, double d2, boolean bl) {
        this(n, d, d2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, double d, double d2) {
        this.eventType = n;
        this.oldIEEEPrimitiveValue = d;
        this.newIEEEPrimitiveValue = d2;
        this.position = -1;
        this.primitiveType = 3;
    }

    public NotificationImpl(int n, float f, float f2, boolean bl) {
        this(n, f, f2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, float f, float f2) {
        this.eventType = n;
        this.oldIEEEPrimitiveValue = f;
        this.newIEEEPrimitiveValue = f2;
        this.position = -1;
        this.primitiveType = 4;
    }

    public NotificationImpl(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, int n2, int n3) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = n2;
        this.newSimplePrimitiveValue = n3;
        this.position = -1;
        this.primitiveType = 5;
    }

    public NotificationImpl(int n, long l, long l2, boolean bl) {
        this(n, l, l2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, long l, long l2) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = l;
        this.newSimplePrimitiveValue = l2;
        this.position = -1;
        this.primitiveType = 6;
    }

    public NotificationImpl(int n, short s, short s2, boolean bl) {
        this(n, s, s2);
        if (bl) {
            this.position = -2;
        }
    }

    public NotificationImpl(int n, short s, short s2) {
        this.eventType = n;
        this.oldSimplePrimitiveValue = s;
        this.newSimplePrimitiveValue = s2;
        this.position = -1;
        this.primitiveType = 7;
    }

    public Object getNotifier() {
        return null;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Object getFeature() {
        return null;
    }

    public int getFeatureID(Class clazz) {
        return -1;
    }

    public Object getOldValue() {
        if (this.oldValue == null) {
            switch (this.primitiveType) {
                case 0: {
                    this.oldValue = new Boolean(this.getOldBooleanValue());
                    break;
                }
                case 1: {
                    this.oldValue = new Byte(this.getOldByteValue());
                    break;
                }
                case 2: {
                    this.oldValue = new Character(this.getOldCharValue());
                    break;
                }
                case 3: {
                    this.oldValue = new Double(this.getOldDoubleValue());
                    break;
                }
                case 4: {
                    this.oldValue = new Float(this.getOldFloatValue());
                    break;
                }
                case 6: {
                    this.oldValue = new Long(this.getOldLongValue());
                    break;
                }
                case 5: {
                    this.oldValue = new Integer(this.getOldIntValue());
                    break;
                }
                case 7: {
                    this.oldValue = new Short(this.getOldShortValue());
                }
            }
        }
        return this.oldValue;
    }

    public Object getNewValue() {
        if (this.newValue == null) {
            switch (this.primitiveType) {
                case 0: {
                    this.newValue = new Boolean(this.getNewBooleanValue());
                    break;
                }
                case 1: {
                    this.newValue = new Byte(this.getNewByteValue());
                    break;
                }
                case 2: {
                    this.newValue = new Character(this.getNewCharValue());
                    break;
                }
                case 3: {
                    this.newValue = new Double(this.getNewDoubleValue());
                    break;
                }
                case 4: {
                    this.newValue = new Float(this.getNewFloatValue());
                    break;
                }
                case 6: {
                    this.newValue = new Long(this.getNewLongValue());
                    break;
                }
                case 5: {
                    this.newValue = new Integer(this.getNewIntValue());
                    break;
                }
                case 7: {
                    this.newValue = new Short(this.getNewShortValue());
                }
            }
        }
        return this.newValue;
    }

    public boolean isTouch() {
        switch (this.eventType) {
            case 8: 
            case 9: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
            case 1: 
            case 2: {
                if (this.position == -2) {
                    return false;
                }
                switch (this.primitiveType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return this.oldSimplePrimitiveValue == this.newSimplePrimitiveValue;
                    }
                    case 3: 
                    case 4: {
                        return this.oldIEEEPrimitiveValue == this.newIEEEPrimitiveValue;
                    }
                }
                return this.oldValue == null ? this.newValue == null : this.oldValue.equals(this.newValue);
            }
        }
        return false;
    }

    public boolean isReset() {
        switch (this.eventType) {
            case 1: {
                Object object = this.getFeatureDefaultValue();
                switch (this.primitiveType) {
                    case 0: {
                        return object != null && (Boolean)object == (this.newSimplePrimitiveValue != 0L);
                    }
                    case 1: {
                        return object != null && (Byte)object == (byte)this.newSimplePrimitiveValue;
                    }
                    case 2: {
                        return object != null && ((Character)object).charValue() == (char)this.newSimplePrimitiveValue;
                    }
                    case 6: {
                        return object != null && (Long)object == this.newSimplePrimitiveValue;
                    }
                    case 5: {
                        return object != null && (Integer)object == (int)this.newSimplePrimitiveValue;
                    }
                    case 7: {
                        return object != null && (Short)object == (short)this.newSimplePrimitiveValue;
                    }
                    case 3: {
                        return object != null && (Double)object == this.newIEEEPrimitiveValue;
                    }
                    case 4: {
                        return object != null && ((Float)object).floatValue() == (float)this.newIEEEPrimitiveValue;
                    }
                }
                return object == null ? this.newValue == null : object.equals(this.newValue);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected Object getFeatureDefaultValue() {
        return null;
    }

    public int getPosition() {
        return this.position < 0 ? -1 : this.position;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean merge(Notification notification) {
        switch (this.eventType) {
            case 1: 
            case 2: {
                int n = notification.getEventType();
                switch (n) {
                    case 1: 
                    case 2: {
                        Object object = notification.getNotifier();
                        if (object != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                        this.newValue = notification.getNewValue();
                        if (notification.getEventType() != 1) return true;
                        this.eventType = 1;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean getOldBooleanValue() {
        if (this.primitiveType != 0) {
            throw new IllegalStateException();
        }
        return this.oldSimplePrimitiveValue != 0L;
    }

    public boolean getNewBooleanValue() {
        if (this.primitiveType != 0) {
            throw new IllegalStateException();
        }
        return this.newSimplePrimitiveValue != 0L;
    }

    public byte getOldByteValue() {
        if (this.primitiveType != 1) {
            throw new IllegalStateException();
        }
        return (byte)this.oldSimplePrimitiveValue;
    }

    public byte getNewByteValue() {
        if (this.primitiveType != 1) {
            throw new IllegalStateException();
        }
        return (byte)this.newSimplePrimitiveValue;
    }

    public char getOldCharValue() {
        if (this.primitiveType != 2) {
            throw new IllegalStateException();
        }
        return (char)this.oldSimplePrimitiveValue;
    }

    public char getNewCharValue() {
        if (this.primitiveType != 2) {
            throw new IllegalStateException();
        }
        return (char)this.newSimplePrimitiveValue;
    }

    public double getOldDoubleValue() {
        if (this.primitiveType != 3) {
            throw new IllegalStateException();
        }
        return this.oldIEEEPrimitiveValue;
    }

    public double getNewDoubleValue() {
        if (this.primitiveType != 3) {
            throw new IllegalStateException();
        }
        return this.newIEEEPrimitiveValue;
    }

    public float getOldFloatValue() {
        if (this.primitiveType != 4) {
            throw new IllegalStateException();
        }
        return (float)this.oldIEEEPrimitiveValue;
    }

    public float getNewFloatValue() {
        if (this.primitiveType != 4) {
            throw new IllegalStateException();
        }
        return (float)this.newIEEEPrimitiveValue;
    }

    public int getOldIntValue() {
        if (this.primitiveType != 5) {
            throw new IllegalStateException();
        }
        return (int)this.oldSimplePrimitiveValue;
    }

    public int getNewIntValue() {
        if (this.primitiveType != 5) {
            throw new IllegalStateException();
        }
        return (int)this.newSimplePrimitiveValue;
    }

    public long getOldLongValue() {
        if (this.primitiveType != 6) {
            throw new IllegalStateException();
        }
        return this.oldSimplePrimitiveValue;
    }

    public long getNewLongValue() {
        if (this.primitiveType != 6) {
            throw new IllegalStateException();
        }
        return this.newSimplePrimitiveValue;
    }

    public short getOldShortValue() {
        if (this.primitiveType != 7) {
            throw new IllegalStateException();
        }
        return (short)this.oldSimplePrimitiveValue;
    }

    public short getNewShortValue() {
        if (this.primitiveType != 7) {
            throw new IllegalStateException();
        }
        return (short)this.newSimplePrimitiveValue;
    }

    public String getOldStringValue() {
        return this.oldValue == null ? null : this.oldValue.toString();
    }

    public String getNewStringValue() {
        return this.newValue == null ? null : this.newValue.toString();
    }

    public boolean add(Notification notification) {
        if (notification == null) {
            return false;
        }
        if (this.merge(notification)) {
            return false;
        }
        if (this.next == null) {
            try {
                this.next = (NotificationChain)((Object)notification);
                return true;
            }
            catch (ClassCastException classCastException) {
                this.next = new NotificationChainImpl();
                return this.next.add(notification);
            }
        }
        return this.next.add(notification);
    }

    public void dispatch() {
        Object object = this.getNotifier();
        if (object != null && this.getEventType() != -1) {
            ((Notifier)object).eNotify(this);
        }
        if (this.next != null) {
            this.next.dispatch();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (eventType: ");
        switch (this.eventType) {
            case 1: {
                stringBuffer.append("SET");
                break;
            }
            case 2: {
                stringBuffer.append("UNSET");
                break;
            }
            case 3: {
                stringBuffer.append("ADD");
                break;
            }
            case 5: {
                stringBuffer.append("ADD_MANY");
                break;
            }
            case 4: {
                stringBuffer.append("REMOVE");
                break;
            }
            case 6: {
                stringBuffer.append("REMOVE_MANY");
                break;
            }
            case 7: {
                stringBuffer.append("MOVE");
                break;
            }
            case 8: {
                stringBuffer.append("REMOVING_ADPATER");
                break;
            }
            case 9: {
                stringBuffer.append("RESOLVE");
                break;
            }
            default: {
                stringBuffer.append(this.eventType);
            }
        }
        if (this.isTouch()) {
            stringBuffer.append(", touch: true");
        }
        stringBuffer.append(", position: ");
        stringBuffer.append(this.getPosition());
        stringBuffer.append(", notifier: ");
        stringBuffer.append(this.getNotifier());
        stringBuffer.append(", feature: ");
        stringBuffer.append(this.getFeature());
        stringBuffer.append(", oldValue: ");
        stringBuffer.append(this.getOldValue());
        stringBuffer.append(", newValue: ");
        if (this.eventType == 6 && this.newValue instanceof int[]) {
            int[] nArray = (int[])this.newValue;
            stringBuffer.append("[");
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append(nArray[n]);
                if (++n >= nArray.length) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(this.getNewValue());
        }
        return stringBuffer.toString();
    }
}

