/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class BasicEList
extends AbstractList
implements EList,
Cloneable,
Serializable {
    protected int size;
    protected transient Object[] data;

    public BasicEList() {
    }

    public BasicEList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.data = this.newData(n);
    }

    public BasicEList(Collection collection) {
        this.size = collection.size();
        if (this.size > 0) {
            this.data = this.newData(this.size + this.size / 8 + 1);
            collection.toArray(this.data);
        }
    }

    protected BasicEList(int n, Object[] objectArray) {
        this.size = n;
        this.data = objectArray;
    }

    protected Object[] newData(int n) {
        return new Object[n];
    }

    protected boolean useEquals() {
        return true;
    }

    protected boolean equalObjects(Object object, Object object2) {
        return this.useEquals() && object != null ? object.equals(object2) : object == object2;
    }

    protected boolean canContainNull() {
        return true;
    }

    protected boolean isUnique() {
        return false;
    }

    protected Object validate(int n, Object object) {
        if (!this.canContainNull() && object == null) {
            throw new IllegalArgumentException("The 'no null' constraint is violated");
        }
        return object;
    }

    protected Object assign(int n, Object object) {
        this.data[n] = object;
        return this.data[n];
    }

    protected Object resolve(int n, Object object) {
        return object;
    }

    protected void didSet(int n, Object object, Object object2) {
    }

    protected void didAdd(int n, Object object) {
    }

    protected void didRemove(int n, Object object) {
    }

    protected void didClear(int n, Object[] objectArray) {
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < n) {
                this.didRemove(n2, objectArray[n2]);
                ++n2;
            }
        }
    }

    protected void didMove(int n, Object object, int n2) {
    }

    protected void didChange() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        if (this.useEquals() && object != null) {
            int n = 0;
            while (n < this.size) {
                if (object.equals(this.data[n])) {
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.size) {
                if (this.data[n] == object) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        if (this.useEquals() && object != null) {
            int n = 0;
            while (n < this.size) {
                if (object.equals(this.data[n])) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.size) {
                if (this.data[n] == object) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (this.useEquals() && object != null) {
            int n = this.size - 1;
            while (n >= 0) {
                if (object.equals(this.data[n])) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.size - 1;
            while (n >= 0) {
                if (this.data[n] == object) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] objectArray = this.newData(this.size);
        if (this.size > 0) {
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.size > 0) {
            if (objectArray.length < this.size) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
            }
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public Object[] data() {
        return this.data;
    }

    public void setData(int n, Object[] objectArray) {
        this.size = n;
        this.data = objectArray;
        ++this.modCount;
    }

    public Object get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        return this.resolve(n, this.data[n]);
    }

    public Object basicGet(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        return this.data[n];
    }

    public Object set(int n, Object object) {
        int n2;
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        if (this.isUnique() && (n2 = this.indexOf(object)) >= 0 && n2 != n) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        return this.setUnique(n, object);
    }

    public Object setUnique(int n, Object object) {
        Object object2 = this.data[n];
        this.assign(n, this.validate(n, object));
        this.didSet(n, object, object2);
        this.didChange();
        return object2;
    }

    public boolean add(Object object) {
        if (this.isUnique() && this.contains(object)) {
            return false;
        }
        this.addUnique(object);
        return true;
    }

    public void addUnique(Object object) {
        this.grow(this.size + 1);
        this.assign(this.size, this.validate(this.size, object));
        this.didAdd(this.size++, object);
        this.didChange();
    }

    public void add(int n, Object object) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        if (this.isUnique() && this.contains(object)) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        this.addUnique(n, object);
    }

    public void addUnique(int n, Object object) {
        this.grow(this.size + 1);
        if (n != this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.assign(n, this.validate(n, object));
        ++this.size;
        this.didAdd(n, object);
        this.didChange();
    }

    public boolean addAll(Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(collection);
    }

    public boolean addAllUnique(Collection collection) {
        int n = collection.size();
        this.grow(this.size + n);
        Iterator iterator = collection.iterator();
        int n2 = this.size;
        this.size += n;
        int n3 = n2;
        while (n3 < this.size) {
            Object e = iterator.next();
            this.assign(n3, this.validate(n3, e));
            this.didAdd(n3, e);
            this.didChange();
            ++n3;
        }
        return n != 0;
    }

    public boolean addAll(int n, Collection collection) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(n, collection);
    }

    public boolean addAllUnique(int n, Collection collection) {
        int n2 = collection.size();
        this.grow(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.data, n, this.data, n + n2, n3);
        }
        Iterator iterator = collection.iterator();
        int n4 = this.size;
        this.size += n2;
        int n5 = 0;
        while (n5 < n2) {
            Object e = iterator.next();
            this.assign(n, this.validate(n, e));
            this.didAdd(n, e);
            this.didChange();
            ++n;
            ++n5;
        }
        return n2 != 0;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = this.size;
        while (--n >= 0) {
            if (!collection.contains(this.data[n])) continue;
            this.remove(n);
            bl = true;
        }
        return bl;
    }

    public Object remove(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        ++this.modCount;
        Object object = this.data[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n2);
        }
        this.data[--this.size] = null;
        this.didRemove(n, object);
        this.didChange();
        return object;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this.size;
        while (--n >= 0) {
            if (collection.contains(this.data[n])) continue;
            this.remove(n);
            bl = true;
        }
        return bl;
    }

    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.data;
        int n = this.size;
        this.data = null;
        this.size = 0;
        this.didClear(n, objectArray);
        this.didChange();
    }

    public void move(int n, Object object) {
        this.move(n, this.indexOf(object));
    }

    public Object move(int n, int n2) {
        ++this.modCount;
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + n + ", size=" + this.size);
        }
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + n2 + ", size=" + this.size);
        }
        Object object = this.data[n2];
        if (n != n2) {
            if (n < n2) {
                System.arraycopy(this.data, n, this.data, n + 1, n2 - n);
            } else {
                System.arraycopy(this.data, n2 + 1, this.data, n2, n - n2);
            }
            this.assign(n, object);
            this.didMove(n, object, n2);
            this.didChange();
        }
        return object;
    }

    public void shrink() {
        ++this.modCount;
        if (this.size == 0) {
            this.data = null;
        } else if (this.size < this.data.length) {
            Object[] objectArray = this.data;
            this.data = this.newData(this.size);
            System.arraycopy(objectArray, 0, this.data, 0, this.size);
        }
    }

    public void grow(int n) {
        int n2;
        ++this.modCount;
        int n3 = n2 = this.data == null ? 0 : this.data.length;
        if (n > n2) {
            Object[] objectArray = this.data;
            int n4 = n2 + n2 / 2 + 4;
            if (n4 < n) {
                n4 = n;
            }
            this.data = this.newData(n4);
            if (objectArray != null) {
                System.arraycopy(objectArray, 0, this.data, 0, this.size);
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.data.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeObject(this.data[n]);
            ++n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = this.newData(n);
        int n2 = 0;
        while (n2 < this.size) {
            this.didAdd(n2, this.assign(n2, objectInputStream.readObject()));
            ++n2;
        }
    }

    public Object clone() {
        try {
            BasicEList basicEList = (BasicEList)super.clone();
            if (this.size > 0) {
                basicEList.size = this.size;
                basicEList.data = this.newData(this.size);
                System.arraycopy(this.data, 0, basicEList.data, 0, this.size);
            }
            return basicEList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size) {
            return false;
        }
        Iterator iterator = ((List)object).iterator();
        if (this.useEquals()) {
            int n = 0;
            while (n < this.size) {
                Object object2 = this.data[n];
                Object e = iterator.next();
                boolean bl = object2 == null ? e != null : !object2.equals(e);
                if (bl) {
                    return false;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.size) {
                Object object3 = this.data[n];
                Object e = iterator.next();
                if (object3 != e) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.size) {
            Object object = this.data[n2];
            n = 31 * n + (object == null ? 0 : object.hashCode());
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append(String.valueOf(this.data[n]));
            if (++n >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new EIterator();
    }

    protected Iterator basicIterator() {
        return new NonResolvingEIterator();
    }

    public ListIterator listIterator() {
        return new EListIterator();
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        return new EListIterator(n);
    }

    protected ListIterator basicListIterator() {
        return new NonResolvingEListIterator();
    }

    protected ListIterator basicListIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        return new NonResolvingEListIterator(n);
    }

    protected List basicList() {
        if (this.size == 0) {
            return ECollections.EMPTY_ELIST;
        }
        return new UnmodifiableEList(this.size, this.data);
    }

    protected Collection getDuplicates(Collection collection) {
        Collection collection2 = collection;
        Collection collection3 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            if (collection3 == null) {
                collection2 = collection3 = new BasicEList(collection);
            }
            collection3.remove(e);
        }
        return collection2;
    }

    protected Collection getNonDuplicates(Collection collection) {
        UniqueEList uniqueEList = new UniqueEList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            uniqueEList.add(e);
        }
        return uniqueEList;
    }

    static /* synthetic */ int access$001(BasicEList basicEList) {
        return basicEList.modCount;
    }

    public static class UnmodifiableEList
    extends BasicEList {
        public UnmodifiableEList(int n, Object[] objectArray) {
            this.size = n;
            this.data = objectArray;
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void move(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public void shrink() {
            throw new UnsupportedOperationException();
        }

        public void grow(int n) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return this.basicIterator();
        }

        public ListIterator listIterator() {
            return this.basicListIterator();
        }

        public ListIterator listIterator(int n) {
            return this.basicListIterator(n);
        }
    }

    protected class NonResolvingEListIterator
    extends EListIterator {
        public NonResolvingEListIterator() {
        }

        public NonResolvingEListIterator(int n) {
            super(n);
        }

        public Object next() {
            try {
                Object object = BasicEList.this.data[this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                Object object = BasicEList.this.data[--this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    protected class EListIterator
    extends EIterator
    implements ListIterator {
        public EListIterator() {
        }

        public EListIterator(int n) {
            this.cursor = n;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object object = BasicEList.this.get(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                BasicEList.this.set(this.lastCursor, object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkModCount();
            try {
                BasicEList.this.add(this.cursor++, object);
                this.expectedModCount = BasicEList.this.modCount;
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class NonResolvingEIterator
    extends EIterator {
        protected NonResolvingEIterator() {
        }

        public Object next() {
            try {
                Object object = BasicEList.this.data[this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class EIterator
    implements Iterator {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount = BasicEList.access$001(BasicEList.this);

        protected EIterator() {
        }

        public boolean hasNext() {
            return this.cursor != BasicEList.this.size();
        }

        public Object next() {
            try {
                Object object = BasicEList.this.get(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                BasicEList.this.remove(this.lastCursor);
                this.expectedModCount = BasicEList.this.modCount;
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                }
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (BasicEList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

