/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class BasicEMap
implements EMap,
Cloneable,
Serializable {
    protected transient EList delegateEList;
    protected int size;
    protected transient BasicEList[] entryData;
    protected transient int modCount;
    protected transient View view;

    public BasicEMap() {
        this.initializeDelegateEList();
    }

    protected void initializeDelegateEList() {
        this.delegateEList = new BasicEList(){

            protected void didAdd(int n, Object object) {
                BasicEMap.this.doPut((Entry)object);
            }

            protected void didSet(int n, Object object, Object object2) {
                this.didRemove(n, object2);
                this.didAdd(n, object);
            }

            protected void didRemove(int n, Object object) {
                BasicEMap.this.doRemove((Entry)object);
            }

            protected void didClear(int n, Object[] objectArray) {
                BasicEMap.this.doClear();
            }

            protected void didMove(int n, Object object, int n2) {
                BasicEMap.this.doMove((Entry)object);
            }
        };
    }

    public BasicEMap(int n) {
        this();
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity:" + n);
        }
        this.entryData = this.newEntryData(n);
    }

    public BasicEMap(Map map) {
        this();
        int n = map.size();
        if (n > 0) {
            this.entryData = this.newEntryData(2 * n);
            this.putAll(map);
        }
    }

    protected BasicEList[] newEntryData(int n) {
        return new BasicEList[n];
    }

    protected void ensureEntryDataExists() {
        if (this.entryData == null) {
            this.entryData = this.newEntryData(2 * this.size);
            int n = this.modCount;
            this.size = 0;
            Iterator iterator = this.delegateEList.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                this.doPut(entry);
            }
            this.modCount = n;
        }
    }

    protected BasicEList newList() {
        return new BasicEList(){

            public Object[] newData(int n) {
                return new EntryImpl[n];
            }
        };
    }

    protected Entry newEntry(int n, Object object, Object object2) {
        this.validateKey(object);
        this.validateValue(object2);
        return new EntryImpl(n, object, object2);
    }

    protected Object putEntry(Entry entry, Object object) {
        return entry.setValue(object);
    }

    protected boolean useEqualsForKey() {
        return true;
    }

    protected boolean useEqualsForValue() {
        return true;
    }

    protected Object resolve(Object object, Object object2) {
        return object2;
    }

    protected void validateKey(Object object) {
    }

    protected void validateValue(Object object) {
    }

    protected void didAdd(Entry entry) {
    }

    protected void didModify(Entry entry, Object object) {
    }

    protected void didRemove(Entry entry) {
    }

    protected void didClear(BasicEList[] basicEListArray) {
        if (basicEListArray != null) {
            int n = 0;
            while (n < basicEListArray.length) {
                BasicEList basicEList = basicEListArray[n];
                if (basicEList != null) {
                    Entry[] entryArray = (Entry[])basicEList.data;
                    int n2 = basicEList.size;
                    int n3 = 0;
                    while (n3 < n2) {
                        Entry entry = entryArray[n3];
                        this.didRemove(entry);
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int indexOfKey(Object object) {
        if (this.useEqualsForKey() && object != null) {
            int n = 0;
            int n2 = this.delegateEList.size();
            while (n < n2) {
                Entry entry = (Entry)this.delegateEList.get(n);
                if (object.equals(entry.getKey())) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.delegateEList.size();
            while (n < n3) {
                Entry entry = (Entry)this.delegateEList.get(n);
                if (object == entry.getKey()) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean containsKey(Object object) {
        if (this.size > 0) {
            this.ensureEntryDataExists();
            int n = this.hashOf(object);
            int n2 = this.indexOf(n);
            int n3 = this.entryIndexForKey(n2, n, object);
            return n3 != -1;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        block10: {
            if (this.size <= 0) break block10;
            this.ensureEntryDataExists();
            if (this.useEqualsForValue() && object != null) {
                int n = 0;
                while (n < this.entryData.length) {
                    BasicEList basicEList = this.entryData[n];
                    if (basicEList != null) {
                        Entry[] entryArray = (Entry[])basicEList.data;
                        int n2 = basicEList.size;
                        int n3 = 0;
                        while (n3 < n2) {
                            Entry entry = entryArray[n3];
                            if (object.equals(entry.getValue())) {
                                return true;
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.entryData.length) {
                    BasicEList basicEList = this.entryData[n];
                    if (basicEList != null) {
                        Entry[] entryArray = (Entry[])basicEList.data;
                        int n4 = basicEList.size;
                        int n5 = 0;
                        while (n5 < n4) {
                            Entry entry = entryArray[n5];
                            if (object == entry.getValue()) {
                                return true;
                            }
                            ++n5;
                        }
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    public Object get(Object object) {
        if (this.size > 0) {
            this.ensureEntryDataExists();
            int n = this.hashOf(object);
            int n2 = this.indexOf(n);
            Entry entry = this.entryForKey(n2, n, object);
            if (entry != null) {
                return this.resolve(object, entry.getValue());
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        int n;
        Entry entry;
        this.ensureEntryDataExists();
        int n2 = this.hashOf(object);
        if (this.size > 0 && (entry = this.entryForKey(n = this.indexOf(n2), n2, object)) != null) {
            Object object3 = this.putEntry(entry, object2);
            this.didModify(entry, object3);
            return object3;
        }
        Entry entry2 = this.newEntry(n2, object, object2);
        this.delegateEList.add(entry2);
        return null;
    }

    protected void doPut(Entry entry) {
        if (this.entryData == null) {
            ++this.modCount;
            ++this.size;
        } else {
            int n = entry.getHash();
            this.grow(this.size + 1);
            int n2 = this.indexOf(n);
            BasicEList basicEList = this.entryData[n2];
            if (basicEList == null) {
                basicEList = this.entryData[n2] = this.newList();
            }
            basicEList.add(entry);
            ++this.size;
            this.didAdd(entry);
        }
    }

    public Object removeKey(Object object) {
        this.ensureEntryDataExists();
        int n = this.hashOf(object);
        int n2 = this.indexOf(n);
        Entry entry = this.entryForKey(n2, n, object);
        if (entry != null) {
            this.remove(entry);
            return entry.getValue();
        }
        return null;
    }

    protected void doRemove(Entry entry) {
        if (this.entryData == null) {
            ++this.modCount;
            --this.size;
        } else {
            Object k = entry.getKey();
            int n = entry.getHash();
            int n2 = this.indexOf(n);
            this.removeEntry(n2, this.entryIndexForKey(n2, n, k));
        }
    }

    protected Object removeEntry(int n, int n2) {
        ++this.modCount;
        --this.size;
        Entry entry = (Entry)this.entryData[n].remove(n2);
        return entry.getValue();
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void doClear() {
        if (this.entryData == null) {
            ++this.modCount;
            this.size = 0;
            this.didClear(null);
        } else {
            ++this.modCount;
            BasicEList[] basicEListArray = this.entryData;
            this.entryData = null;
            this.size = 0;
            this.didClear(basicEListArray);
        }
    }

    protected void doMove(Entry entry) {
        ++this.modCount;
    }

    public Object clone() {
        try {
            BasicEMap basicEMap = (BasicEMap)super.clone();
            if (this.entryData != null) {
                basicEMap.entryData = this.newEntryData(this.entryData.length);
                int n = 0;
                while (n < this.entryData.length) {
                    basicEMap.entryData[n] = this.entryData[n] == null ? null : (BasicEList)this.entryData[n].clone();
                    ++n;
                }
            }
            basicEMap.view = null;
            basicEMap.modCount = 0;
            return basicEMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Map map() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.map == null) {
            this.view.map = new DelegatingMap();
        }
        return this.view.map;
    }

    public Set keySet() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.keySet == null) {
            this.view.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapKeyIterator();
                }

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object object) {
                    return BasicEMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = BasicEMap.this.size;
                    BasicEMap.this.removeKey(object);
                    return BasicEMap.this.size != n;
                }

                public void clear() {
                    BasicEMap.this.clear();
                }
            };
        }
        return this.view.keySet;
    }

    public Collection values() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.values == null) {
            this.view.values = new AbstractCollection(){

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapValueIterator();
                }

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object object) {
                    return BasicEMap.this.containsValue(object);
                }

                public void clear() {
                    BasicEMap.this.clear();
                }
            };
        }
        return this.view.values;
    }

    public Set entrySet() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.entrySet == null) {
            this.view.entrySet = new AbstractSet(){

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object object) {
                    if (BasicEMap.this.size > 0 && object instanceof Map.Entry) {
                        BasicEMap.this.ensureEntryDataExists();
                        Map.Entry entry = (Map.Entry)object;
                        Object k = entry.getKey();
                        int n = k == null ? 0 : k.hashCode();
                        int n2 = BasicEMap.this.indexOf(n);
                        BasicEList basicEList = BasicEMap.this.entryData[n2];
                        if (basicEList != null) {
                            Entry[] entryArray = (Entry[])basicEList.data;
                            int n3 = basicEList.size;
                            int n4 = 0;
                            while (n4 < n3) {
                                Entry entry2 = entryArray[n4];
                                if (entry2.getHash() == n && entry2.equals(entry)) {
                                    return true;
                                }
                                ++n4;
                            }
                        }
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (BasicEMap.this.size > 0 && object instanceof Map.Entry) {
                        BasicEMap.this.ensureEntryDataExists();
                        Map.Entry entry = (Map.Entry)object;
                        Object k = entry.getKey();
                        int n = k == null ? 0 : k.hashCode();
                        int n2 = BasicEMap.this.indexOf(n);
                        BasicEList basicEList = BasicEMap.this.entryData[n2];
                        if (basicEList != null) {
                            Entry[] entryArray = (Entry[])basicEList.data;
                            int n3 = basicEList.size;
                            int n4 = 0;
                            while (n4 < n3) {
                                Entry entry2 = entryArray[n4];
                                if (entry2.getHash() == n && entry2.equals(entry)) {
                                    this.remove(entry);
                                    return true;
                                }
                                ++n4;
                            }
                        }
                    }
                    return false;
                }

                public void clear() {
                    BasicEMap.this.clear();
                }

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapIterator();
                }
            };
        }
        return this.view.entrySet;
    }

    protected int hashOf(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    protected int indexOf(int n) {
        return (n & Integer.MAX_VALUE) % this.entryData.length;
    }

    protected Entry entryForKey(int n, int n2, Object object) {
        block6: {
            BasicEList basicEList = this.entryData[n];
            if (basicEList == null) break block6;
            Entry[] entryArray = (Entry[])basicEList.data;
            int n3 = basicEList.size;
            if (this.useEqualsForKey() && object != null) {
                int n4 = 0;
                while (n4 < n3) {
                    Entry entry = entryArray[n4];
                    if (entry.getHash() == n2 && object.equals(entry.getKey())) {
                        return entry;
                    }
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < n3) {
                    Entry entry = entryArray[n5];
                    if (entry.getKey() == object) {
                        return entry;
                    }
                    ++n5;
                }
            }
        }
        return null;
    }

    protected int entryIndexForKey(int n, int n2, Object object) {
        block6: {
            block5: {
                if (!this.useEqualsForKey() || object == null) break block5;
                BasicEList basicEList = this.entryData[n];
                if (basicEList == null) break block6;
                Entry[] entryArray = (Entry[])basicEList.data;
                int n3 = basicEList.size;
                int n4 = 0;
                while (n4 < n3) {
                    Entry entry = entryArray[n4];
                    if (entry.getHash() == n2 && object.equals(entry.getKey())) {
                        return n4;
                    }
                    ++n4;
                }
                break block6;
            }
            BasicEList basicEList = this.entryData[n];
            if (basicEList != null) {
                Entry[] entryArray = (Entry[])basicEList.data;
                int n5 = basicEList.size;
                int n6 = 0;
                while (n6 < n5) {
                    Entry entry = entryArray[n6];
                    if (entry.getKey() == object) {
                        return n6;
                    }
                    ++n6;
                }
            }
        }
        return -1;
    }

    protected boolean grow(int n) {
        int n2;
        ++this.modCount;
        int n3 = n2 = this.entryData == null ? 0 : this.entryData.length;
        if (n > n2) {
            BasicEList[] basicEListArray = this.entryData;
            this.entryData = this.newEntryData(2 * n2 + 4);
            int n4 = 0;
            while (n4 < n2) {
                BasicEList basicEList = basicEListArray[n4];
                if (basicEList != null) {
                    Entry[] entryArray = (Entry[])basicEList.data;
                    int n5 = basicEList.size;
                    int n6 = 0;
                    while (n6 < n5) {
                        Entry entry = entryArray[n6];
                        int n7 = this.indexOf(entry.getHash());
                        BasicEList basicEList2 = this.entryData[n7];
                        if (basicEList2 == null) {
                            basicEList2 = this.entryData[n7] = this.newList();
                        }
                        basicEList2.add(entry);
                        ++n6;
                    }
                }
                ++n4;
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.entryData == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.entryData.length);
            int n = 0;
            while (n < this.entryData.length) {
                BasicEList basicEList = this.entryData[n];
                if (basicEList != null) {
                    Entry[] entryArray = (Entry[])basicEList.data;
                    int n2 = basicEList.size;
                    int n3 = 0;
                    while (n3 < n2) {
                        Entry entry = entryArray[n3];
                        objectOutputStream.writeObject(entry.getKey());
                        objectOutputStream.writeObject(entry.getValue());
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            this.entryData = this.newEntryData(n);
            int n2 = 0;
            while (n2 < this.size) {
                Object object = objectInputStream.readObject();
                Object object2 = objectInputStream.readObject();
                this.put(object, object2);
                ++n2;
            }
        }
    }

    public boolean contains(Object object) {
        return this.delegateEList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.delegateEList.containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.delegateEList.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.delegateEList.lastIndexOf(object);
    }

    public Object[] toArray() {
        return this.delegateEList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.delegateEList.toArray(objectArray);
    }

    public Object get(int n) {
        return this.delegateEList.get(n);
    }

    public Object set(int n, Object object) {
        return this.delegateEList.set(n, object);
    }

    public boolean add(Object object) {
        return this.delegateEList.add(object);
    }

    public void add(int n, Object object) {
        this.delegateEList.add(n, object);
    }

    public boolean addAll(Collection collection) {
        return this.delegateEList.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.delegateEList.addAll(n, collection);
    }

    public boolean remove(Object object) {
        if (object instanceof Map.Entry) {
            return this.delegateEList.remove(object);
        }
        boolean bl = this.containsKey(object);
        this.removeKey(object);
        return bl;
    }

    public boolean removeAll(Collection collection) {
        return this.delegateEList.removeAll(collection);
    }

    public Object remove(int n) {
        return this.delegateEList.remove(n);
    }

    public boolean retainAll(Collection collection) {
        return this.delegateEList.retainAll(collection);
    }

    public void clear() {
        this.delegateEList.clear();
    }

    public void move(int n, Object object) {
        this.delegateEList.move(n, object);
    }

    public Object move(int n, int n2) {
        return this.delegateEList.move(n, n2);
    }

    public Iterator iterator() {
        return this.delegateEList.iterator();
    }

    public ListIterator listIterator() {
        return this.delegateEList.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.delegateEList.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.delegateEList.subList(n, n2);
    }

    public int hashCode() {
        return this.delegateEList.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EMap) {
            return this.delegateEList.equals(object);
        }
        return false;
    }

    public String toString() {
        return this.delegateEList.toString();
    }

    protected class BasicEMapValueIterator
    extends BasicEMapIterator {
        BasicEMapValueIterator() {
        }

        protected Object yield(Entry entry) {
            return entry.getValue();
        }
    }

    protected class BasicEMapKeyIterator
    extends BasicEMapIterator {
        BasicEMapKeyIterator() {
        }

        protected Object yield(Entry entry) {
            return entry.getKey();
        }
    }

    protected class BasicEMapIterator
    implements Iterator {
        protected int cursor;
        protected int entryCursor = -1;
        protected int lastCursor;
        protected int lastEntryCursor;
        protected int expectedModCount;

        BasicEMapIterator() {
            this.expectedModCount = BasicEMap.this.modCount;
            if (BasicEMap.this.size > 0) {
                this.scan();
            }
        }

        protected Object yield(Entry entry) {
            return entry;
        }

        protected void scan() {
            BasicEList basicEList;
            BasicEMap.this.ensureEntryDataExists();
            if (this.entryCursor != -1) {
                ++this.entryCursor;
                basicEList = BasicEMap.this.entryData[this.cursor];
                if (this.entryCursor < basicEList.size) {
                    return;
                }
                ++this.cursor;
            }
            while (this.cursor < BasicEMap.this.entryData.length) {
                basicEList = BasicEMap.this.entryData[this.cursor];
                if (basicEList != null) {
                    this.entryCursor = 0;
                    return;
                }
                ++this.cursor;
            }
            this.entryCursor = -1;
        }

        public boolean hasNext() {
            return this.entryCursor != -1;
        }

        public Object next() {
            if (BasicEMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entryCursor == -1) {
                throw new NoSuchElementException();
            }
            this.lastCursor = this.cursor;
            this.lastEntryCursor = this.entryCursor;
            this.scan();
            return this.yield((Entry)BasicEMap.this.entryData[this.lastCursor].data[this.lastEntryCursor]);
        }

        public void remove() {
            if (BasicEMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastEntryCursor == -1) {
                throw new IllegalStateException();
            }
            BasicEMap.this.delegateEList.remove(BasicEMap.this.entryData[this.lastCursor].get(this.lastEntryCursor));
            this.expectedModCount = BasicEMap.this.modCount;
            this.lastEntryCursor = -1;
        }
    }

    protected class EntryImpl
    implements Entry {
        protected int hash;
        protected Object key;
        protected Object value;

        public EntryImpl(int n, Object object, Object object2) {
            this.hash = n;
            this.key = object;
            this.value = object2;
        }

        protected Object clone() {
            return BasicEMap.this.newEntry(this.hash, this.key, this.value);
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int n) {
            this.hash = n;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object object) {
            throw new RuntimeException();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            BasicEMap.this.validateValue(object);
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (BasicEMap.this.useEqualsForKey() && this.key != null ? this.key.equals(entry.getKey()) : this.key == entry.getKey()) && (BasicEMap.this.useEqualsForValue() && this.value != null ? this.value.equals(entry.getValue()) : this.value == entry.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }

    protected class DelegatingMap
    implements Map {
        public int size() {
            return BasicEMap.this.size();
        }

        public boolean isEmpty() {
            return BasicEMap.this.isEmpty();
        }

        public boolean containsKey(Object object) {
            return BasicEMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return BasicEMap.this.containsValue(object);
        }

        public Object get(Object object) {
            return BasicEMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            return BasicEMap.this.put(object, object2);
        }

        public Object remove(Object object) {
            return BasicEMap.this.removeKey(object);
        }

        public void putAll(Map map) {
            BasicEMap.this.putAll(map);
        }

        public void clear() {
            BasicEMap.this.clear();
        }

        public Set keySet() {
            return BasicEMap.this.keySet();
        }

        public Collection values() {
            return BasicEMap.this.values();
        }

        public Set entrySet() {
            return BasicEMap.this.entrySet();
        }

        public boolean equals(Object object) {
            return BasicEMap.this.equals(object);
        }

        public int hashCode() {
            return BasicEMap.this.hashCode();
        }
    }

    protected static class View {
        public transient Map map;
        public transient Set keySet;
        public transient Set entrySet;
        public transient Collection values;
    }

    public static interface Entry
    extends Map.Entry {
        public void setKey(Object var1);

        public int getHash();

        public void setHash(int var1);
    }
}

