/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public abstract class DelegatingEList
extends AbstractList
implements EList,
Cloneable,
Serializable {
    public DelegatingEList() {
    }

    public DelegatingEList(Collection collection) {
        this.addAll(collection);
    }

    protected boolean useEquals() {
        return true;
    }

    protected boolean equalObjects(Object object, Object object2) {
        return this.useEquals() && object != null ? object.equals(object2) : object == object2;
    }

    protected boolean canContainNull() {
        return true;
    }

    protected boolean isUnique() {
        return false;
    }

    protected Object validate(int n, Object object) {
        if (!this.canContainNull() && object == null) {
            throw new IllegalArgumentException("The 'no null' constraint is violated");
        }
        return object;
    }

    protected Object resolve(int n, Object object) {
        return object;
    }

    protected void didSet(int n, Object object, Object object2) {
    }

    protected void didAdd(int n, Object object) {
    }

    protected void didRemove(int n, Object object) {
    }

    protected void didClear(int n, Object[] objectArray) {
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < n) {
                this.didRemove(n2, objectArray[n2]);
                ++n2;
            }
        }
    }

    protected void didMove(int n, Object object, int n2) {
    }

    protected void didChange() {
    }

    protected abstract List delegateList();

    public int size() {
        return this.delegateSize();
    }

    protected int delegateSize() {
        return this.delegateList().size();
    }

    public boolean isEmpty() {
        return this.delegateIsEmpty();
    }

    protected boolean delegateIsEmpty() {
        return this.delegateList().isEmpty();
    }

    public boolean contains(Object object) {
        return this.delegateContains(object);
    }

    protected boolean delegateContains(Object object) {
        return this.delegateList().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.delegateContainsAll(collection);
    }

    protected boolean delegateContainsAll(Collection collection) {
        return this.delegateList().containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.delegateIndexOf(object);
    }

    protected int delegateIndexOf(Object object) {
        return this.delegateList().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.delegateLastIndexOf(object);
    }

    protected int delegateLastIndexOf(Object object) {
        return this.delegateList().lastIndexOf(object);
    }

    public Object[] toArray() {
        return this.delegateToArray();
    }

    protected Object[] delegateToArray() {
        return this.delegateList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.delegateToArray(objectArray);
    }

    protected Object[] delegateToArray(Object[] objectArray) {
        return this.delegateList().toArray(objectArray);
    }

    public Object get(int n) {
        return this.resolve(n, this.delegateGet(n));
    }

    protected Object delegateGet(int n) {
        return this.delegateList().get(n);
    }

    protected Object basicGet(int n) {
        return this.delegateGet(n);
    }

    public Object set(int n, Object object) {
        int n2;
        if (this.isUnique() && (n2 = this.indexOf(object)) >= 0 && n2 != n) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        return this.setUnique(n, object);
    }

    public Object setUnique(int n, Object object) {
        Object object2 = this.delegateSet(n, this.validate(n, object));
        this.didSet(n, object, object2);
        this.didChange();
        return object2;
    }

    protected Object delegateSet(int n, Object object) {
        return this.delegateList().set(n, object);
    }

    public boolean add(Object object) {
        if (this.isUnique() && this.contains(object)) {
            return false;
        }
        this.addUnique(object);
        return true;
    }

    public void addUnique(Object object) {
        ++this.modCount;
        int n = this.size();
        this.delegateAdd(this.validate(n, object));
        this.didAdd(n, object);
        this.didChange();
    }

    protected void delegateAdd(Object object) {
        this.delegateList().add(object);
    }

    public void add(int n, Object object) {
        if (this.isUnique() && this.contains(object)) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        this.addUnique(n, object);
    }

    public void addUnique(int n, Object object) {
        ++this.modCount;
        this.delegateAdd(n, this.validate(n, object));
        this.didAdd(n, object);
        this.didChange();
    }

    protected void delegateAdd(int n, Object object) {
        this.delegateList().add(n, object);
    }

    public boolean addAll(Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(collection);
    }

    public boolean addAllUnique(Collection collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        int n = this.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.delegateAdd(this.validate(n, e));
            this.didAdd(n, e);
            this.didChange();
            ++n;
        }
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(n, collection);
    }

    public boolean addAllUnique(int n, Collection collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.delegateAdd(n, this.validate(n, e));
            this.didAdd(n, e);
            this.didChange();
            ++n;
        }
        return true;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        ListIterator listIterator = this.delegateListIterator();
        while (listIterator.hasNext()) {
            if (!collection.contains(listIterator.next())) continue;
            this.remove(listIterator.previousIndex());
            bl = true;
        }
        return bl;
    }

    public Object remove(int n) {
        ++this.modCount;
        Object object = this.delegateRemove(n);
        this.didRemove(n, object);
        this.didChange();
        return object;
    }

    protected Object delegateRemove(int n) {
        return this.delegateList().remove(n);
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        ListIterator listIterator = this.delegateListIterator();
        while (listIterator.hasNext()) {
            if (collection.contains(listIterator.next())) continue;
            this.remove(listIterator.previousIndex());
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.doClear(this.size(), this.delegateToArray());
    }

    protected void doClear(int n, Object[] objectArray) {
        ++this.modCount;
        this.delegateClear();
        this.didClear(n, objectArray);
        this.didChange();
    }

    protected void delegateClear() {
        this.delegateList().clear();
    }

    public void move(int n, Object object) {
        this.move(n, this.indexOf(object));
    }

    public Object move(int n, int n2) {
        ++this.modCount;
        int n3 = this.size();
        if (n >= n3 || n < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + n + ", size=" + n3);
        }
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + n2 + ", size=" + n3);
        }
        Object object = this.delegateGet(n2);
        if (n != n2) {
            this.delegateAdd(n, this.delegateRemove(n2));
            this.didMove(n, object, n2);
            this.didChange();
        }
        return object;
    }

    public boolean equals(Object object) {
        return this.delegateEquals(object);
    }

    protected boolean delegateEquals(Object object) {
        return this.delegateList().equals(object);
    }

    public int hashCode() {
        return this.delegateHashCode();
    }

    protected int delegateHashCode() {
        return this.delegateList().hashCode();
    }

    public String toString() {
        return this.delegateToString();
    }

    protected String delegateToString() {
        return this.delegateList().toString();
    }

    public Iterator iterator() {
        return new EIterator();
    }

    protected Iterator delegateIterator() {
        return this.delegateList().iterator();
    }

    protected Iterator basicIterator() {
        return new NonResolvingEIterator();
    }

    public ListIterator listIterator() {
        return new EListIterator();
    }

    protected ListIterator delegateListIterator() {
        return this.delegateList().listIterator();
    }

    public ListIterator listIterator(int n) {
        int n2 = this.size();
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + n2);
        }
        return new EListIterator(n);
    }

    protected ListIterator basicListIterator() {
        return new NonResolvingEListIterator();
    }

    protected ListIterator basicListIterator(int n) {
        int n2 = this.size();
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + n2);
        }
        return new NonResolvingEListIterator(n);
    }

    protected List basicList() {
        return this.delegateBasicList();
    }

    protected List delegateBasicList() {
        return this.delegateList();
    }

    protected Collection getDuplicates(Collection collection) {
        Collection collection2 = collection;
        Collection collection3 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            if (collection3 == null) {
                collection2 = collection3 = new BasicEList(collection);
            }
            collection3.remove(e);
        }
        return collection2;
    }

    protected Collection getNonDuplicates(Collection collection) {
        UniqueEList uniqueEList = new UniqueEList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            uniqueEList.add(e);
        }
        return uniqueEList;
    }

    static /* synthetic */ int access$001(DelegatingEList delegatingEList) {
        return delegatingEList.modCount;
    }

    public static class UnmodifiableEList
    extends DelegatingEList {
        protected List underlyingList;

        public UnmodifiableEList(List list) {
            this.underlyingList = list;
        }

        protected List delegateList() {
            return this.underlyingList;
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void move(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return this.basicIterator();
        }

        public ListIterator listIterator() {
            return this.basicListIterator();
        }

        public ListIterator listIterator(int n) {
            return this.basicListIterator(n);
        }
    }

    protected class NonResolvingEListIterator
    extends EListIterator {
        public NonResolvingEListIterator() {
        }

        public NonResolvingEListIterator(int n) {
            super(n);
        }

        public Object next() {
            try {
                Object object = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                Object object = DelegatingEList.this.delegateGet(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    protected class EListIterator
    extends EIterator
    implements ListIterator {
        public EListIterator() {
        }

        public EListIterator(int n) {
            this.cursor = n;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object object = DelegatingEList.this.get(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.set(this.lastCursor, object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkModCount();
            try {
                DelegatingEList.this.add(this.cursor++, object);
                this.expectedModCount = DelegatingEList.this.modCount;
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class NonResolvingEIterator
    extends EIterator {
        protected NonResolvingEIterator() {
        }

        public Object next() {
            try {
                Object object = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class EIterator
    implements Iterator {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount = DelegatingEList.access$001(DelegatingEList.this);

        protected EIterator() {
        }

        public boolean hasNext() {
            return this.cursor != DelegatingEList.this.size();
        }

        public Object next() {
            try {
                Object object = DelegatingEList.this.get(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.remove(this.lastCursor);
                this.expectedModCount = DelegatingEList.this.modCount;
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                }
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (DelegatingEList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

