/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ECollections {
    public static final EList EMPTY_ELIST = new EmptyUnmodifiableEList();

    private ECollections() {
    }

    public static EList unmodifiableEList(EList eList) {
        return new UnmodifiableEList(eList);
    }

    private static class EmptyUnmodifiableEList
    implements EList {
        ListIterator listIterator = new ListIterator(this){
            private final /* synthetic */ EmptyUnmodifiableEList this$0;
            {
                this.this$0 = emptyUnmodifiableEList;
            }

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return 0;
            }

            public int previousIndex() {
                return -1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }
        };

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object object) {
            return Collections.EMPTY_LIST.equals(object);
        }

        public int hashCode() {
            return Collections.EMPTY_LIST.hashCode();
        }

        public Object get(int n) {
            return Collections.EMPTY_LIST.get(n);
        }

        public boolean contains(Object object) {
            return false;
        }

        public int indexOf(Object object) {
            return -1;
        }

        public int lastIndexOf(Object object) {
            return -1;
        }

        public Iterator iterator() {
            return this.listIterator;
        }

        public ListIterator listIterator() {
            return this.listIterator;
        }

        public ListIterator listIterator(int n) {
            return this.listIterator;
        }

        public List subList(int n, int n2) {
            return Collections.EMPTY_LIST.subList(n, n2);
        }

        public Object[] toArray() {
            return Collections.EMPTY_LIST.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return Collections.EMPTY_LIST.toArray(objectArray);
        }

        public String toString() {
            return Collections.EMPTY_LIST.toString();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return false;
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void move(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableEList
    implements EList {
        protected EList list;

        public UnmodifiableEList(EList eList) {
            this.list = eList;
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.list.toArray(objectArray);
        }

        public String toString() {
            return this.list.toString();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator i;
                private final /* synthetic */ UnmodifiableEList this$0;
                {
                    this.this$0 = unmodifiableEList;
                    this.i = this.this$0.list.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return this.list.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            return new ListIterator(this, n){
                ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ UnmodifiableEList this$0;
                {
                    this.this$0 = unmodifiableEList;
                    this.val$index = n;
                    this.i = this.this$0.list.listIterator(this.val$index);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int n, int n2) {
            return new UnmodifiableEList(new BasicEList(this.list.subList(n, n2)));
        }

        public void move(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }
}

