/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class URI {
    private final int hashCode;
    private final boolean hierarchical;
    private final String scheme;
    private final String authority;
    private final String fragment;
    private URI cachedTrimFragment;
    private String cachedToString;
    private final String device;
    private final boolean absolutePath;
    private final String[] segments;
    private final String query;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SEGMENT_EMPTY = "";
    private static final String SEGMENT_SELF = ".";
    private static final String SEGMENT_PARENT = "..";
    private static final String[] NO_SEGMENTS = new String[0];
    private static final char SCHEME_SEPARATOR = ':';
    private static final String AUTHORITY_SEPARATOR = "//";
    private static final char DEVICE_IDENTIFIER = ':';
    private static final char SEGMENT_SEPARATOR = '/';
    private static final char QUERY_SEPARATOR = '?';
    private static final char FRAGMENT_SEPARATOR = '#';
    private static final char USER_INFO_SEPARATOR = '@';
    private static final char PORT_SEPARATOR = ':';
    private static final char FILE_EXTENSION_SEPARATOR = '.';
    private static final char[] MAJOR_SEPARATORS = new char[]{':', '/', '?', '#'};
    private static final char[] SEGMENT_END = new char[]{'/', '?', '#'};
    private static final char JAR_IDENTIFIER = '!';
    private static final String JAR_SEPARATOR = "!/";

    public static URI createGenericURI(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("relative non-hierarchical URI");
        }
        if (SCHEME_JAR.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException("non-hierarchical JAR-scheme URI");
        }
        return new URI(false, string, string2, null, false, NO_SEGMENTS, null, string3);
    }

    public static URI createHierarchicalURI(String string, String string2, String string3, String string4, String string5) {
        if (string != null && string2 == null && string3 == null) {
            throw new IllegalArgumentException("absolute hierarchical URI without authority, device, path");
        }
        if (SCHEME_JAR.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException("JAR-scheme URI with no path");
        }
        return new URI(true, string, string2, string3, false, NO_SEGMENTS, string4, string5);
    }

    public static URI createHierarchicalURI(String string, String string2, String string3, String[] stringArray, String string4, String string5) {
        if (SCHEME_JAR.equalsIgnoreCase(string) && string3 != null) {
            throw new IllegalArgumentException("JAR-scheme URI with device");
        }
        return new URI(true, string, string2, string3, true, URI.fix(stringArray), string4, string5);
    }

    public static URI createHierarchicalURI(String[] stringArray, String string, String string2) {
        return new URI(true, null, null, null, false, URI.fix(stringArray), string, string2);
    }

    private static String[] fix(String[] stringArray) {
        return stringArray == null ? NO_SEGMENTS : (String[])stringArray.clone();
    }

    public static URI createURI(String string) {
        return URI.parseIntoURI(string);
    }

    public static URI createDeviceURI(String string) {
        return URI.parseIntoURI(string);
    }

    private static URI parseIntoURI(String string) {
        Object object;
        boolean bl;
        boolean bl2 = true;
        String string2 = null;
        String string3 = null;
        Object object2 = null;
        boolean bl3 = false;
        String[] stringArray = NO_SEGMENTS;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = URI.findSeparator(string, n, MAJOR_SEPARATORS);
        if (n2 < string.length() && string.charAt(n2) == ':') {
            string2 = string.substring(n, n2);
            n = n2 + 1;
        }
        if (bl = SCHEME_JAR.equalsIgnoreCase(string2)) {
            n2 = string.indexOf(JAR_SEPARATOR, n);
            if (n2 == -1) {
                throw new IllegalArgumentException("no JAR separator");
            }
            bl2 = true;
            string3 = string.substring(n, ++n2);
            n = n2;
        } else if (string.startsWith(AUTHORITY_SEPARATOR, n)) {
            n2 = URI.findSeparator(string, n += AUTHORITY_SEPARATOR.length(), SEGMENT_END);
            string3 = string.substring(n, n2);
            n = n2;
        } else if (string2 != null && (n == string.length() || string.charAt(n) != '/')) {
            bl2 = false;
            n2 = URI.findSeparator(string, n, new char[]{'#'});
            string3 = string.substring(n, n2);
            n = n2;
        }
        if (!bl && n < string.length() && string.charAt(n) == '/' && ((String)(object = string.substring(n + 1, n2 = URI.findSeparator(string, n + 1, SEGMENT_END)))).length() > 0 && ((String)object).charAt(((String)object).length() - 1) == ':') {
            object2 = object;
            n = n2;
        }
        if (n < string.length() && string.charAt(n) == '/') {
            ++n;
            bl3 = true;
        }
        if (URI.segmentsRemain(string, n)) {
            object = new ArrayList();
            while (URI.segmentsRemain(string, n)) {
                n2 = URI.findSeparator(string, n, SEGMENT_END);
                object.add(string.substring(n, n2));
                n = n2;
                if (n >= string.length() || string.charAt(n) != '/' || URI.segmentsRemain(string, ++n)) continue;
                object.add(SEGMENT_EMPTY);
            }
            stringArray = new String[object.size()];
            object.toArray(stringArray);
        }
        if (n < string.length() && string.charAt(n) == '?') {
            n2 = URI.findSeparator(string, ++n, new char[]{'#'});
            string4 = string.substring(n, n2);
            n = n2;
        }
        if (n < string.length()) {
            string5 = string.substring(++n);
        }
        return new URI(bl2, string2, string3, (String)object2, bl3, stringArray, string4, string5);
    }

    public static URI createFileURI(String string) {
        String string2;
        File file = new File(string);
        String string3 = string2 = File.separatorChar != '/' ? string.replace(File.separatorChar, '/') : string;
        if (file.isAbsolute()) {
            URI uRI = URI.parseIntoURI((string2.charAt(0) == '/' ? "file:" : "file:/") + string2);
            return uRI;
        }
        URI uRI = URI.parseIntoURI(string2);
        if (uRI.scheme() != null) {
            throw new IllegalArgumentException("invalid relative pathName: " + string);
        }
        return uRI;
    }

    public static URI createPlatformResourceURI(String string) {
        URI uRI = URI.parseIntoURI((string.charAt(0) == '/' ? "platform:/resource" : "platform:/resource/") + string);
        return uRI;
    }

    private static boolean segmentsRemain(String string, int n) {
        return n < string.length() && string.charAt(n) != '?' && string.charAt(n) != '#';
    }

    private static int findSeparator(String string, int n, char[] cArray) {
        int n2 = string.length();
        if (n >= n2) {
            return n2;
        }
        n = n > 0 ? n : 0;
        block0: while (n < n2) {
            int n3 = 0;
            int n4 = cArray.length;
            while (n3 < n4) {
                if (string.charAt(n) == cArray[n3]) break block0;
                ++n3;
            }
            ++n;
        }
        return n;
    }

    private URI(boolean bl, String string, String string2, String string3, boolean bl2, String[] stringArray, String string4, String string5) {
        boolean bl3 = SCHEME_JAR.equalsIgnoreCase(string);
        if (!URI.validScheme(string)) {
            throw new IllegalArgumentException("invalid scheme: " + string);
        }
        if (!bl && !URI.validOpaquePart(string2)) {
            throw new IllegalArgumentException("invalid opaquePart: " + string2);
        }
        if (bl && !bl3 && !URI.validAuthority(string2)) {
            throw new IllegalArgumentException("invalid authority: " + string2);
        }
        if (bl && bl3 && !URI.validJarAuthority(string2)) {
            throw new IllegalArgumentException("invalid authority: " + string2);
        }
        if (!URI.validDevice(string3)) {
            throw new IllegalArgumentException("invalid device: " + string3);
        }
        if (!URI.validSegments(stringArray)) {
            String string6 = stringArray == null ? "invalid segments: " + stringArray : "invalid segment: " + URI.firstInvalidSegment(stringArray);
            throw new IllegalArgumentException(string6);
        }
        if (!URI.validQuery(string4)) {
            throw new IllegalArgumentException("invalid query: " + string4);
        }
        if (!URI.validFragment(string5)) {
            throw new IllegalArgumentException("invalid fragment: " + string5);
        }
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if (string != null) {
            n ^= string.toLowerCase().hashCode();
        }
        if (string2 != null) {
            n ^= string2.hashCode();
        }
        if (string3 != null) {
            n ^= string3.hashCode();
        }
        if (string4 != null) {
            n ^= string4.hashCode();
        }
        if (string5 != null) {
            n ^= string5.hashCode();
        }
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            n ^= stringArray[n2].hashCode();
            ++n2;
        }
        this.hashCode = n;
        this.hierarchical = bl;
        this.scheme = string == null ? null : string.intern();
        this.authority = string2;
        this.device = string3;
        this.absolutePath = bl2;
        this.segments = stringArray;
        this.query = string4;
        this.fragment = string5;
    }

    private static boolean contains(String string, char[] cArray) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = 0;
            int n4 = cArray.length;
            while (n3 < n4) {
                if (string.charAt(n) == cArray[n3]) {
                    return true;
                }
                ++n3;
            }
            ++n;
        }
        return false;
    }

    public static boolean validScheme(String string) {
        return string == null || !URI.contains(string, MAJOR_SEPARATORS);
    }

    public static boolean validOpaquePart(String string) {
        return string != null && string.indexOf(35) == -1 && string.length() > 0 && string.charAt(0) != '/';
    }

    public static boolean validAuthority(String string) {
        return string == null || !URI.contains(string, SEGMENT_END);
    }

    public static boolean validJarAuthority(String string) {
        if (string != null && string.length() > 0 && string.charAt(string.length() - 1) == '!') {
            try {
                URI uRI = URI.parseIntoURI(string.substring(0, string.length() - 1));
                return !uRI.isRelative() && !uRI.hasFragment();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean validDevice(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        return n > 0 && string.charAt(n - 1) == ':' && !URI.contains(string, SEGMENT_END);
    }

    public static boolean validSegment(String string) {
        return string != null && !URI.contains(string, SEGMENT_END);
    }

    public static boolean validSegments(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (!URI.validSegment(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String firstInvalidSegment(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (!URI.validSegment(stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean validQuery(String string) {
        return string == null || string.indexOf(35) == -1;
    }

    public static boolean validFragment(String string) {
        return true;
    }

    public boolean isRelative() {
        return this.scheme == null;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public boolean hasAuthority() {
        return this.hierarchical && this.authority != null;
    }

    public boolean hasOpaquePart() {
        return !this.hierarchical;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasPath() {
        return this.absolutePath || this.authority == null && this.device == null;
    }

    public boolean hasAbsolutePath() {
        return this.absolutePath;
    }

    public boolean hasRelativePath() {
        return this.authority == null && this.device == null && !this.absolutePath;
    }

    public boolean hasEmptyPath() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public boolean hasFragment() {
        return this.fragment != null;
    }

    public boolean isCurrentDocumentReference() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null;
    }

    public boolean isEmpty() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null && this.fragment == null;
    }

    public boolean isFile() {
        return this.isHierarchical() && (this.isRelative() && !this.hasQuery() || SCHEME_FILE.equalsIgnoreCase(this.scheme));
    }

    private boolean isJar() {
        return SCHEME_JAR.equalsIgnoreCase(this.scheme);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        return this.hashCode == uRI.hashCode() && this.hierarchical == uRI.isHierarchical() && this.absolutePath == uRI.hasAbsolutePath() && URI.equals(this.scheme, uRI.scheme(), true) && URI.equals(this.authority, this.hierarchical ? uRI.authority() : uRI.opaquePart()) && URI.equals(this.device, uRI.device()) && URI.equals(this.query, uRI.query()) && URI.equals(this.fragment, uRI.fragment()) && this.segmentsEqual(uRI);
    }

    private boolean segmentsEqual(URI uRI) {
        if (this.segments.length != uRI.segmentCount()) {
            return false;
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            if (!this.segments[n].equals(uRI.segment(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static boolean equals(String string, String string2, boolean bl) {
        return string == null ? string2 == null : (bl ? string.equalsIgnoreCase(string2) : string.equals(string2));
    }

    public String scheme() {
        return this.scheme;
    }

    public String opaquePart() {
        return this.isHierarchical() ? null : this.authority;
    }

    public String authority() {
        return this.isHierarchical() ? this.authority : null;
    }

    public String userInfo() {
        if (!this.hasAuthority()) {
            return null;
        }
        int n = this.authority.indexOf(64);
        return n < 0 ? null : this.authority.substring(0, n);
    }

    public String host() {
        if (!this.hasAuthority()) {
            return null;
        }
        int n = this.authority.indexOf(64);
        int n2 = this.authority.indexOf(58);
        return n2 < 0 ? this.authority.substring(n + 1) : this.authority.substring(n + 1, n2);
    }

    public String port() {
        if (!this.hasAuthority()) {
            return null;
        }
        int n = this.authority.indexOf(58);
        return n < 0 ? null : this.authority.substring(n + 1);
    }

    public String device() {
        return this.device;
    }

    public String[] segments() {
        return (String[])this.segments.clone();
    }

    public List segmentsList() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String segment(int n) {
        return this.segments[n];
    }

    public String lastSegment() {
        int n = this.segments.length;
        if (n == 0) {
            return null;
        }
        return this.segments[n - 1];
    }

    public String path() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasAbsolutePath()) {
            stringBuffer.append('/');
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.segments[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String devicePath() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasAuthority()) {
            if (!this.isJar()) {
                stringBuffer.append(AUTHORITY_SEPARATOR);
            }
            stringBuffer.append(this.authority);
            if (this.hasDevice()) {
                stringBuffer.append('/');
            }
        }
        if (this.hasDevice()) {
            stringBuffer.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            stringBuffer.append('/');
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.segments[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String query() {
        return this.query;
    }

    public URI appendQuery(String string) {
        if (!URI.validQuery(string)) {
            throw new IllegalArgumentException("invalid query portion: " + string);
        }
        return new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, string, this.fragment);
    }

    public URI trimQuery() {
        if (this.query == null) {
            return this;
        }
        return new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, null, this.fragment);
    }

    public String fragment() {
        return this.fragment;
    }

    public URI appendFragment(String string) {
        if (!URI.validFragment(string)) {
            throw new IllegalArgumentException("invalid fragment portion: " + string);
        }
        URI uRI = new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, string);
        uRI.cachedTrimFragment = this;
        return uRI;
    }

    public URI trimFragment() {
        if (this.fragment == null) {
            return this;
        }
        if (this.cachedTrimFragment == null) {
            this.cachedTrimFragment = new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, null);
        }
        return this.cachedTrimFragment;
    }

    public URI resolve(URI uRI) {
        return this.resolve(uRI, true);
    }

    public URI resolve(URI uRI, boolean bl) {
        if (!uRI.isHierarchical() || uRI.isRelative()) {
            throw new IllegalArgumentException("resolve against non-hierarchical or relative base");
        }
        if (!this.isRelative()) {
            return this;
        }
        String string = this.authority;
        String string2 = this.device;
        boolean bl2 = this.absolutePath;
        String[] stringArray = this.segments;
        String string3 = this.query;
        if (this.authority == null) {
            string = uRI.authority();
            if (this.device == null) {
                string2 = uRI.device();
                if (this.hasEmptyPath() && this.query == null) {
                    bl2 = uRI.hasAbsolutePath();
                    stringArray = uRI.segments();
                    string3 = uRI.query();
                } else if (this.hasRelativePath()) {
                    bl2 = uRI.hasAbsolutePath() || !this.hasEmptyPath();
                    stringArray = bl2 ? this.mergePath(uRI, bl) : NO_SEGMENTS;
                }
            }
        }
        return new URI(true, uRI.scheme(), string, string2, bl2, stringArray, string3, this.fragment);
    }

    private String[] mergePath(URI uRI, boolean bl) {
        if (uRI.hasRelativePath()) {
            throw new IllegalArgumentException("merge against relative path");
        }
        if (!this.hasRelativePath()) {
            throw new IllegalStateException("merge non-relative path");
        }
        int n = uRI.segmentCount();
        int n2 = this.segments.length;
        String[] stringArray = new String[n + n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            n3 = URI.accumulate(stringArray, n3, uRI.segment(n4), bl);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            n3 = URI.accumulate(stringArray, n3, this.segments[n5], bl);
            ++n5;
        }
        if (n3 > 0 && (n2 == 0 || SEGMENT_EMPTY.equals(this.segments[n2 - 1]) || SEGMENT_PARENT.equals(this.segments[n2 - 1]) || SEGMENT_SELF.equals(this.segments[n2 - 1]))) {
            stringArray[n3++] = SEGMENT_EMPTY;
        }
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }

    private static int accumulate(String[] stringArray, int n, String string, boolean bl) {
        if (SEGMENT_PARENT.equals(string)) {
            if (n == 0) {
                if (bl) {
                    stringArray[n++] = string;
                }
            } else if (SEGMENT_PARENT.equals(stringArray[n - 1])) {
                stringArray[n++] = string;
            } else {
                --n;
            }
        } else if (!SEGMENT_EMPTY.equals(string) && !SEGMENT_SELF.equals(string)) {
            stringArray[n++] = string;
        }
        return n;
    }

    public URI deresolve(URI uRI) {
        return this.deresolve(uRI, true, false, true);
    }

    public URI deresolve(URI uRI, boolean bl, boolean bl2, boolean bl3) {
        if (!uRI.isHierarchical() || uRI.isRelative()) {
            throw new IllegalArgumentException("deresolve against non-hierarchical or relative base");
        }
        if (this.isRelative()) {
            throw new IllegalStateException("deresolve relative URI");
        }
        if (!this.scheme.equalsIgnoreCase(uRI.scheme())) {
            return this;
        }
        if (!this.isHierarchical()) {
            return this;
        }
        String string = this.authority;
        String string2 = this.device;
        boolean bl4 = this.absolutePath;
        String[] stringArray = this.segments;
        String string3 = this.query;
        if (URI.equals(this.authority, uRI.authority()) && (this.hasDevice() || this.hasPath() || !uRI.hasDevice() && !uRI.hasPath())) {
            string = null;
            if (URI.equals(this.device, uRI.device()) && (this.hasPath() || !uRI.hasPath())) {
                string2 = null;
                if (bl2 || bl3) {
                    if (this.hasPath() == uRI.hasPath() && this.segmentsEqual(uRI) && URI.equals(this.query, uRI.query())) {
                        bl4 = false;
                        stringArray = NO_SEGMENTS;
                        string3 = null;
                    } else if (!this.hasPath() && !uRI.hasPath()) {
                        bl4 = false;
                        stringArray = NO_SEGMENTS;
                    } else if (!this.hasCollapsableSegments(bl)) {
                        String[] stringArray2 = this.findRelativePath(uRI, bl);
                        if (bl2 || this.segments.length > stringArray2.length) {
                            bl4 = false;
                            stringArray = stringArray2;
                        }
                    }
                }
            }
        }
        return new URI(true, null, string, string2, bl4, stringArray, string3, this.fragment);
    }

    private boolean hasCollapsableSegments(boolean bl) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("test collapsability of relative path");
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            String string = this.segments[n];
            if (n < n2 - 1 && SEGMENT_EMPTY.equals(string) || SEGMENT_SELF.equals(string) || SEGMENT_PARENT.equals(string) && (!bl || n != 0 && !SEGMENT_PARENT.equals(this.segments[n - 1]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String[] findRelativePath(URI uRI, boolean bl) {
        if (uRI.hasRelativePath()) {
            throw new IllegalArgumentException("find relative path against base with relative path");
        }
        if (!this.hasAbsolutePath()) {
            throw new IllegalArgumentException("find relative path of non-absolute path");
        }
        String[] stringArray = uRI.collapseSegments(bl);
        String[] stringArray2 = this.segments;
        int n = stringArray.length > 0 ? stringArray.length - 1 : 0;
        int n2 = stringArray2.length;
        int n3 = 0;
        int n4 = n < n2 ? n : n2 - 1;
        while (n3 < n4 && stringArray[n3].equals(stringArray2[n3])) {
            ++n3;
        }
        int n5 = n - n3;
        int n6 = n2 - n3;
        if (n6 == 1 && SEGMENT_EMPTY.equals(stringArray2[n2 - 1])) {
            n6 = 0;
        }
        if (n5 + n6 == 0) {
            if (this.query == null) {
                return new String[]{SEGMENT_SELF};
            }
            return NO_SEGMENTS;
        }
        Object[] objectArray = new String[n5 + n6];
        Arrays.fill(objectArray, 0, n5, SEGMENT_PARENT);
        System.arraycopy(stringArray2, n3, objectArray, n5, n6);
        return objectArray;
    }

    String[] collapseSegments(boolean bl) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("collapse relative path");
        }
        if (!this.hasCollapsableSegments(bl)) {
            return this.segments();
        }
        int n = this.segments.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = URI.accumulate(stringArray, n2, this.segments[n3], bl);
            ++n3;
        }
        if (n2 > 0 && (SEGMENT_EMPTY.equals(this.segments[n - 1]) || SEGMENT_PARENT.equals(this.segments[n - 1]) || SEGMENT_SELF.equals(this.segments[n - 1]))) {
            stringArray[n2++] = SEGMENT_EMPTY;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.isRelative()) {
                stringBuffer.append(this.scheme);
                stringBuffer.append(':');
            }
            if (this.isHierarchical()) {
                if (this.hasAuthority()) {
                    if (!this.isJar()) {
                        stringBuffer.append(AUTHORITY_SEPARATOR);
                    }
                    stringBuffer.append(this.authority);
                }
                if (this.hasDevice()) {
                    stringBuffer.append('/');
                    stringBuffer.append(this.device);
                }
                if (this.hasAbsolutePath()) {
                    stringBuffer.append('/');
                }
                int n = 0;
                int n2 = this.segments.length;
                while (n < n2) {
                    if (n != 0) {
                        stringBuffer.append('/');
                    }
                    stringBuffer.append(this.segments[n]);
                    ++n;
                }
                if (this.hasQuery()) {
                    stringBuffer.append('?');
                    stringBuffer.append(this.query);
                }
            } else {
                stringBuffer.append(this.authority);
            }
            if (this.hasFragment()) {
                stringBuffer.append('#');
                stringBuffer.append(this.fragment);
            }
            this.cachedToString = stringBuffer.toString();
        }
        return this.cachedToString;
    }

    String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.toString());
        }
        stringBuffer.append("\n hierarchical: ");
        stringBuffer.append(this.hierarchical);
        stringBuffer.append("\n       scheme: ");
        stringBuffer.append(this.scheme);
        stringBuffer.append("\n    authority: ");
        stringBuffer.append(this.authority);
        stringBuffer.append("\n       device: ");
        stringBuffer.append(this.device);
        stringBuffer.append("\n absolutePath: ");
        stringBuffer.append(this.absolutePath);
        stringBuffer.append("\n     segments: ");
        if (this.segments.length == 0) {
            stringBuffer.append("<empty>");
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append("\n               ");
            }
            stringBuffer.append(this.segments[n]);
            ++n;
        }
        stringBuffer.append("\n        query: ");
        stringBuffer.append(this.query);
        stringBuffer.append("\n     fragment: ");
        stringBuffer.append(this.fragment);
        return stringBuffer.toString();
    }

    public String toFileString() {
        if (!this.isFile()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = File.separatorChar;
        if (this.hasAuthority()) {
            stringBuffer.append(c);
            stringBuffer.append(c);
            stringBuffer.append(this.authority);
            if (this.hasDevice()) {
                stringBuffer.append(c);
            }
        }
        if (this.hasDevice()) {
            stringBuffer.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            stringBuffer.append(c);
        }
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(this.segments[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public URI appendSegment(String string) {
        if (!URI.validSegment(string)) {
            throw new IllegalArgumentException("invalid segment: " + string);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean bl = !this.hasRelativePath();
        int n = this.segments.length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(this.segments, 0, stringArray, 0, n);
        stringArray[n] = string;
        return new URI(true, this.scheme, this.authority, this.device, bl, stringArray, this.query, this.fragment);
    }

    public URI appendSegments(String[] stringArray) {
        if (!URI.validSegments(stringArray)) {
            String string = stringArray == null ? "invalid segments: " + stringArray : "invalid segment: " + URI.firstInvalidSegment(stringArray);
            throw new IllegalArgumentException(string);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean bl = !this.hasRelativePath();
        int n = this.segments.length;
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n + n2];
        System.arraycopy(this.segments, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, 0, stringArray2, n, n2);
        return new URI(true, this.scheme, this.authority, this.device, bl, stringArray2, this.query, this.fragment);
    }

    public URI trimSegments(int n) {
        if (!this.isHierarchical() || n < 1) {
            return this;
        }
        String[] stringArray = NO_SEGMENTS;
        int n2 = this.segments.length - n;
        if (n2 > 0) {
            stringArray = new String[n2];
            System.arraycopy(this.segments, 0, stringArray, 0, n2);
        }
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, stringArray, this.query, this.fragment);
    }

    public boolean hasTrailingPathSeparator() {
        return this.segments.length > 0 && SEGMENT_EMPTY.equals(this.segments[this.segments.length - 1]);
    }

    public String fileExtension() {
        int n = this.segments.length;
        if (n == 0) {
            return null;
        }
        String string = this.segments[n - 1];
        int n2 = string.lastIndexOf(46);
        return n2 < 0 ? null : string.substring(n2 + 1);
    }

    public URI appendFileExtension(String string) {
        if (!URI.validSegment(string)) {
            throw new IllegalArgumentException("invalid segment portion: " + string);
        }
        int n = this.segments.length;
        if (n == 0) {
            return this;
        }
        String string2 = this.segments[n - 1];
        if (SEGMENT_EMPTY.equals(string2)) {
            return this;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append('.');
        stringBuffer.append(string);
        String[] stringArray = new String[n];
        System.arraycopy(this.segments, 0, stringArray, 0, n - 1);
        stringArray[n - 1] = stringBuffer.toString();
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, stringArray, this.query, this.fragment);
    }

    public URI trimFileExtension() {
        int n = this.segments.length;
        if (n == 0) {
            return this;
        }
        String string = this.segments[n - 1];
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return this;
        }
        String string2 = string.substring(0, n2);
        String[] stringArray = new String[n];
        System.arraycopy(this.segments, 0, stringArray, 0, n - 1);
        stringArray[n - 1] = string2;
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, stringArray, this.query, this.fragment);
    }

    public boolean isPrefix() {
        return this.hierarchical && this.query == null && this.fragment == null && (this.hasTrailingPathSeparator() || this.absolutePath && this.segments.length == 0);
    }

    public URI replacePrefix(URI uRI, URI uRI2) {
        if (!uRI.isPrefix() || !uRI2.isPrefix()) {
            String string = uRI.isPrefix() ? "new" : "old";
            throw new IllegalArgumentException("non-prefix " + string + " value");
        }
        String[] stringArray = this.getTailSegments(uRI);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (uRI2.segmentCount() != 0) {
            int n = uRI2.segmentCount() - 1;
            stringArray2 = new String[n + stringArray.length];
            System.arraycopy(uRI2.segments(), 0, stringArray2, 0, n);
            if (stringArray.length != 0) {
                System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
            }
        }
        return new URI(true, uRI2.scheme(), uRI2.authority(), uRI2.device(), uRI2.hasAbsolutePath(), stringArray2, this.query, this.fragment);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getTailSegments(URI var1_1) {
        if (!var1_1.isPrefix()) {
            throw new IllegalArgumentException("non-prefix trim");
        }
        if (!(this.hierarchical && URI.equals(this.scheme, var1_1.scheme(), true) && URI.equals(this.authority, var1_1.authority()) && URI.equals(this.device, var1_1.device()) && this.absolutePath == var1_1.hasAbsolutePath())) {
            return null;
        }
        if (var1_1.segmentCount() == 0) {
            return this.segments;
        }
        var2_2 = 0;
        var3_3 = var1_1.segmentCount() - 1;
        if (this.segments.length > var3_3) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            if (!this.segments[var2_2].equals(var1_1.segment(var2_2))) {
                return null;
            }
            ++var2_2;
lbl14:
            // 2 sources

            ** while (var2_2 < var3_3)
        }
lbl15:
        // 1 sources

        if (var2_2 == this.segments.length - 1 && "".equals(this.segments[var2_2])) {
            return URI.NO_SEGMENTS;
        }
        var4_4 = new String[this.segments.length - var2_2];
        System.arraycopy(this.segments, var2_2, var4_4, 0, var4_4.length);
        return var4_4;
    }
}

