/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.ETypedElementImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EStructuralFeatureImpl
extends ETypedElementImpl
implements EStructuralFeature,
EStructuralFeature.Internal {
    protected int featureID = -1;
    protected Class containerClass;
    protected Object defaultValue = null;
    protected EFactory defaultValueFactory = null;
    protected static final boolean CHANGEABLE_EDEFAULT = true;
    protected boolean changeable = true;
    protected static final boolean VOLATILE_EDEFAULT = false;
    protected boolean volatile_ = false;
    protected static final boolean TRANSIENT_EDEFAULT = false;
    protected boolean transient_ = false;
    protected static final boolean UNIQUE_EDEFAULT = true;
    protected boolean unique = true;
    protected static final String DEFAULT_VALUE_LITERAL_EDEFAULT = null;
    protected String defaultValueLiteral = DEFAULT_VALUE_LITERAL_EDEFAULT;
    protected static final int LOWER_BOUND_EDEFAULT = 0;
    protected int lowerBound = 0;
    protected static final int UPPER_BOUND_EDEFAULT = 1;
    protected int upperBound = 1;
    protected static final boolean UNSETTABLE_EDEFAULT = false;
    protected boolean unsettable = false;
    protected EStructuralFeature.Internal.SettingDelegate settingDelegate;

    protected EStructuralFeatureImpl() {
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEStructuralFeature();
    }

    public Object getDefaultValue() {
        EClassifier eClassifier = this.getEType();
        String string = this.getDefaultValueLiteral();
        if (string == null && eClassifier != null) {
            return eClassifier.getDefaultValue();
        }
        if (eClassifier instanceof EDataType) {
            EFactory eFactory = eClassifier.getEPackage().getEFactoryInstance();
            if (eFactory != this.defaultValueFactory) {
                this.defaultValueFactory = eFactory;
                this.defaultValue = eFactory.createFromString((EDataType)eClassifier, string);
            }
            return this.defaultValue;
        }
        return null;
    }

    public void setDefaultValue(Object object) {
        EClassifier eClassifier = this.getEType();
        if (eClassifier instanceof EDataType) {
            EFactory eFactory = eClassifier.getEPackage().getEFactoryInstance();
            String string = eFactory.convertToString((EDataType)eClassifier, object);
            this.defaultValueFactory = null;
            this.setDefaultValueLiteralGen(string);
            return;
        }
        throw new IllegalStateException("Cannot serialize value to object without an EDataType eType");
    }

    public void setDefaultValueLiteral(String string) {
        this.defaultValueFactory = null;
        this.setDefaultValueLiteralGen(string);
    }

    public void setDefaultValueLiteralGen(String string) {
        String string2 = this.defaultValueLiteral;
        this.defaultValueLiteral = string;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)string2, (Object)this.defaultValueLiteral));
        }
    }

    public boolean isMany() {
        int n = this.getUpperBound();
        return n > 1 || n == -1;
    }

    public boolean isRequired() {
        int n = this.getLowerBound();
        return n >= 1;
    }

    public boolean isUnsettable() {
        return this.unsettable;
    }

    public void setUnsettable(boolean bl) {
        boolean bl2 = this.unsettable;
        this.unsettable = bl;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, bl2, this.unsettable));
        }
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                if (bl) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
            case 3: {
                return this.isChangeable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.isVolatile() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.isTransient() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.getDefaultValueLiteral();
            }
            case 8: {
                return this.getDefaultValue();
            }
            case 9: {
                return new Integer(this.getLowerBound());
            }
            case 10: {
                return new Integer(this.getUpperBound());
            }
            case 11: {
                return this.isMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isUnsettable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.getEContainingClass();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.eType != null;
            }
            case 3: {
                return !this.changeable;
            }
            case 4: {
                return this.volatile_;
            }
            case 5: {
                return this.transient_;
            }
            case 6: {
                return !this.unique;
            }
            case 7: {
                return DEFAULT_VALUE_LITERAL_EDEFAULT == null ? this.defaultValueLiteral != null : !DEFAULT_VALUE_LITERAL_EDEFAULT.equals(this.defaultValueLiteral);
            }
            case 8: {
                return this.getDefaultValue() != null;
            }
            case 9: {
                return this.lowerBound != 0;
            }
            case 10: {
                return this.upperBound != 1;
            }
            case 11: {
                return this.isMany();
            }
            case 12: {
                return this.isRequired();
            }
            case 13: {
                return this.unsettable;
            }
            case 14: {
                return this.getEContainingClass() != null;
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)object);
                return;
            }
            case 1: {
                this.setName((String)object);
                return;
            }
            case 2: {
                this.setEType((EClassifier)object);
                return;
            }
            case 3: {
                this.setChangeable((Boolean)object);
                return;
            }
            case 4: {
                this.setVolatile((Boolean)object);
                return;
            }
            case 5: {
                this.setTransient((Boolean)object);
                return;
            }
            case 6: {
                this.setUnique((Boolean)object);
                return;
            }
            case 7: {
                this.setDefaultValueLiteral((String)object);
                return;
            }
            case 9: {
                this.setLowerBound((Integer)object);
                return;
            }
            case 10: {
                this.setUpperBound((Integer)object);
                return;
            }
            case 13: {
                this.setUnsettable((Boolean)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setEType(null);
                return;
            }
            case 3: {
                this.setChangeable(true);
                return;
            }
            case 4: {
                this.setVolatile(false);
                return;
            }
            case 5: {
                this.setTransient(false);
                return;
            }
            case 6: {
                this.setUnique(true);
                return;
            }
            case 7: {
                this.setDefaultValueLiteral(DEFAULT_VALUE_LITERAL_EDEFAULT);
                return;
            }
            case 9: {
                this.setLowerBound(0);
                return;
            }
            case 10: {
                this.setUpperBound(1);
                return;
            }
            case 13: {
                this.setUnsettable(false);
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean isTransient() {
        return this.transient_;
    }

    public void setTransient(boolean bl) {
        boolean bl2 = this.transient_;
        this.transient_ = bl;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, bl2, this.transient_));
        }
    }

    public boolean isVolatile() {
        return this.volatile_;
    }

    public void setVolatile(boolean bl) {
        boolean bl2 = this.volatile_;
        this.volatile_ = bl;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 4, bl2, this.volatile_));
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean bl) {
        boolean bl2 = this.changeable;
        this.changeable = bl;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, bl2, this.changeable));
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        boolean bl2 = this.unique;
        this.unique = bl;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, bl2, this.unique));
        }
    }

    public String getDefaultValueLiteral() {
        return this.defaultValueLiteral;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int n) {
        int n2 = this.lowerBound;
        this.lowerBound = n;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, n2, this.lowerBound));
        }
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int n) {
        int n2 = this.upperBound;
        this.upperBound = n;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, n2, this.upperBound));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (changeable: ");
        stringBuffer.append(this.changeable);
        stringBuffer.append(", volatile: ");
        stringBuffer.append(this.volatile_);
        stringBuffer.append(", transient: ");
        stringBuffer.append(this.transient_);
        stringBuffer.append(", unique: ");
        stringBuffer.append(this.unique);
        stringBuffer.append(", defaultValueLiteral: ");
        stringBuffer.append(this.defaultValueLiteral);
        stringBuffer.append(", lowerBound: ");
        stringBuffer.append(this.lowerBound);
        stringBuffer.append(", upperBound: ");
        stringBuffer.append(this.upperBound);
        stringBuffer.append(", unsettable: ");
        stringBuffer.append(this.unsettable);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public void setFeatureID(int n) {
        this.featureID = n;
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseAdd(internalEObject, n, clazz, notificationChain);
        }
        if (this.eContainer != null) {
            notificationChain = this.eBasicRemoveFromContainer(notificationChain);
        }
        return this.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public void setContainerClass(Class clazz) {
        this.containerClass = clazz;
    }

    public EClass getEContainingClass() {
        return null;
    }

    protected boolean isResolveProxies() {
        return false;
    }

    protected boolean isContainer() {
        return false;
    }

    protected boolean isContainment() {
        return false;
    }

    protected EReference getEOpposite() {
        return null;
    }

    public EStructuralFeature.Internal.SettingDelegate getSettingDelegate() {
        if (this.settingDelegate == null) {
            this.getEContainingClass().getEAllStructuralFeatures();
            EReference eReference = this.getEOpposite();
            if (eReference != null) {
                eReference.getEContainingClass().getEAllStructuralFeatures();
            }
            EClassifier eClassifier = this.getEType();
            Class clazz = EcoreUtil.wrapperClassFor(eClassifier.getInstanceClass());
            Object object = this.getDefaultValue();
            Object object2 = eClassifier.getDefaultValue();
            this.settingDelegate = this.isMany() ? (this.isContainment() ? (eReference == null ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(0, this) : new InternalSettingDelegateMany(1, clazz, this)) : (clazz == null ? new InternalSettingDelegateMany(2, this) : new InternalSettingDelegateMany(3, clazz, this))) : (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(4, this, eReference) : new InternalSettingDelegateMany(5, clazz, this, eReference)) : (clazz == null ? new InternalSettingDelegateMany(6, this, eReference) : new InternalSettingDelegateMany(7, clazz, this, eReference)))) : (eClassifier instanceof EDataType ? (this.isUnique() ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(8, this) : new InternalSettingDelegateMany(9, clazz, this)) : (clazz == null ? new InternalSettingDelegateMany(10, this) : new InternalSettingDelegateMany(11, clazz, this))) : (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(12, this) : new InternalSettingDelegateMany(13, clazz, this)) : (clazz == null ? new InternalSettingDelegateMany(14, this) : new InternalSettingDelegateMany(15, clazz, this)))) : (eReference == null ? (this.isResolveProxies() ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(16, this) : new InternalSettingDelegateMany(17, clazz, this)) : (clazz == null ? new InternalSettingDelegateMany(18, this) : new InternalSettingDelegateMany(19, clazz, this))) : (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(20, this) : new InternalSettingDelegateMany(21, clazz, this)) : (clazz == null ? new InternalSettingDelegateMany(22, this) : new InternalSettingDelegateMany(23, clazz, this)))) : (eReference.isMany() ? (this.isResolveProxies() ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(24, this, eReference) : new InternalSettingDelegateMany(25, clazz, this, eReference)) : (clazz == null ? new InternalSettingDelegateMany(26, this, eReference) : new InternalSettingDelegateMany(27, clazz, this, eReference))) : (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(28, this, eReference) : new InternalSettingDelegateMany(29, clazz, this, eReference)) : (clazz == null ? new InternalSettingDelegateMany(30, this, eReference) : new InternalSettingDelegateMany(31, clazz, this, eReference)))) : (this.isResolveProxies() ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(32, this, eReference) : new InternalSettingDelegateMany(33, clazz, this, eReference)) : (clazz == null ? new InternalSettingDelegateMany(34, this, eReference) : new InternalSettingDelegateMany(35, clazz, this, eReference))) : (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateMany(36, this, eReference) : new InternalSettingDelegateMany(37, clazz, this, eReference)) : (clazz == null ? new InternalSettingDelegateMany(38, this, eReference) : new InternalSettingDelegateMany(39, clazz, this, eReference)))))))) : (this.isContainer() ? new InternalSettingDelegateSingleContainer((EClass)eClassifier, this, eReference) : (eClassifier instanceof EDataType ? (this.isUnsettable() ? (clazz == null ? new InternalSettingDelegateSingleDataUnsettableDynamic((EDataType)eClassifier, object, object2, this) : new InternalSettingDelegateSingleDataUnsettableStatic(clazz, object, object2, this)) : (clazz == null ? new InternalSettingDelegateSingleDataDynamic((EDataType)eClassifier, object, object2, this) : new InternalSettingDelegateSingleDataStatic(clazz, object, object2, this))) : (this.isContainment() ? (eReference == null ? (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectContainmentUnsettable((EClass)eClassifier, this) : new InternalSettingDelegateSingleEObjectContainment((EClass)eClassifier, this)) : (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectContainmentWithInverseUnsettable((EClass)eClassifier, this, eReference) : new InternalSettingDelegateSingleEObjectContainmentWithInverse((EClass)eClassifier, this, eReference))) : (this.isResolveProxies() ? (eReference == null ? (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectResolvingUnsettable((EClass)eClassifier, this) : new InternalSettingDelegateSingleEObjectResolving((EClass)eClassifier, this)) : (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectResolvingWithInverseUnsettable((EClass)eClassifier, this, eReference) : new InternalSettingDelegateSingleEObjectResolvingWithInverse((EClass)eClassifier, this, eReference))) : (eReference == null ? (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectUnsettable((EClass)eClassifier, this) : new InternalSettingDelegateSingleEObject((EClass)eClassifier, this)) : (this.isUnsettable() ? new InternalSettingDelegateSingleEObjectWithInverseUnsettable((EClass)eClassifier, this, eReference) : new InternalSettingDelegateSingleEObjectWithInverse((EClass)eClassifier, this, eReference)))))));
        }
        return this.settingDelegate;
    }

    public void setSettingDelegate(EStructuralFeature.Internal.SettingDelegate settingDelegate) {
        this.settingDelegate = settingDelegate;
    }

    public static class SettingMany
    implements EStructuralFeature.Setting {
        protected EObject owner;
        protected EStructuralFeature eStructuralFeature;
        protected List list;

        public SettingMany(EObject eObject, EStructuralFeature eStructuralFeature, List list) {
            this.list = list;
        }

        public EObject getEObject() {
            return this.owner;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public Object get(boolean bl) {
            return this.list;
        }

        public void set(Object object) {
            this.list.clear();
            this.list.addAll((List)object);
        }

        public boolean isSet() {
            return this.list instanceof InternalEList.Unsettable ? ((InternalEList.Unsettable)this.list).isSet() : !this.list.isEmpty();
        }

        public void unset() {
            if (this.list instanceof InternalEList.Unsettable) {
                ((InternalEList.Unsettable)this.list).unset();
            } else {
                this.list.clear();
            }
        }
    }

    public static class InternalSettingDelegateSingleEObjectResolvingWithInverseUnsettable
    extends InternalSettingDelegateSingleEObjectResolvingWithInverse {
        public InternalSettingDelegateSingleEObjectResolvingWithInverseUnsettable(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectResolvingWithInverse
    extends InternalSettingDelegateSingleEObjectResolving {
        public InternalSettingDelegateSingleEObjectResolvingWithInverse(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean hasInverse() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectResolvingUnsettable
    extends InternalSettingDelegateSingleEObject {
        public InternalSettingDelegateSingleEObjectResolvingUnsettable(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eClass, eStructuralFeature);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectResolving
    extends InternalSettingDelegateSingleEObject {
        public InternalSettingDelegateSingleEObjectResolving(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eClass, eStructuralFeature);
        }

        public InternalSettingDelegateSingleEObjectResolving(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean isResolveProxies() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectContainmentWithInverseUnsettable
    extends InternalSettingDelegateSingleEObjectContainmentWithInverse {
        public InternalSettingDelegateSingleEObjectContainmentWithInverseUnsettable(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectContainmentUnsettable
    extends InternalSettingDelegateSingleEObjectContainment {
        public InternalSettingDelegateSingleEObjectContainmentUnsettable(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eClass, eStructuralFeature);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectContainmentWithInverse
    extends InternalSettingDelegateSingleEObjectContainment {
        public InternalSettingDelegateSingleEObjectContainmentWithInverse(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean hasInverse() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectContainment
    extends InternalSettingDelegateSingleEObject {
        public InternalSettingDelegateSingleEObjectContainment(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eClass, eStructuralFeature);
        }

        public InternalSettingDelegateSingleEObjectContainment(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean isContainment() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectWithInverseUnsettable
    extends InternalSettingDelegateSingleEObjectWithInverse {
        public InternalSettingDelegateSingleEObjectWithInverseUnsettable(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectWithInverse
    extends InternalSettingDelegateSingleEObject {
        public InternalSettingDelegateSingleEObjectWithInverse(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eClass, eStructuralFeature, eReference);
        }

        protected boolean hasInverse() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObjectUnsettable
    extends InternalSettingDelegateSingleEObject {
        public InternalSettingDelegateSingleEObjectUnsettable(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eClass, eStructuralFeature);
        }

        protected boolean isUnsettable() {
            return true;
        }
    }

    public static class InternalSettingDelegateSingleEObject
    extends InternalSettingDelegateSingle {
        protected EClass eClass;
        protected EReference inverseFeature;

        public InternalSettingDelegateSingleEObject(EClass eClass, EStructuralFeature eStructuralFeature) {
            super(eStructuralFeature);
            this.eClass = eClass;
        }

        public InternalSettingDelegateSingleEObject(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eStructuralFeature);
            this.eClass = eClass;
            this.inverseFeature = eReference;
        }

        protected boolean isUnsettable() {
            return false;
        }

        protected boolean hasInverse() {
            return false;
        }

        protected boolean isContainment() {
            return false;
        }

        protected boolean isResolveProxies() {
            return false;
        }

        public Object dynamicGet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, boolean bl) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (this.isUnsettable() && object == InternalSettingDelegateSingle.NIL) {
                return null;
            }
            if (this.isResolveProxies() && bl && object != null) {
                EObject eObject;
                InternalEObject internalEObject2 = (InternalEObject)object;
                if (internalEObject2.eIsProxy() && internalEObject2 != (eObject = EcoreUtil.resolve((EObject)internalEObject2, internalEObject))) {
                    if (!this.eClass.isInstance(eObject)) {
                        throw new ClassCastException();
                    }
                    object = eObject;
                    dynamicValueHolder.dynamicSet(n, object);
                    if (internalEObject.eNotificationRequired()) {
                        internalEObject.eNotify(new ENotificationImpl(internalEObject, 9, this.feature, (Object)internalEObject2, (Object)eObject));
                    }
                }
                return object;
            }
            return object;
        }

        public void dynamicSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, Object object) {
            Object object2;
            boolean bl;
            Object object3 = dynamicValueHolder.dynamicGet(n);
            boolean bl2 = bl = object3 != null;
            if (this.isUnsettable() && object3 == InternalSettingDelegateSingle.NIL) {
                object3 = null;
            }
            NotificationChain notificationChain = null;
            if (this.hasInverse()) {
                if (object3 != object) {
                    if (object3 != null) {
                        object2 = (InternalEObject)object3;
                        notificationChain = object2.eInverseRemove(internalEObject, object2.eClass().getEAllStructuralFeatures().indexOf(this.inverseFeature), null, notificationChain);
                    }
                    if (object != null) {
                        object2 = (InternalEObject)object;
                        notificationChain = object2.eInverseAdd(internalEObject, object2.eClass().getEAllStructuralFeatures().indexOf(this.inverseFeature), null, notificationChain);
                    }
                }
            } else if (this.isContainment() && object3 != object) {
                if (object3 != null) {
                    notificationChain = ((InternalEObject)object3).eInverseRemove(internalEObject, -1 - this.feature.getFeatureID(), null, notificationChain);
                }
                if (object != null) {
                    notificationChain = ((InternalEObject)object).eInverseAdd(internalEObject, -1 - this.feature.getFeatureID(), null, notificationChain);
                }
            }
            if (object == null && this.isUnsettable()) {
                dynamicValueHolder.dynamicSet(n, InternalSettingDelegateSingle.NIL);
            } else {
                dynamicValueHolder.dynamicSet(n, object);
            }
            if (internalEObject.eNotificationRequired()) {
                object2 = new ENotificationImpl(internalEObject, 1, this.feature, object3, object, this.isUnsettable() && !bl);
                if (notificationChain == null) {
                    internalEObject.eNotify((Notification)object2);
                } else {
                    notificationChain.add((Notification)object2);
                    notificationChain.dispatch();
                }
            } else if (notificationChain != null) {
                notificationChain.dispatch();
            }
        }

        public void dynamicUnset(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object;
            boolean bl;
            Object object2 = dynamicValueHolder.dynamicGet(n);
            boolean bl2 = bl = object2 != null;
            if (this.isUnsettable() && object2 == InternalSettingDelegateSingle.NIL) {
                object2 = null;
            }
            NotificationChain notificationChain = null;
            if (object2 != null) {
                if (this.hasInverse()) {
                    object = (InternalEObject)object2;
                    notificationChain = object.eInverseRemove(internalEObject, object.eClass().getEAllStructuralFeatures().indexOf(this.inverseFeature), null, notificationChain);
                } else if (this.isContainment()) {
                    notificationChain = ((InternalEObject)object2).eInverseRemove(internalEObject, -1 - this.feature.getFeatureID(), null, notificationChain);
                }
            }
            dynamicValueHolder.dynamicUnset(n);
            if (internalEObject.eNotificationRequired()) {
                object = new ENotificationImpl(internalEObject, this.isUnsettable() ? 2 : 1, this.feature, object2, null);
                if (notificationChain == null) {
                    internalEObject.eNotify((Notification)object);
                } else {
                    notificationChain.add((Notification)object);
                    notificationChain.dispatch();
                }
            } else if (notificationChain != null) {
                notificationChain.dispatch();
            }
        }

        public boolean dynamicIsSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                return false;
            }
            if (object == InternalSettingDelegateSingle.NIL) {
                return true;
            }
            if (this.isUnsettable()) {
                return true;
            }
            return object != null;
        }

        public NotificationChain dynamicInverseAdd(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == InternalSettingDelegateSingle.NIL) {
                object = null;
            }
            if (this.hasInverse()) {
                if (object != internalEObject2 && object != null) {
                    InternalEObject internalEObject3 = (InternalEObject)object;
                    notificationChain = internalEObject3.eInverseRemove(internalEObject, internalEObject3.eClass().getEAllStructuralFeatures().indexOf(this.inverseFeature), null, notificationChain);
                }
            } else if (this.isContainment() && object != null) {
                notificationChain = ((InternalEObject)object).eInverseRemove(internalEObject, -1 - this.feature.getFeatureID(), null, notificationChain);
            }
            dynamicValueHolder.dynamicSet(n, internalEObject2);
            if (internalEObject.eNotificationRequired()) {
                if (notificationChain == null) {
                    notificationChain = new NotificationChainImpl(4);
                }
                notificationChain.add(new ENotificationImpl(internalEObject, 1, this.feature, object, (Object)internalEObject2));
            }
            return notificationChain;
        }

        public NotificationChain dynamicInverseRemove(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == InternalSettingDelegateSingle.NIL) {
                object = null;
            }
            dynamicValueHolder.dynamicUnset(n);
            if (internalEObject.eNotificationRequired()) {
                if (notificationChain == null) {
                    notificationChain = new NotificationChainImpl(4);
                }
                if (this.isUnsettable()) {
                    notificationChain.add(new ENotificationImpl(internalEObject, 2, this.feature, object, null));
                } else {
                    notificationChain.add(new ENotificationImpl(internalEObject, 1, this.feature, object, null));
                }
            }
            return notificationChain;
        }
    }

    public static class InternalSettingDelegateSingleDataUnsettableStatic
    extends InternalSettingDelegateSingleDataUnsettable {
        protected Class dataClass;

        public InternalSettingDelegateSingleDataUnsettableStatic(Class clazz, Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(object, object2, eStructuralFeature);
            this.dataClass = clazz;
        }

        protected void validate(Object object) {
            if (!this.dataClass.isInstance(object)) {
                throw new ClassCastException();
            }
        }
    }

    public static class InternalSettingDelegateSingleDataUnsettableDynamic
    extends InternalSettingDelegateSingleDataUnsettable {
        protected EDataType eDataType;

        public InternalSettingDelegateSingleDataUnsettableDynamic(EDataType eDataType, Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(object, object2, eStructuralFeature);
            this.eDataType = eDataType;
        }

        protected void validate(Object object) {
            if (!this.eDataType.isInstance(object)) {
                throw new ClassCastException();
            }
        }
    }

    public static class InternalSettingDelegateSingleDataUnsettable
    extends InternalSettingDelegateSingleData {
        public InternalSettingDelegateSingleDataUnsettable(Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(object, object2, eStructuralFeature);
        }

        public void dynamicSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, Object object) {
            if (internalEObject.eNotificationRequired()) {
                boolean bl = true;
                Object object2 = dynamicValueHolder.dynamicGet(n);
                if (object2 == null) {
                    bl = false;
                    object2 = this.defaultValue;
                } else if (object2 == InternalSettingDelegateSingle.NIL) {
                    object2 = null;
                }
                if (object == null) {
                    if (this.intrinsicDefaultValue != null) {
                        dynamicValueHolder.dynamicSet(n, null);
                        object = this.defaultValue;
                    } else {
                        dynamicValueHolder.dynamicSet(n, InternalSettingDelegateSingle.NIL);
                    }
                } else {
                    this.validate(object);
                    dynamicValueHolder.dynamicSet(n, object);
                }
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 1, this.feature, object2, object, !bl));
            } else if (object == null) {
                if (this.intrinsicDefaultValue != null) {
                    dynamicValueHolder.dynamicSet(n, null);
                } else {
                    dynamicValueHolder.dynamicSet(n, InternalSettingDelegateSingle.NIL);
                }
            } else {
                this.validate(object);
                dynamicValueHolder.dynamicSet(n, object);
            }
        }

        public void dynamicUnset(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            if (internalEObject.eNotificationRequired()) {
                boolean bl = true;
                Object object = dynamicValueHolder.dynamicGet(n);
                if (object == null) {
                    bl = false;
                    object = this.defaultValue;
                } else if (object == InternalSettingDelegateSingle.NIL) {
                    object = null;
                }
                dynamicValueHolder.dynamicUnset(n);
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 2, this.feature, object, this.defaultValue, bl));
            } else {
                dynamicValueHolder.dynamicUnset(n);
            }
        }

        public boolean dynamicIsSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object = dynamicValueHolder.dynamicGet(n);
            return object != null;
        }
    }

    public static class InternalSettingDelegateSingleDataStatic
    extends InternalSettingDelegateSingleData {
        protected Class dataClass;

        public InternalSettingDelegateSingleDataStatic(Class clazz, Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(object, object2, eStructuralFeature);
            this.dataClass = clazz;
        }

        protected void validate(Object object) {
            if (!this.dataClass.isInstance(object)) {
                throw new ClassCastException();
            }
        }
    }

    public static class InternalSettingDelegateSingleDataDynamic
    extends InternalSettingDelegateSingleData {
        protected EDataType eDataType;

        public InternalSettingDelegateSingleDataDynamic(EDataType eDataType, Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(object, object2, eStructuralFeature);
            this.eDataType = eDataType;
        }

        protected void validate(Object object) {
            if (!this.eDataType.isInstance(object)) {
                throw new ClassCastException();
            }
        }
    }

    public static class InternalSettingDelegateSingleData
    extends InternalSettingDelegateSingle {
        protected Object defaultValue;
        protected Object intrinsicDefaultValue;

        public InternalSettingDelegateSingleData(Object object, Object object2, EStructuralFeature eStructuralFeature) {
            super(eStructuralFeature);
            this.defaultValue = object;
            this.intrinsicDefaultValue = object2;
        }

        protected void validate(Object object) {
            throw new ClassCastException();
        }

        public Object dynamicGet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, boolean bl) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                return this.defaultValue;
            }
            if (object == InternalSettingDelegateSingle.NIL) {
                return null;
            }
            return object;
        }

        public void dynamicSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, Object object) {
            if (internalEObject.eNotificationRequired()) {
                Object object2 = this.dynamicGet(internalEObject, dynamicValueHolder, n, false);
                if (object == null) {
                    if (this.intrinsicDefaultValue != null) {
                        dynamicValueHolder.dynamicSet(n, null);
                        object = this.defaultValue;
                    } else if (this.defaultValue != null) {
                        dynamicValueHolder.dynamicSet(n, InternalSettingDelegateSingle.NIL);
                    } else {
                        dynamicValueHolder.dynamicSet(n, null);
                    }
                } else {
                    this.validate(object);
                    dynamicValueHolder.dynamicSet(n, object);
                }
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 1, this.feature, object2, object));
            } else if (object == null) {
                if (this.intrinsicDefaultValue != null) {
                    dynamicValueHolder.dynamicSet(n, null);
                } else if (this.defaultValue != null) {
                    dynamicValueHolder.dynamicSet(n, InternalSettingDelegateSingle.NIL);
                } else {
                    dynamicValueHolder.dynamicSet(n, null);
                }
            } else {
                this.validate(object);
                dynamicValueHolder.dynamicSet(n, object);
            }
        }

        public void dynamicUnset(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            if (internalEObject.eNotificationRequired()) {
                Object object = this.dynamicGet(internalEObject, dynamicValueHolder, n, false);
                dynamicValueHolder.dynamicUnset(n);
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 1, this.feature, object, this.defaultValue));
            } else {
                dynamicValueHolder.dynamicUnset(n);
            }
        }

        public boolean dynamicIsSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                return false;
            }
            if (object == InternalSettingDelegateSingle.NIL) {
                return true;
            }
            return !object.equals(this.defaultValue);
        }
    }

    public static class InternalSettingDelegateSingleContainer
    extends InternalSettingDelegateSingle {
        protected EClass eClass;
        protected EReference inverseFeature;

        public InternalSettingDelegateSingleContainer(EClass eClass, EStructuralFeature eStructuralFeature, EReference eReference) {
            super(eStructuralFeature);
            this.eClass = eClass;
            this.inverseFeature = eReference;
        }

        public Object dynamicGet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, boolean bl) {
            return internalEObject.eContainer();
        }

        public void dynamicSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, Object object) {
            if (object != null && !this.eClass.isInstance(object)) {
                throw new ClassCastException("The newNew value must be of type " + this.eClass);
            }
            EObject eObject = internalEObject.eContainer();
            int n2 = internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.feature);
            if (object != eObject || internalEObject.eContainerFeatureID() != n2 && object != null) {
                if (EcoreUtil.isAncestor(internalEObject, (EObject)object)) {
                    throw new IllegalArgumentException("Recursive containment not allowed for " + internalEObject.toString());
                }
                NotificationChain notificationChain = null;
                if (eObject != null) {
                    notificationChain = internalEObject.eBasicRemoveFromContainer(notificationChain);
                }
                InternalEObject internalEObject2 = (InternalEObject)object;
                if (object != null) {
                    notificationChain = internalEObject2.eInverseAdd(internalEObject, internalEObject2.eClass().getEAllStructuralFeatures().indexOf(this.inverseFeature), null, notificationChain);
                }
                if ((notificationChain = internalEObject.eBasicSetContainer(internalEObject2, n2, notificationChain)) != null) {
                    notificationChain.dispatch();
                }
            } else if (internalEObject.eNotificationRequired()) {
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 1, n2, object, object));
            }
        }

        public void dynamicUnset(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            EObject eObject = internalEObject.eContainer();
            if (eObject != null) {
                int n2;
                NotificationChain notificationChain = null;
                if (eObject != null) {
                    notificationChain = internalEObject.eBasicRemoveFromContainer(notificationChain);
                }
                if ((notificationChain = internalEObject.eBasicSetContainer(null, n2 = internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.feature), notificationChain)) != null) {
                    notificationChain.dispatch();
                }
            } else if (internalEObject.eNotificationRequired()) {
                internalEObject.eNotify(new ENotificationImpl(internalEObject, 1, this.feature, null, null));
            }
        }

        public boolean dynamicIsSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            int n2 = internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.feature);
            return internalEObject.eContainer() != null && internalEObject.eContainerFeatureID() == n2;
        }

        public NotificationChain dynamicInverseAdd(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            if (internalEObject.eContainer() != null) {
                notificationChain = internalEObject.eBasicRemoveFromContainer(notificationChain);
            }
            int n2 = internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.feature);
            return internalEObject.eBasicSetContainer(internalEObject2, n2, notificationChain);
        }

        public NotificationChain dynamicInverseRemove(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            if (internalEObject.eContainer() != null) {
                notificationChain = internalEObject.eBasicRemoveFromContainer(notificationChain);
            }
            int n2 = internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.feature);
            return internalEObject.eBasicSetContainer(null, n2, notificationChain);
        }
    }

    public static abstract class InternalSettingDelegateSingle
    implements EStructuralFeature.Internal.SettingDelegate {
        public static final Object NIL = EStructuralFeature.Internal.DynamicValueHolder.NIL;
        protected EStructuralFeature feature;

        public InternalSettingDelegateSingle(EStructuralFeature eStructuralFeature) {
            this.feature = eStructuralFeature;
        }

        public EStructuralFeature.Setting dynamicSetting(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            return new EStructuralFeature.Setting(this, internalEObject, dynamicValueHolder, n){
                private final /* synthetic */ InternalEObject val$owner;
                private final /* synthetic */ EStructuralFeature.Internal.DynamicValueHolder val$settings;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ InternalSettingDelegateSingle this$0;
                {
                    this.this$0 = internalSettingDelegateSingle;
                    this.val$owner = internalEObject;
                    this.val$settings = dynamicValueHolder;
                    this.val$index = n;
                }

                public EObject getEObject() {
                    return this.val$owner;
                }

                public EStructuralFeature getEStructuralFeature() {
                    return this.this$0.feature;
                }

                public Object get(boolean bl) {
                    return this.this$0.dynamicGet(this.val$owner, this.val$settings, this.val$index, bl);
                }

                public void set(Object object) {
                    this.this$0.dynamicSet(this.val$owner, this.val$settings, this.val$index, object);
                }

                public boolean isSet() {
                    return this.this$0.dynamicIsSet(this.val$owner, this.val$settings, this.val$index);
                }

                public void unset() {
                    this.this$0.dynamicUnset(this.val$owner, this.val$settings, this.val$index);
                }
            };
        }

        public NotificationChain dynamicInverseAdd(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            throw new UnsupportedOperationException();
        }

        public NotificationChain dynamicInverseRemove(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            throw new UnsupportedOperationException();
        }

        public abstract void dynamicUnset(InternalEObject var1, EStructuralFeature.Internal.DynamicValueHolder var2, int var3);

        public abstract boolean dynamicIsSet(InternalEObject var1, EStructuralFeature.Internal.DynamicValueHolder var2, int var3);

        public abstract void dynamicSet(InternalEObject var1, EStructuralFeature.Internal.DynamicValueHolder var2, int var3, Object var4);

        public abstract Object dynamicGet(InternalEObject var1, EStructuralFeature.Internal.DynamicValueHolder var2, int var3, boolean var4);
    }

    public static class InternalSettingDelegateMany
    implements EStructuralFeature.Internal.SettingDelegate {
        public static final int CONTAINMENT_UNSETTABLE_DYNAMIC = 0;
        public static final int CONTAINMENT_UNSETTABLE = 1;
        public static final int CONTAINMENT_DYNAMIC = 2;
        public static final int CONTAINMENT = 3;
        public static final int CONTAINMENT_INVERSE_UNSETTABLE_DYNAMIC = 4;
        public static final int CONTAINMENT_INVERSE_UNSETTABLE = 5;
        public static final int CONTAINMENT_INVERSE_DYNAMIC = 6;
        public static final int CONTAINMENT_INVERSE = 7;
        public static final int DATA_UNIQUE_UNSETTABLE_DYNAMIC = 8;
        public static final int DATA_UNIQUE_UNSETTABLE = 9;
        public static final int DATA_UNIQUE_DYNAMIC = 10;
        public static final int DATA_UNIQUE = 11;
        public static final int DATA_UNSETTABLE_DYNAMIC = 12;
        public static final int DATA_UNSETTABLE = 13;
        public static final int DATA_DYNAMIC = 14;
        public static final int DATA = 15;
        public static final int EOBJECT_RESOLVE_UNSETTABLE_DYNAMIC = 16;
        public static final int EOBJECT_RESOLVE_UNSETTABLE = 17;
        public static final int EOBJECT_RESOLVE_DYNAMIC = 18;
        public static final int EOBJECT_RESOLVE = 19;
        public static final int EOBJECT_UNSETTABLE_DYNAMIC = 20;
        public static final int EOBJECT_UNSETTABLE = 21;
        public static final int EOBJECT_DYNAMIC = 22;
        public static final int EOBJECT = 23;
        public static final int MANY_INVERSE_RESOLVE_UNSETTABLE_DYNAMIC = 24;
        public static final int MANY_INVERSE_RESOLVE_UNSETTABLE = 25;
        public static final int MANY_INVERSE_RESOLVE_DYNAMIC = 26;
        public static final int MANY_INVERSE_RESOLVE = 27;
        public static final int MANY_INVERSE_UNSETTABLE_DYNAMIC = 28;
        public static final int MANY_INVERSE_UNSETTABLE = 29;
        public static final int MANY_INVERSE_DYNAMIC = 30;
        public static final int MANY_INVERSE = 31;
        public static final int INVERSE_RESOLVE_UNSETTABLE_DYNAMIC = 32;
        public static final int INVERSE_RESOLVE_UNSETTABLE = 33;
        public static final int INVERSE_RESOLVE_DYNAMIC = 34;
        public static final int INVERSE_RESOLVE = 35;
        public static final int INVERSE_UNSETTABLE_DYNAMIC = 36;
        public static final int INVERSE_UNSETTABLE = 37;
        public static final int INVERSE_DYNAMIC = 38;
        public static final int INVERSE = 39;
        protected int style;
        protected int dynamicKind;
        protected Class dataClass;
        protected EStructuralFeature feature;
        protected EReference inverseFeature;
        static /* synthetic */ Class class$java$lang$Object;

        public InternalSettingDelegateMany(int n, Class clazz, EStructuralFeature eStructuralFeature) {
            this.style = n;
            this.dataClass = clazz;
            this.feature = eStructuralFeature;
        }

        public InternalSettingDelegateMany(int n, EStructuralFeature eStructuralFeature) {
            this.style = n;
            this.dataClass = class$java$lang$Object == null ? (class$java$lang$Object = InternalSettingDelegateMany.class$("java.lang.Object")) : class$java$lang$Object;
            this.dynamicKind = EcoreEList.Generic.kind(eStructuralFeature);
            this.feature = eStructuralFeature;
        }

        public InternalSettingDelegateMany(int n, Class clazz, EStructuralFeature eStructuralFeature, EReference eReference) {
            this.style = n;
            this.dataClass = clazz;
            this.feature = eStructuralFeature;
            this.inverseFeature = eReference;
        }

        public InternalSettingDelegateMany(int n, EStructuralFeature eStructuralFeature, EReference eReference) {
            this.style = n;
            this.dataClass = class$java$lang$Object == null ? (class$java$lang$Object = InternalSettingDelegateMany.class$("java.lang.Object")) : class$java$lang$Object;
            this.dynamicKind = EcoreEList.Generic.kind(eStructuralFeature);
            this.feature = eStructuralFeature;
            this.inverseFeature = eReference;
        }

        protected EStructuralFeature.Setting createDynamicSetting(InternalEObject internalEObject) {
            switch (this.style) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 30: 
                case 32: 
                case 34: 
                case 36: 
                case 38: {
                    return new EcoreEList.Dynamic(this.dynamicKind, this.dataClass, internalEObject, this.feature);
                }
                case 1: {
                    return new EObjectContainmentEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 3: {
                    return new EObjectContainmentEList(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 5: {
                    return new EObjectContainmentWithInverseEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 7: {
                    return new EObjectContainmentWithInverseEList(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 9: {
                    return new EDataTypeUniqueEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 11: {
                    return new EDataTypeUniqueEList(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 13: {
                    return new EDataTypeEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 15: {
                    return new EDataTypeEList(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 17: {
                    return new EObjectResolvingEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 19: {
                    return new EObjectResolvingEList(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 21: {
                    return new EObjectEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 23: {
                    return new EObjectEList(this.dataClass, internalEObject, this.feature.getFeatureID());
                }
                case 25: {
                    return new EObjectWithInverseResolvingEList.Unsettable.ManyInverse(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 27: {
                    return new EObjectWithInverseResolvingEList.ManyInverse(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 29: {
                    return new EObjectWithInverseEList.Unsettable.ManyInverse(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 31: {
                    return new EObjectWithInverseEList.ManyInverse(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 33: {
                    return new EObjectWithInverseResolvingEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 35: {
                    return new EObjectWithInverseResolvingEList(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 37: {
                    return new EObjectWithInverseEList.Unsettable(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
                case 39: {
                    return new EObjectWithInverseEList(this.dataClass, internalEObject, this.feature.getFeatureID(), this.inverseFeature.getFeatureID());
                }
            }
            throw new RuntimeException("Unknown feature style: " + this.style);
        }

        public EStructuralFeature.Setting dynamicSetting(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                object = this.createDynamicSetting(internalEObject);
                dynamicValueHolder.dynamicSet(n, object);
            }
            return object instanceof EStructuralFeature.Setting ? (EStructuralFeature.Setting)object : new SettingMany(internalEObject, this.feature, (List)dynamicValueHolder.dynamicGet(n));
        }

        public Object dynamicGet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, boolean bl) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                object = this.createDynamicSetting(internalEObject);
                dynamicValueHolder.dynamicSet(n, object);
            }
            return object;
        }

        public void dynamicSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, Object object) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)dynamicValueHolder.dynamicGet(n);
            if (setting == null) {
                setting = this.createDynamicSetting(internalEObject);
                dynamicValueHolder.dynamicSet(n, setting);
            }
            setting.set(object);
        }

        public void dynamicUnset(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)dynamicValueHolder.dynamicGet(n);
            if (setting == null) {
                setting = this.createDynamicSetting(internalEObject);
                dynamicValueHolder.dynamicSet(n, setting);
            }
            setting.unset();
        }

        public boolean dynamicIsSet(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                return false;
            }
            return ((EStructuralFeature.Setting)object).isSet();
        }

        public NotificationChain dynamicInverseAdd(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object == null) {
                object = this.createDynamicSetting(internalEObject);
                dynamicValueHolder.dynamicSet(n, object);
            }
            return ((InternalEList)object).basicAdd(internalEObject2, notificationChain);
        }

        public NotificationChain dynamicInverseRemove(InternalEObject internalEObject, EStructuralFeature.Internal.DynamicValueHolder dynamicValueHolder, int n, InternalEObject internalEObject2, NotificationChain notificationChain) {
            Object object = dynamicValueHolder.dynamicGet(n);
            if (object != null) {
                notificationChain = ((InternalEList)object).basicRemove(internalEObject2, notificationChain);
            }
            return notificationChain;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

