/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EAnnotationImpl;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecore.impl.EEnumLiteralImpl;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.impl.EOperationImpl;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EParameterImpl;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;

public class EcoreFactoryImpl
extends EFactoryImpl
implements EcoreFactory {
    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createEAttribute();
            }
            case 1: {
                return this.createEAnnotation();
            }
            case 2: {
                return this.createEClass();
            }
            case 4: {
                return this.createEDataType();
            }
            case 5: {
                return this.createEEnum();
            }
            case 6: {
                return this.createEEnumLiteral();
            }
            case 7: {
                return this.createEFactory();
            }
            case 10: {
                return this.createEObject();
            }
            case 11: {
                return this.createEOperation();
            }
            case 12: {
                return this.createEPackage();
            }
            case 13: {
                return this.createEParameter();
            }
            case 14: {
                return this.createEReference();
            }
            case 17: {
                return (EObject)((Object)this.createEStringToStringMapEntry());
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.createEBooleanFromString(eDataType, string);
            }
            case 19: {
                return this.createEBooleanObjectFromString(eDataType, string);
            }
            case 20: {
                return this.createECharFromString(eDataType, string);
            }
            case 21: {
                return this.createECharacterObjectFromString(eDataType, string);
            }
            case 22: {
                return this.createEByteFromString(eDataType, string);
            }
            case 23: {
                return this.createEByteObjectFromString(eDataType, string);
            }
            case 24: {
                return this.createEDoubleFromString(eDataType, string);
            }
            case 25: {
                return this.createEDoubleObjectFromString(eDataType, string);
            }
            case 28: {
                return this.createEFloatFromString(eDataType, string);
            }
            case 29: {
                return this.createEFloatObjectFromString(eDataType, string);
            }
            case 30: {
                return this.createEIntFromString(eDataType, string);
            }
            case 31: {
                return this.createEIntegerObjectFromString(eDataType, string);
            }
            case 32: {
                return this.createEJavaClassFromString(eDataType, string);
            }
            case 34: {
                return this.createELongFromString(eDataType, string);
            }
            case 35: {
                return this.createELongObjectFromString(eDataType, string);
            }
            case 37: {
                return this.createEShortFromString(eDataType, string);
            }
            case 38: {
                return this.createEShortObjectFromString(eDataType, string);
            }
            case 39: {
                return this.createEStringFromString(eDataType, string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.convertEBooleanToString(eDataType, object);
            }
            case 19: {
                return this.convertEBooleanObjectToString(eDataType, object);
            }
            case 20: {
                return this.convertECharToString(eDataType, object);
            }
            case 21: {
                return this.convertECharacterObjectToString(eDataType, object);
            }
            case 22: {
                return this.convertEByteToString(eDataType, object);
            }
            case 23: {
                return this.convertEByteObjectToString(eDataType, object);
            }
            case 24: {
                return this.convertEDoubleToString(eDataType, object);
            }
            case 25: {
                return this.convertEDoubleObjectToString(eDataType, object);
            }
            case 28: {
                return this.convertEFloatToString(eDataType, object);
            }
            case 29: {
                return this.convertEFloatObjectToString(eDataType, object);
            }
            case 30: {
                return this.convertEIntToString(eDataType, object);
            }
            case 31: {
                return this.convertEIntegerObjectToString(eDataType, object);
            }
            case 32: {
                return this.convertEJavaClassToString(eDataType, object);
            }
            case 34: {
                return this.convertELongToString(eDataType, object);
            }
            case 35: {
                return this.convertELongObjectToString(eDataType, object);
            }
            case 37: {
                return this.convertEShortToString(eDataType, object);
            }
            case 38: {
                return this.convertEShortObjectToString(eDataType, object);
            }
            case 39: {
                return this.convertEStringToString(eDataType, object);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public EObject createEObject() {
        EObjectImpl eObjectImpl = new EObjectImpl();
        return eObjectImpl;
    }

    public EAttribute createEAttribute() {
        EAttributeImpl eAttributeImpl = new EAttributeImpl();
        return eAttributeImpl;
    }

    public EAnnotation createEAnnotation() {
        EAnnotationImpl eAnnotationImpl = new EAnnotationImpl();
        return eAnnotationImpl;
    }

    public EClass createEClass() {
        EClassImpl eClassImpl = new EClassImpl();
        return eClassImpl;
    }

    public EDataType createEDataType() {
        EDataTypeImpl eDataTypeImpl = new EDataTypeImpl();
        return eDataTypeImpl;
    }

    public EParameter createEParameter() {
        EParameterImpl eParameterImpl = new EParameterImpl();
        return eParameterImpl;
    }

    public EOperation createEOperation() {
        EOperationImpl eOperationImpl = new EOperationImpl();
        return eOperationImpl;
    }

    public EPackage createEPackage() {
        EPackageImpl ePackageImpl = new EPackageImpl();
        return ePackageImpl;
    }

    public EFactory createEFactory() {
        EFactoryImpl eFactoryImpl = new EFactoryImpl();
        return eFactoryImpl;
    }

    public EEnumLiteral createEEnumLiteral() {
        EEnumLiteralImpl eEnumLiteralImpl = new EEnumLiteralImpl();
        return eEnumLiteralImpl;
    }

    public EEnum createEEnum() {
        EEnumImpl eEnumImpl = new EEnumImpl();
        return eEnumImpl;
    }

    public Boolean createEBooleanObjectFromString(EDataType eDataType, String string) {
        return Boolean.valueOf(string);
    }

    public String convertEBooleanObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Character createECharacterObjectFromString(EDataType eDataType, String string) {
        char c = '\u0000';
        try {
            Integer n = new Integer(string);
            c = (char)n.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            char[] cArray = string.toCharArray();
            c = cArray[0];
        }
        return new Character(c);
    }

    public String convertECharacterObjectToString(EDataType eDataType, Object object) {
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            Integer n = new Integer(c);
            return n.toString();
        }
        return object == null ? null : object.toString();
    }

    public Double createEDoubleObjectFromString(EDataType eDataType, String string) {
        return Double.valueOf(string);
    }

    public String convertEDoubleObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Float createEFloatObjectFromString(EDataType eDataType, String string) {
        return Float.valueOf(string);
    }

    public String convertEFloatObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Integer createEIntegerObjectFromString(EDataType eDataType, String string) {
        return Integer.valueOf(string);
    }

    public String convertEIntegerObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public EReference createEReference() {
        EReferenceImpl eReferenceImpl = new EReferenceImpl();
        return eReferenceImpl;
    }

    public Map.Entry createEStringToStringMapEntry() {
        EStringToStringMapEntryImpl eStringToStringMapEntryImpl = new EStringToStringMapEntryImpl();
        return eStringToStringMapEntryImpl;
    }

    public EcorePackage getEcorePackage() {
        return (EcorePackage)this.getEPackage();
    }

    public static EcorePackage getPackage() {
        return EcorePackage.eINSTANCE;
    }

    public String createEStringFromString(EDataType eDataType, String string) {
        return string;
    }

    public String convertEStringToString(EDataType eDataType, Object object) {
        return (String)object;
    }

    public Integer createEIntFromString(EDataType eDataType, String string) {
        return Integer.valueOf(string);
    }

    public String convertEIntToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Boolean createEBooleanFromString(EDataType eDataType, String string) {
        return Boolean.valueOf(string);
    }

    public String convertEBooleanToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Byte createEByteObjectFromString(EDataType eDataType, String string) {
        return Byte.valueOf(string);
    }

    public String convertEByteObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Float createEFloatFromString(EDataType eDataType, String string) {
        return Float.valueOf(string);
    }

    public String convertEFloatToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Character createECharFromString(EDataType eDataType, String string) {
        char c = '\u0000';
        try {
            Integer n = new Integer(string);
            c = (char)n.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            char[] cArray = string.toCharArray();
            c = cArray[0];
        }
        return new Character(c);
    }

    public String convertECharToString(EDataType eDataType, Object object) {
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            Integer n = new Integer(c);
            return n.toString();
        }
        return object == null ? null : object.toString();
    }

    public Long createELongFromString(EDataType eDataType, String string) {
        return Long.valueOf(string);
    }

    public String convertELongToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Double createEDoubleFromString(EDataType eDataType, String string) {
        return Double.valueOf(string);
    }

    public String convertEDoubleToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Byte createEByteFromString(EDataType eDataType, String string) {
        return Byte.valueOf(string);
    }

    public String convertEByteToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Short createEShortFromString(EDataType eDataType, String string) {
        return Short.valueOf(string);
    }

    public String convertEShortToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Class createEJavaClassFromString(EDataType eDataType, String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedException(classNotFoundException);
        }
    }

    public String convertEJavaClassToString(EDataType eDataType, Object object) {
        return object == null ? "" : ((Class)object).getName();
    }

    public Long createELongObjectFromString(EDataType eDataType, String string) {
        return Long.valueOf(string);
    }

    public String convertELongObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public Short createEShortObjectFromString(EDataType eDataType, String string) {
        return Short.valueOf(string);
    }

    public String convertEShortObjectToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }
}

