/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

public class EcorePlugin {
    public static final EcorePlugin INSTANCE = new EcorePlugin();
    private static Map platformResourceMap;

    private EcorePlugin() {
    }

    public static Map getPlatformResourceMap() {
        if (platformResourceMap == null) {
            platformResourceMap = new HashMap();
        }
        return platformResourceMap;
    }

    public static URI resolvePlatformResourcePath(String string) {
        int n = string.indexOf("/", 1);
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        URI uRI = (URI)platformResourceMap.get(string2);
        return uRI != null ? URI.createURI(string3).resolve(uRI) : null;
    }

    public static String[] handlePlatformResourceOptions(String[] stringArray) {
        EcorePlugin.getPlatformResourceMap();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-platformResource")) {
                String[] stringArray2;
                int n2 = n;
                while (++n < stringArray.length && !stringArray[n].startsWith("-")) {
                    URI uRI;
                    stringArray2 = stringArray[n];
                    if (++n >= stringArray.length) continue;
                    String string = stringArray[n];
                    File file = new File(string);
                    if (file.isDirectory() || !file.exists() && file.getParent() != null && file.getParentFile().isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            throw new WrappedException(iOException);
                        }
                        uRI = URI.createFileURI(file.toString() + "/");
                    } else {
                        uRI = URI.createURI(string);
                    }
                    platformResourceMap.put(stringArray2, uRI);
                }
                stringArray2 = new String[stringArray.length - (n - n2)];
                System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                System.arraycopy(stringArray, n, stringArray2, n2, stringArray.length - n);
                return stringArray2;
            }
            ++n;
        }
        return stringArray;
    }
}

