/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceImpl
extends NotifierImpl
implements Resource,
Resource.Internal {
    private static URIConverter defaultURIConverter;
    protected Map defaultSaveOptions;
    protected Map defaultLoadOptions;
    protected ResourceSet resourceSet;
    protected URI uri;
    protected ContentsEList contents;
    protected EList errors;
    protected EList warnings;
    protected boolean isModified;
    protected boolean isLoaded;
    protected Adapter modificationTrackingAdapter;

    protected static URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new URIConverterImpl();
        }
        return defaultURIConverter;
    }

    public ResourceImpl() {
    }

    public ResourceImpl(URI uRI) {
        this();
        this.uri = uRI;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notificationChain) {
        ResourceSet resourceSet2 = this.resourceSet;
        if (resourceSet2 != null) {
            notificationChain = ((InternalEList)resourceSet2.getResources()).basicRemove(this, notificationChain);
        }
        this.resourceSet = resourceSet;
        if (this.eNotificationRequired()) {
            if (notificationChain == null) {
                notificationChain = new NotificationChainImpl(2);
            }
            notificationChain.add(new NotificationImpl(1, (Object)resourceSet2, resourceSet){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class clazz) {
                    return 0;
                }
            });
        }
        return notificationChain;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uRI) {
        URI uRI2 = this.uri;
        this.uri = uRI;
        if (this.eNotificationRequired()) {
            NotificationImpl notificationImpl = new NotificationImpl(1, (Object)uRI2, uRI){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class clazz) {
                    return 1;
                }
            };
            this.eNotify(notificationImpl);
        }
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new ContentsEList();
        }
        return this.contents;
    }

    public TreeIterator getAllContents() {
        return new AbstractTreeIterator(this, false){

            public Iterator getChildren(Object object) {
                return object == ResourceImpl.this ? ResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public EList getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 6;
                }
            };
        }
        return this.errors;
    }

    public EList getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 7;
                }
            };
        }
        return this.warnings;
    }

    protected boolean useZip() {
        return false;
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        EList eList = this.getContents();
        return eList.size() > 1 ? Integer.toString(this.getContents().indexOf(eObject)) : "";
    }

    public String getURIFragment(EObject eObject) {
        String string = EcoreUtil.getID(eObject);
        if (string != null) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        EObject eObject2 = eObject.eContainer();
        while (eObject2 != null) {
            arrayList.add(((InternalEObject)eObject2).eURIFragmentSegment(eObject.eContainmentFeature(), eObject));
            eObject = eObject2;
            eObject2 = eObject.eContainer();
        }
        StringBuffer stringBuffer = new StringBuffer("/");
        stringBuffer.append(this.getURIFragmentRootSegment(eObject));
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            stringBuffer.append('/');
            stringBuffer.append((String)listIterator.previous());
        }
        return stringBuffer.toString();
    }

    protected EObject getEObjectForURIFragmentRootSegment(String string) {
        EList eList;
        int n = 0;
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WrappedException(numberFormatException);
            }
        }
        if (n < (eList = this.getContents()).size()) {
            return (EObject)eList.get(n);
        }
        return null;
    }

    public EObject getEObject(String string) {
        if (string.startsWith("//")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2), "/");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return this.getEObject(arrayList);
        }
        if (string.startsWith("/")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return this.getEObject(arrayList);
        }
        return this.getEObjectByID(string);
    }

    protected EObject getEObject(List list) {
        Iterator iterator = list.iterator();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(!iterator.hasNext() ? "" : (String)iterator.next());
        while (iterator.hasNext() && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)iterator.next());
        }
        return eObject;
    }

    protected EObject getEObjectByID(String string) {
        TreeIterator treeIterator = this.getAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!string.equals(EcoreUtil.getID(eObject))) continue;
            return eObject;
        }
        return null;
    }

    public void attached(EObject eObject) {
        if (this.isTrackingModification()) {
            this.addModificationTrackingAdapters(eObject);
        }
    }

    protected void addModificationTrackingAdapters(EObject eObject) {
        eObject.eAdapters().add(this.modificationTrackingAdapter);
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            eObject2.eAdapters().add(this.modificationTrackingAdapter);
        }
    }

    public void detached(EObject eObject) {
        if (this.isTrackingModification()) {
            this.removeModificationTrackingAdapters(eObject);
        }
    }

    protected void removeModificationTrackingAdapters(EObject eObject) {
        eObject.eAdapters().remove(this.modificationTrackingAdapter);
        if (EcorePackage.eINSTANCE != null) {
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                eObject2.eAdapters().remove(this.modificationTrackingAdapter);
            }
        }
    }

    protected URIConverter getURIConverter() {
        return this.getResourceSet() == null ? ResourceImpl.getDefaultURIConverter() : this.getResourceSet().getURIConverter();
    }

    public void save(Map map) throws IOException {
        URIConverter uRIConverter = this.getURIConverter();
        OutputStream outputStream = uRIConverter.createOutputStream(this.getURI());
        try {
            this.save(outputStream, map);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public void load(Map map) throws IOException {
        if (!this.isLoaded) {
            URIConverter uRIConverter = this.getURIConverter();
            InputStream inputStream = uRIConverter.createInputStream(this.getURI());
            try {
                this.load(inputStream, map);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
    }

    protected ZipEntry newContentZipEntry() {
        return new ZipEntry("ResourceContents");
    }

    public final void save(OutputStream outputStream, Map map) throws IOException {
        ZipOutputStream zipOutputStream = null;
        if (this.useZip()) {
            zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.putNextEntry(this.newContentZipEntry());
            outputStream = zipOutputStream;
        }
        if (this.defaultSaveOptions == null || this.defaultSaveOptions.isEmpty()) {
            this.doSave(outputStream, map);
        } else if (map == null) {
            this.doSave(outputStream, this.defaultSaveOptions);
        } else {
            HashMap hashMap = new HashMap(this.defaultSaveOptions);
            hashMap.putAll(map);
            this.doSave(outputStream, hashMap);
        }
        this.setModified(false);
        if (zipOutputStream != null) {
            zipOutputStream.finish();
        }
    }

    protected void doSave(OutputStream outputStream, Map map) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean isContentZipEntry(ZipEntry zipEntry) {
        return true;
    }

    public final void load(InputStream object, Map map) throws IOException {
        if (!this.isLoaded) {
            Object object2;
            Notification notification = this.setLoaded(true);
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            if (this.useZip()) {
                object2 = new ZipInputStream((InputStream)object);
                while (((ZipInputStream)object2).available() != 0) {
                    ZipEntry zipEntry = ((ZipInputStream)object2).getNextEntry();
                    if (!this.isContentZipEntry(zipEntry)) continue;
                    object = object2;
                    break;
                }
            }
            if (this.defaultLoadOptions == null || this.defaultLoadOptions.isEmpty()) {
                this.doLoad((InputStream)object, map);
            } else if (map == null) {
                this.doLoad((InputStream)object, this.defaultLoadOptions);
            } else {
                object2 = new HashMap(this.defaultLoadOptions);
                object2.putAll(map);
                this.doLoad((InputStream)object, (Map)object2);
            }
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
        }
    }

    protected void doLoad(InputStream inputStream, Map map) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(this.getURIFragment(internalEObject)));
        internalEObject.eAdapters().clear();
    }

    protected Notification setLoaded(boolean bl) {
        boolean bl2 = this.isLoaded;
        this.isLoaded = bl;
        if (this.eNotificationRequired()) {
            NotificationImpl notificationImpl = new NotificationImpl(1, bl2, bl){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class clazz) {
                    return 4;
                }
            };
            return notificationImpl;
        }
        return null;
    }

    protected void doUnload() {
        TreeIterator treeIterator = EcoreUtil.getAllContents(new ArrayList(this.getContents()));
        this.getContents().clear();
        this.getErrors().clear();
        this.getWarnings().clear();
        while (treeIterator.hasNext()) {
            this.unloaded((InternalEObject)treeIterator.next());
        }
    }

    public final void unload() {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload();
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    public boolean isTrackingModification() {
        return this.modificationTrackingAdapter != null;
    }

    public void setTrackingModification(boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = this.modificationTrackingAdapter != null;
        if (bl2 != bl) {
            Adapter adapter = this.modificationTrackingAdapter = bl ? this.createModificationTrackingAdapter() : null;
            if (bl) {
                object = this.getContents().iterator();
                while (object.hasNext()) {
                    this.addModificationTrackingAdapters((EObject)object.next());
                }
            } else {
                object = this.getContents().iterator();
                while (object.hasNext()) {
                    this.removeModificationTrackingAdapters((EObject)object.next());
                }
            }
        }
        if (this.eNotificationRequired()) {
            object = new NotificationImpl(1, bl2, bl){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class clazz) {
                    return 5;
                }
            };
            this.eNotify((Notification)object);
        }
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ModificationTrackingAdapter();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        boolean bl2 = this.isModified;
        this.isModified = bl;
        if (this.eNotificationRequired()) {
            NotificationImpl notificationImpl = new NotificationImpl(1, bl2, bl){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class clazz) {
                    return 3;
                }
            };
            this.eNotify(notificationImpl);
        }
    }

    public String toKeyString() {
        StringBuffer stringBuffer = new StringBuffer("Key type: ");
        stringBuffer.append(this.getClass().toString());
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " uri='" + this.uri + "'";
    }

    protected class ModificationTrackingAdapter
    extends AdapterImpl {
        protected ModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 7: {
                    if (notification.isTouch()) break;
                    ResourceImpl.this.setModified(true);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ResourceImpl.this.setModified(true);
                }
            }
        }
    }

    protected class ContentsEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ContentsEList() {
        }

        public Object getNotifier() {
            return ResourceImpl.this;
        }

        public int getFeatureID() {
            return 2;
        }

        protected boolean isNotificationRequired() {
            return ResourceImpl.this.eNotificationRequired();
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notificationChain) {
            InternalEObject internalEObject = (InternalEObject)object;
            notificationChain = internalEObject.eSetResource(ResourceImpl.this, notificationChain);
            ResourceImpl.this.attached(internalEObject);
            return notificationChain;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notificationChain) {
            InternalEObject internalEObject = (InternalEObject)object;
            if (ResourceImpl.this.isLoaded) {
                ResourceImpl.this.detached(internalEObject);
            }
            return internalEObject.eSetResource(null, notificationChain);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int n) {
            return super.basicListIterator(n);
        }

        public List basicList() {
            return super.basicList();
        }

        protected Object[] newData(int n) {
            return new EObject[n];
        }

        protected void didAdd(int n, Object object) {
            super.didAdd(n, object);
            this.loaded();
            this.modified();
        }

        protected void didRemove(int n, Object object) {
            super.didRemove(n, object);
            this.modified();
        }

        protected void didSet(int n, Object object, Object object2) {
            super.didSet(n, object, object2);
            this.modified();
        }

        protected void didClear(int n, Object[] objectArray) {
            if (n == 0) {
                this.loaded();
            } else {
                super.didClear(n, objectArray);
            }
        }

        protected void loaded() {
            Notification notification;
            if (!ResourceImpl.this.isLoaded() && (notification = ResourceImpl.this.setLoaded(true)) != null) {
                ResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (ResourceImpl.this.isTrackingModification()) {
                ResourceImpl.this.setModified(true);
            }
        }
    }
}

