/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceSetImpl
extends NotifierImpl
implements ResourceSet {
    protected EList resources;
    protected EList adapterFactories;
    protected Map loadOptions;
    protected Resource.Factory.Registry resourceFactoryRegistry;
    protected URIConverter uriConverter;

    public EList getResources() {
        if (this.resources == null) {
            this.resources = new ResourcesEList();
        }
        return this.resources;
    }

    public TreeIterator getAllContents() {
        return EcoreUtil.getAllContents(Collections.singleton(this));
    }

    public EList getAdapterFactories() {
        if (this.adapterFactories == null) {
            this.adapterFactories = new BasicEList(){

                protected boolean useEquals() {
                    return false;
                }

                protected boolean isUnique() {
                    return true;
                }

                protected Object[] newData(int n) {
                    return new AdapterFactory[n];
                }
            };
        }
        return this.adapterFactories;
    }

    public Map getLoadOptions() {
        if (this.loadOptions == null) {
            this.loadOptions = new HashMap();
        }
        return this.loadOptions;
    }

    public EObject getEObject(URI uRI, boolean bl) {
        Resource resource = this.getResource(uRI.trimFragment(), bl);
        if (resource != null) {
            return resource.getEObject(uRI.fragment());
        }
        return null;
    }

    protected Resource demandCreateResource(URI uRI) {
        return this.createResource(uRI);
    }

    protected void demandLoad(Resource resource) throws IOException {
        resource.load(this.getLoadOptions());
    }

    protected Resource delegatedGetResource(URI uRI, boolean bl) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uRI.toString());
        return ePackage == null ? null : ePackage.eResource();
    }

    public Resource getResource(URI uRI, boolean bl) {
        Resource resource;
        URIConverter uRIConverter = this.getURIConverter();
        URI uRI2 = uRIConverter.normalize(uRI);
        Iterator iterator = this.getResources().iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            if (!uRIConverter.normalize(resource.getURI()).equals(uRI2)) continue;
            if (bl && !resource.isLoaded()) {
                try {
                    this.demandLoad(resource);
                }
                catch (Resource.IOWrappedException iOWrappedException) {
                    throw new WrappedException(iOWrappedException.getWrappedException());
                }
                catch (IOException iOException) {
                    throw new WrappedException(iOException);
                }
            }
            return resource;
        }
        resource = this.delegatedGetResource(uRI, bl);
        if (resource != null) {
            return resource;
        }
        if (bl) {
            Resource resource2 = this.demandCreateResource(uRI);
            if (resource2 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uRI + "'; a registered resource factory is needed");
            }
            try {
                this.demandLoad(resource2);
            }
            catch (Resource.IOWrappedException iOWrappedException) {
                throw new WrappedException(iOWrappedException.getWrappedException());
            }
            catch (IOException iOException) {
                throw new WrappedException(iOException);
            }
            return resource2;
        }
        return null;
    }

    public Resource createResource(URI uRI) {
        Resource.Factory factory = this.getResourceFactoryRegistry().getFactory(uRI);
        if (factory != null) {
            Resource resource = factory.createResource(uRI);
            this.getResources().add(resource);
            return resource;
        }
        return null;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

                public Resource.Factory delegatedGetFactory(URI uRI) {
                    return Resource.Factory.Registry.INSTANCE.getFactory(uRI);
                }
            };
        }
        return this.resourceFactoryRegistry;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry registry) {
        this.resourceFactoryRegistry = registry;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new URIConverterImpl();
        }
        return this.uriConverter;
    }

    public void setURIConverter(URIConverter uRIConverter) {
        this.uriConverter = uRIConverter;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " resources=" + (this.resources == null ? "[]" : this.resources.toString());
    }

    protected class ResourcesEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ResourcesEList() {
        }

        protected boolean isNotificationRequired() {
            return ResourceSetImpl.this.eNotificationRequired();
        }

        protected Object[] newData(int n) {
            return new Resource[n];
        }

        public Object getNotifier() {
            return ResourceSetImpl.this;
        }

        public int getFeatureID() {
            return 0;
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        protected NotificationChain inverseAdd(Object object, NotificationChain notificationChain) {
            Resource.Internal internal = (Resource.Internal)object;
            return internal.basicSetResourceSet(ResourceSetImpl.this, notificationChain);
        }

        protected NotificationChain inverseRemove(Object object, NotificationChain notificationChain) {
            Resource.Internal internal = (Resource.Internal)object;
            return internal.basicSetResourceSet(null, notificationChain);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int n) {
            return super.basicListIterator(n);
        }

        public List basicList() {
            return super.basicList();
        }
    }
}

