/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;

public class URIConverterImpl
implements URIConverter {
    protected URIMap uriMap;

    public OutputStream createOutputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            String string2 = uRI2.toFileString();
            return this.createFileOutputStream(string2);
        }
        if ("platform".equals(string) && uRI2.segmentCount() > 1 && "resource".equals(uRI2.segment(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = uRI2.segmentCount();
            while (n < n2) {
                stringBuffer.append('/');
                stringBuffer.append(uRI2.segment(n));
                ++n;
            }
            return this.createPlatformResourceOutputStream(stringBuffer.toString());
        }
        if (string == null) {
            String string3 = uRI2.toString();
            return this.createFileOutputStream(string3);
        }
        return this.createURLOutputStream(uRI2);
    }

    protected OutputStream createFileOutputStream(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            new File(string2).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }

    protected OutputStream createPlatformResourceOutputStream(String string) throws IOException {
        URI uRI = EcorePlugin.resolvePlatformResourcePath(string);
        if (uRI != null) {
            return this.createOutputStream(uRI);
        }
        throw new IOException("The path '" + string + "' is unmapped");
    }

    protected OutputStream createURLOutputStream(URI uRI) throws IOException {
        URL uRL = new URL(uRI.toString());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            String string2 = uRI2.toFileString();
            return this.createFileInputStream(string2);
        }
        if ("platform".equals(string) && uRI2.segmentCount() > 1 && "resource".equals(uRI2.segment(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = uRI2.segmentCount();
            while (n < n2) {
                stringBuffer.append('/');
                stringBuffer.append(uRI2.segment(n));
                ++n;
            }
            return this.createPlatformResourceInputStream(stringBuffer.toString());
        }
        if (string == null) {
            String string3 = uRI2.toString();
            return this.createFileInputStream(string3);
        }
        return this.createURLInputStream(uRI2);
    }

    protected InputStream createFileInputStream(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        return fileInputStream;
    }

    protected InputStream createPlatformResourceInputStream(String string) throws IOException {
        URI uRI = EcorePlugin.resolvePlatformResourcePath(string);
        if (uRI != null) {
            return this.createInputStream(uRI);
        }
        throw new IOException("The path '" + string + "' is unmapped");
    }

    protected InputStream createURLInputStream(URI uRI) throws IOException {
        URL uRL = new URL(uRI.toString());
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection.getInputStream();
    }

    public URI normalize(URI uRI) {
        String string = uRI.fragment();
        URI uRI2 = string == null ? this.getInternalURIMap().getURI(uRI) : this.getInternalURIMap().getURI(uRI.trimFragment()).appendFragment(string);
        String string2 = uRI2.scheme();
        if (string2 == null) {
            if (uRI2.hasAbsolutePath()) {
                uRI2 = URI.createURI("file:" + uRI2);
            } else {
                uRI2 = URI.createFileURI(new File(uRI2.trimFragment().toString()).getAbsolutePath());
                if (string != null) {
                    uRI2 = uRI2.appendFragment(string);
                }
            }
        }
        if (uRI2.equals(uRI)) {
            return uRI;
        }
        return this.normalize(uRI2);
    }

    public Map getURIMap() {
        return this.getInternalURIMap();
    }

    protected URIMap getInternalURIMap() {
        if (this.uriMap == null) {
            URIMappingRegistryImpl uRIMappingRegistryImpl = new URIMappingRegistryImpl(){

                protected URI delegatedGetURI(URI uRI) {
                    return URIMappingRegistryImpl.INSTANCE.getURI(uRI);
                }
            };
            this.uriMap = (URIMap)uRIMappingRegistryImpl.map();
        }
        return this.uriMap;
    }

    public static interface URIMap
    extends Map {
        public URI getURI(URI var1);
    }
}

