/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class URIMappingRegistryImpl
extends BasicEMap {
    public static final URIMappingRegistryImpl INSTANCE = new URIMappingRegistryImpl();
    protected BasicEList prefixMaps = new BasicEList();

    protected BasicEMap.Entry newEntry(int n, Object object, Object object2) {
        this.validateKey(object);
        this.validateValue(object2);
        return new MappingEntryImpl(n, object, object2);
    }

    public URI getURI(URI uRI) {
        URI uRI2 = (URI)this.get(uRI);
        if (uRI2 == null) {
            if (this.prefixMaps != null) {
                int n = Math.min(this.prefixMaps.size() - 1, uRI.segmentCount());
                while (n >= 0) {
                    List list = (List)this.prefixMaps.get(n);
                    int n2 = list.size() - 1;
                    while (n2 >= 0) {
                        BasicEMap.Entry entry = (BasicEMap.Entry)list.get(n2);
                        uRI2 = uRI.replacePrefix((URI)entry.getKey(), (URI)entry.getValue());
                        if (uRI2 != null) {
                            return uRI2;
                        }
                        --n2;
                    }
                    --n;
                }
            }
            uRI2 = this.delegatedGetURI(uRI);
        }
        return uRI2;
    }

    protected URI delegatedGetURI(URI uRI) {
        return uRI;
    }

    public Map map() {
        if (this.view == null) {
            this.view = new BasicEMap.View();
        }
        if (this.view.map == null) {
            this.view.map = new URIMapImpl();
        }
        return this.view.map;
    }

    protected void validateKey(Object object) {
        if (!(object instanceof URI)) {
            throw new IllegalArgumentException();
        }
    }

    protected void validateValue(Object object) {
        if (!(object instanceof URI)) {
            throw new IllegalArgumentException();
        }
    }

    protected void didAdd(BasicEMap.Entry entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int n = ((URI)entry.getKey()).segmentCount();
            if (this.prefixMaps == null) {
                this.prefixMaps = new BasicEList();
            }
            int n2 = this.prefixMaps.size() - 1;
            while (n2 <= n) {
                this.prefixMaps.add(new BasicEList());
                ++n2;
            }
            ((List)this.prefixMaps.get(n)).add(entry);
        }
    }

    protected void didModify(BasicEMap.Entry entry, Object object) {
        this.didRemove(entry);
        ((MappingEntryImpl)entry).determineEntryType();
        this.didAdd(entry);
    }

    protected void didRemove(BasicEMap.Entry entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int n = ((URI)entry.getKey()).segmentCount();
            ((List)this.prefixMaps.get(n)).remove(entry);
        }
    }

    protected void didClear(BasicEList[] basicEListArray) {
        this.prefixMaps = null;
    }

    protected class URIMapImpl
    extends BasicEMap.DelegatingMap
    implements URIConverterImpl.URIMap {
        public URI getURI(URI uRI) {
            return URIMappingRegistryImpl.this.getURI(uRI);
        }
    }

    protected class MappingEntryImpl
    extends BasicEMap.EntryImpl {
        public boolean isPrefixMapEntry;

        public MappingEntryImpl(int n, Object object, Object object2) {
            super(n, object, object2);
            this.determineEntryType();
        }

        public void determineEntryType() {
            this.isPrefixMapEntry = ((URI)this.key).isPrefix() && ((URI)this.value).isPrefix();
        }
    }
}

