/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.emf.ecore.resource.Resource;

public class XMIException
extends Exception
implements Resource.Diagnostic {
    protected String location;
    protected int line;
    protected int column;
    protected Exception exception;

    public XMIException(String string) {
        super(string);
    }

    public XMIException(Exception exception) {
        super(exception.getMessage());
        this.exception = exception;
    }

    public XMIException(String string, Exception exception) {
        super(string);
        this.exception = exception;
    }

    public XMIException(String string, String string2, int n, int n2) {
        super(string);
        this.location = string2;
        this.line = n;
        this.column = n2;
    }

    public XMIException(String string, Exception exception, String string2, int n, int n2) {
        super(string);
        this.exception = exception;
        this.location = string2;
        this.line = n;
        this.column = n2;
    }

    public XMIException(Exception exception, String string, int n, int n2) {
        super(exception.getMessage());
        this.exception = exception;
        this.location = string;
        this.line = n;
        this.column = n2;
    }

    public String getMessage() {
        String string = super.getMessage();
        if (this.line != 0) {
            string = string + " (" + this.location + ", " + this.line + ", " + this.column + ")";
        }
        return string;
    }

    public String getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Exception getWrappedException() {
        return this.exception;
    }

    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.exception != null) {
            this.exception.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.exception != null) {
            this.exception.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }
}

