/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SAXXMLHandler
extends XMLHandler {
    protected Locator locator;
    protected Attributes attribs;

    public SAXXMLHandler(XMLResource xMLResource, XMLHelper xMLHelper, Map map) {
        super(xMLResource, xMLHelper, map);
    }

    protected Object setAttributes(Object object) {
        Attributes attributes = this.attribs;
        this.attribs = (Attributes)object;
        return attributes;
    }

    public void setLocator(Object object) {
        this.locator = (Locator)object;
    }

    protected int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return super.getLineNumber();
    }

    protected int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    protected boolean isNull() {
        return this.attribs.getValue("xsi:nil") != null;
    }

    protected void handleNamespaceAttribs() {
        int n = 0;
        int n2 = this.attribs.getLength();
        while (n < n2) {
            String string = this.attribs.getQName(n);
            if (string.startsWith("xmlns")) {
                this.handleXMLNSAttribute(string, this.attribs.getValue(n));
            } else if ("xsi:schemaLocation".equals(string)) {
                this.handleXSISchemaLocation(this.attribs.getValue(n));
            } else if ("xsi:noNamespaceSchemaLocation".equals(string)) {
                this.handleXSINoNamespaceSchemaLocation(this.attribs.getValue(n));
            }
            ++n;
        }
    }

    protected String getXSIType() {
        return this.attribs.getValue("xsi:type");
    }

    protected void handleObjectAttribs(EObject eObject) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            int n = 0;
            int n2 = this.attribs.getLength();
            while (n < n2) {
                String string = this.attribs.getQName(n);
                if (string.equals(this.idAttribute)) {
                    this.xmlResource.setID(internalEObject, this.attribs.getValue(n));
                } else if (string.equals("href")) {
                    this.handleProxy(internalEObject, this.attribs.getValue(n));
                } else if (!string.startsWith("xmlns") && !this.notFeatures.contains(string)) {
                    this.setAttribValue(eObject, string, this.attribs.getValue(n));
                }
                ++n;
            }
        }
    }

    protected void processObject(EObject eObject) {
        EStructuralFeature eStructuralFeature;
        if (eObject != null && (eStructuralFeature = this.getContentFeature(eObject)) != null) {
            this.text = new StringBuffer();
            this.objects.push(eObject);
            this.types.push(eStructuralFeature);
            return;
        }
        super.processObject(eObject);
    }

    protected EStructuralFeature getContentFeature(EObject eObject) {
        EAttribute eAttribute;
        XMLResource.XMLInfo xMLInfo;
        EList eList;
        if (this.xmlMap != null && (eList = eObject.eClass().getEAllAttributes()).size() >= 1 && (xMLInfo = this.xmlMap.getInfo(eAttribute = (EAttribute)eList.get(0))) != null && xMLInfo.getXMLRepresentation() == 2) {
            return eAttribute;
        }
        return null;
    }
}

