/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;

public class XMISaveImpl
extends XMLSaveImpl {
    protected boolean xmiType;
    protected static final String XMI_ID_NS = "xmi:id";
    protected static final String XMI_TAG_NS = "xmi:XMI";
    protected static final String XMI_TYPE_NS = "xmi:type";
    protected static final String XMI_VER_NS = "xmi:version";
    protected static final String XMI_XMLNS = "xmlns:xmi";

    public XMISaveImpl(XMLHelper xMLHelper) {
        super(xMLHelper);
        this.idAttributeName = XMI_ID_NS;
    }

    public XMISaveImpl(Map map, XMLHelper xMLHelper, String string) {
        super(map, xMLHelper, string);
        this.xmiType = Boolean.TRUE.equals(map.get("USE_XMI_TYPE"));
        this.idAttributeName = XMI_ID_NS;
    }

    protected void init(XMLResource xMLResource, Map map) {
        super.init(xMLResource, map);
        this.xmiType = Boolean.TRUE.equals(map.get("USE_XMI_TYPE"));
    }

    public Object writeTopObjects(List list) {
        this.doc.startElement(XMI_TAG_NS);
        Object object = this.doc.mark();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            EObject eObject = (EObject)list.get(n);
            EClass eClass = eObject.eClass();
            String string = this.helper.getQName(eClass);
            this.doc.startElement(string);
            this.saveElementID(eObject);
            ++n;
        }
        this.doc.endElement();
        return object;
    }

    protected void saveTypeAttribute(EClass eClass) {
        if (this.xmiType) {
            this.doc.addAttribute(XMI_TYPE_NS, this.helper.getQName(eClass));
        } else {
            super.saveTypeAttribute(eClass);
        }
    }

    public void addNamespaceDeclarations() {
        this.doc.addAttribute(XMI_VER_NS, "2.0");
        this.doc.addAttribute(XMI_XMLNS, "http://www.omg.org/XMI");
        super.addNamespaceDeclarations();
    }
}

