/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class XMLHandler {
    protected static final String ERROR_TYPE = "error";
    protected static final String OBJECT_TYPE = "object";
    protected static final String TYPE_ATTRIB = "xsi:type";
    protected static final String NIL_ATTRIB = "xsi:nil";
    protected static final String SCHEMA_LOCATION_ATTRIB = "xsi:schemaLocation";
    protected static final String NO_NAMESPACE_SCHEMA_LOCATION_ATTRIB = "xsi:noNamespaceSchemaLocation";
    protected XMLResource xmlResource;
    protected XMLHelper helper;
    protected MyStack elements;
    protected MyStack objects;
    protected MyStack types;
    protected Map prefixesToFactories;
    protected Map urisToLocations;
    protected InternalEList extent;
    protected ResourceSet resourceSet;
    protected URI resourceURI;
    protected boolean resolve;
    protected boolean oldStyleProxyURIs;
    protected boolean disableNotify;
    protected StringBuffer text;
    protected List sameDocumentProxies;
    protected List forwardSingleReferences;
    protected List forwardManyReferences;
    protected Object[] identifiers;
    protected int[] positions;
    protected static final int ARRAY_SIZE = 64;
    protected static final int REFERENCE_THRESHOLD = 5;
    protected int capacity;
    protected Set notFeatures;
    protected String idAttribute;
    protected XMLResource.XMLMap xmlMap;
    Map eClassFeatureNamePairToEStructuralFeatureMap = new HashMap();
    EClassFeatureNamePair eClassFeatureNamePair = new EClassFeatureNamePair();

    public XMLHandler(XMLResource xMLResource, XMLHelper xMLHelper, Map map) {
        this.xmlResource = xMLResource;
        this.helper = xMLHelper;
        this.elements = new MyStack();
        this.objects = new MyStack();
        this.types = new MyStack();
        this.prefixesToFactories = new HashMap();
        this.forwardSingleReferences = new LinkedList();
        this.forwardManyReferences = new LinkedList();
        this.sameDocumentProxies = new LinkedList();
        this.identifiers = new Object[64];
        this.positions = new int[64];
        this.capacity = 64;
        this.resourceSet = xMLResource.getResourceSet();
        this.resourceURI = xMLResource.getURI();
        this.extent = (InternalEList)xMLResource.getContents();
        boolean bl = this.resolve = this.resourceURI.isHierarchical() && !this.resourceURI.isRelative();
        if (Boolean.TRUE.equals(map.get("DISABLE_NOTIFY"))) {
            this.disableNotify = true;
        }
        this.notFeatures = new HashSet();
        this.notFeatures.add(TYPE_ATTRIB);
        this.notFeatures.add(SCHEMA_LOCATION_ATTRIB);
        this.notFeatures.add(NO_NAMESPACE_SCHEMA_LOCATION_ATTRIB);
        this.xmlMap = (XMLResource.XMLMap)map.get("XML_MAP");
        xMLHelper.setXMLMap(this.xmlMap);
        if (this.xmlMap != null) {
            EPackage ePackage = this.xmlMap.getNoNamespacePackage();
            if (ePackage != null) {
                xMLHelper.setNoNamespacePackage(ePackage);
            }
            this.idAttribute = this.xmlMap.getIDAttributeName();
        }
    }

    protected abstract void handleObjectAttribs(EObject var1);

    protected abstract void handleNamespaceAttribs();

    protected abstract boolean isNull();

    protected abstract Object setAttributes(Object var1);

    protected abstract void setLocator(Object var1);

    protected abstract String getXSIType();

    public void startDocument() {
    }

    public void startElement(String string, String string2, String string3) {
        this.elements.push(string3);
        this.handleNamespaceAttribs();
        int n = string3.indexOf(":");
        String string4 = "";
        string2 = string3;
        if (n != -1) {
            string4 = string3.substring(0, n);
            string2 = string3.substring(n + 1);
        }
        this.processElement(string3, string4, string2);
    }

    protected void processElement(String string, String string2, String string3) {
        if (this.isError()) {
            this.types.push(ERROR_TYPE);
        } else if (this.objects.isEmpty()) {
            this.createTopObject(string2, string3);
        } else {
            this.handleFeature(string2, string3);
        }
    }

    public void endDocument() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Iterator iterator = this.sameDocumentProxies.iterator();
        block0: while (iterator.hasNext()) {
            object6 = (InternalEObject)iterator.next();
            object5 = object6.eClass().getEAllReferences().iterator();
            while (object5.hasNext()) {
                int n;
                object4 = (EReference)object5.next();
                object3 = object4.getEOpposite();
                if (object3 == null || !object6.eIsSet((EStructuralFeature)object4)) continue;
                EObject eObject = this.xmlResource.getEObject(object6.eProxyURI().fragment());
                if (eObject == null) continue block0;
                EObject eObject2 = (EObject)(object4.isMany() ? ((List)object6.eGet((EStructuralFeature)object4)).get(0) : object6.eGet((EStructuralFeature)object4));
                if (object3.isMany() && (n = (object2 = (object = (InternalEList)eObject2.eGet((EStructuralFeature)object3)).basicList()).indexOf(eObject)) != -1) {
                    int n2 = object2.indexOf(object6);
                    object.move(n2, n);
                    object.remove(n2 > n ? n2 - 1 : n2 + 1);
                    continue block0;
                }
                boolean bl = object4.isMany() ? !((InternalEList)eObject.eGet((EStructuralFeature)object4)).basicList().contains(eObject2) : eObject.eGet((EStructuralFeature)object4) != eObject2;
                if (!bl) continue block0;
                if (object3.isMany()) {
                    object = (InternalEList)eObject2.eGet((EStructuralFeature)object3);
                    object.setUnique(object.indexOf(object6), eObject);
                    continue block0;
                }
                eObject2.eSet((EStructuralFeature)object3, eObject);
                continue block0;
            }
        }
        object6 = this.forwardSingleReferences.iterator();
        while (object6.hasNext()) {
            object5 = (SingleReference)object6.next();
            object4 = this.xmlResource.getEObject((String)((SingleReference)object5).getValue());
            if (object4 != null) {
                object3 = ((SingleReference)object5).getFeature();
                this.setFeatureValue(((SingleReference)object5).getObject(), (EStructuralFeature)object3, object4, ((SingleReference)object5).getPosition());
                continue;
            }
            this.error(new UnresolvedReferenceException((String)((SingleReference)object5).getValue(), this.xmlResource.getURI().toString(), ((SingleReference)object5).getLineNumber(), ((SingleReference)object5).getColumnNumber()));
        }
        object5 = this.forwardManyReferences.iterator();
        while (object5.hasNext()) {
            object4 = (ManyReference)object5.next();
            object3 = ((ManyReference)object4).getValues();
            int n = 0;
            int n3 = ((Object[])object3).length;
            while (n < n3) {
                object = (String)object3[n];
                object3[n] = object2 = this.xmlResource.getEObject((String)object);
                if (object2 == null) {
                    this.error(new UnresolvedReferenceException((String)object, this.xmlResource.getURI().toString(), ((ManyReference)object4).getLineNumber(), ((ManyReference)object4).getColumnNumber()));
                }
                ++n;
            }
            this.setFeatureValues((ManyReference)object4);
        }
        if (this.disableNotify) {
            object4 = this.xmlResource.getAllContents();
            while (object4.hasNext()) {
                object3 = (EObject)object4.next();
                object3.eSetDeliver(true);
            }
        }
    }

    protected void createTopObject(String string, String string2) {
        EFactory eFactory = this.getFactoryForPrefix(string);
        if (eFactory == null && string.equals("") && this.helper.getURI(string) == null) {
            this.error(new PackageNotFoundException(null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
        EObject eObject = this.createObjectFromFactory(eFactory, string2);
        this.processTopObject(eObject);
    }

    protected void processTopObject(EObject eObject) {
        if (eObject != null) {
            this.extent.addUnique(eObject);
        }
        this.processObject(eObject);
    }

    public void endElement(String string, String string2, String string3) {
        this.elements.pop();
        Object object = this.types.pop();
        if (object == OBJECT_TYPE) {
            if (this.text != null) {
                this.handleProxy((InternalEObject)this.objects.pop(), this.text.toString().trim());
                this.text = null;
            } else {
                this.objects.pop();
            }
        } else if (this.isTextFeatureValue(object)) {
            EObject eObject = (EObject)this.objects.pop();
            if (eObject == null) {
                eObject = (EObject)this.objects.peek();
            }
            this.setFeatureValue(eObject, (EStructuralFeature)object, this.text == null ? null : this.text.toString());
            this.text = null;
        }
    }

    protected boolean isTextFeatureValue(Object object) {
        return object != ERROR_TYPE;
    }

    public void startPrefixMapping(String string, String string2) {
        this.helper.addPrefix(string, string2);
    }

    public void endPrefixMapping(String string) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.text != null) {
            this.text.append(cArray, n, n2);
        }
    }

    protected void handleXMLNSAttribute(String string, String string2) {
        int n = string.indexOf(":");
        String string3 = n == -1 ? "" : string.substring(n + 1);
        this.helper.addPrefix(string3, string2);
    }

    protected void handleXSISchemaLocation(String string) {
        if (this.urisToLocations == null) {
            this.urisToLocations = new HashMap();
            if (this.xmlResource != null) {
                this.xmlResource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            URI uRI = URI.createURI(string3);
            if (this.resolve && uRI.isRelative() && uRI.hasRelativePath()) {
                uRI = this.helper.resolve(uRI, this.resourceURI);
            }
            this.urisToLocations.put(string2, uRI);
        }
    }

    protected void handleXSINoNamespaceSchemaLocation(String string) {
        if (this.urisToLocations == null) {
            this.urisToLocations = new HashMap();
            if (this.xmlResource != null) {
                this.xmlResource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
            }
        }
        if (this.helper.getNoNamespacePackage() == null) {
            URI uRI = URI.createURI(string);
            if (this.resolve && uRI.isRelative() && uRI.hasRelativePath()) {
                uRI = this.helper.resolve(uRI, this.resourceURI);
            }
            this.helper.setNoNamespacePackage(this.getPackageForURI(uRI.toString()));
        }
    }

    protected void handleFeature(String string, String string2) {
        EObject eObject = (EObject)this.objects.peek();
        EStructuralFeature eStructuralFeature = this.getFeature(eObject, string, string2);
        if (eStructuralFeature != null) {
            int n = this.helper.getFeatureKind(eStructuralFeature);
            if (n == 1 || n == 2) {
                this.objects.push(null);
                this.types.push(eStructuralFeature);
                if (!this.isNull()) {
                    this.text = new StringBuffer();
                }
            } else {
                this.createObject(eObject, eStructuralFeature);
            }
        } else {
            eStructuralFeature = this.getFeature(eObject, null, "");
            if (eStructuralFeature != null) {
                EObject eObject2;
                EFactory eFactory = this.getFactoryForPrefix(string);
                if (eFactory == null) {
                    eFactory = eStructuralFeature.getEContainingClass().getEPackage().getEFactoryInstance();
                }
                if ((eObject2 = this.createObjectFromFactory(eFactory, string2)) != null) {
                    this.setFeatureValue(eObject, eStructuralFeature, eObject2);
                }
                this.processObject(eObject2);
            } else {
                EFactory eFactory;
                EObject eObject3;
                if (this.xmlMap != null && (eObject3 = this.createObjectFromFactory(eFactory = this.getFactoryForPrefix(string), string2)) != null) {
                    Iterator iterator = eObject.eClass().getEAllReferences().iterator();
                    while (iterator.hasNext()) {
                        EReference eReference = (EReference)iterator.next();
                        if (!eReference.getEType().isInstance(eObject3)) continue;
                        this.setFeatureValue(eObject, eReference, eObject3);
                        this.processObject(eObject3);
                        return;
                    }
                }
                this.error(new FeatureNotFoundException(string2, eObject, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            }
        }
    }

    protected int getLineNumber() {
        return -1;
    }

    protected int getColumnNumber() {
        return -1;
    }

    protected String getLocation() {
        return this.xmlResource.getURI().toString();
    }

    public void error(XMIException xMIException) {
        this.xmlResource.getErrors().add(xMIException);
    }

    public void warning(XMIException xMIException) {
        this.xmlResource.getWarnings().add(xMIException);
    }

    public void fatalError(XMIException xMIException) {
        this.xmlResource.getErrors().add(xMIException);
    }

    protected void createObject(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (this.isNull()) {
            this.setFeatureValue(eObject, eStructuralFeature, null);
            this.objects.push(null);
            this.types.push(OBJECT_TYPE);
        } else {
            String string = this.getXSIType();
            if (string != null) {
                this.createObjectFromTypeName(eObject, string, eStructuralFeature);
            } else {
                XMLResource.XMLInfo xMLInfo;
                EObject eObject2 = this.createObjectFromFeatureType(eObject, eStructuralFeature);
                if (this.xmlMap != null && !((EReference)eStructuralFeature).isContainment() && (xMLInfo = this.xmlMap.getInfo(eStructuralFeature)) != null && xMLInfo.getXMLRepresentation() == 0) {
                    this.text = new StringBuffer();
                }
            }
        }
    }

    protected EObject createObjectFromTypeName(EObject eObject, String string, EStructuralFeature eStructuralFeature) {
        EObject eObject2;
        String string2 = null;
        String string3 = "";
        int n = string.indexOf(":");
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        EFactory eFactory = this.getFactoryForPrefix(string3);
        if (eFactory == null && string3.equals("") && this.helper.getURI(string3) == null) {
            this.error(new PackageNotFoundException(null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
        if ((eObject2 = this.createObjectFromFactory(eFactory, string2)) != null) {
            this.setFeatureValue(eObject, eStructuralFeature, eObject2);
        }
        this.processObject(eObject2);
        return eObject2;
    }

    protected EObject createObjectFromFeatureType(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2;
        String string = null;
        EFactory eFactory = null;
        EClassifier eClassifier = null;
        if (eStructuralFeature != null && (eClassifier = eStructuralFeature.getEType()) != null) {
            eObject2 = (EClass)eClassifier;
            string = eObject2.getName();
            eFactory = eObject2.getEPackage().getEFactoryInstance();
        }
        if ((eObject2 = this.createObjectFromFactory(eFactory, string)) != null) {
            this.setFeatureValue(eObject, eStructuralFeature, eObject2);
        }
        this.processObject(eObject2);
        return eObject2;
    }

    protected EObject createObjectFromFactory(EFactory eFactory, String string) {
        EObject eObject = null;
        if (eFactory != null) {
            eObject = this.helper.createObject(eFactory, string);
            if (eObject != null) {
                if (this.disableNotify) {
                    eObject.eSetDeliver(false);
                }
                this.handleObjectAttribs(eObject);
            } else {
                this.error(new ClassNotFoundException(string, eFactory, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            }
        }
        return eObject;
    }

    protected void processObject(EObject eObject) {
        if (eObject != null) {
            this.objects.push(eObject);
            this.types.push(OBJECT_TYPE);
        } else {
            this.types.push(ERROR_TYPE);
        }
    }

    protected EFactory getFactoryForPrefix(String string) {
        EFactory eFactory = (EFactory)this.prefixesToFactories.get(string);
        if (eFactory == null) {
            String string2 = this.helper.getURI(string);
            EPackage ePackage = this.getPackageForURI(string2);
            if (ePackage == null && string2 == null && string.equals("")) {
                ePackage = this.helper.getNoNamespacePackage();
            }
            if (ePackage != null) {
                eFactory = ePackage.getEFactoryInstance();
                this.prefixesToFactories.put(string, eFactory);
            }
        }
        return eFactory;
    }

    protected EPackage getPackageForURI(String string) {
        if (string == null) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
        if (ePackage == null) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = URI.createURI(string);
            if (((URI)object4).scheme() == null) {
                object3 = EPackage.Registry.INSTANCE.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    object = (String)object2.getKey();
                    if (!((String)object).endsWith(string) || ((String)object).charAt(((String)object).length() - string.length() - 1) != '/') continue;
                    this.oldStyleProxyURIs = true;
                    return (EPackage)object2.getValue();
                }
            }
            if (this.urisToLocations != null && (object3 = (URI)this.urisToLocations.get(string)) != null) {
                object4 = object3;
            }
            object3 = ((URI)object4).fragment();
            object2 = null;
            if (this.resourceSet != null) {
                object2 = this.resourceSet.getResource(((URI)object4).trimFragment(), true);
            }
            if (object2 != null) {
                object = null;
                if (object3 != null) {
                    object = object2.getEObject((String)object3);
                } else {
                    EList eList = object2.getContents();
                    if (!eList.isEmpty()) {
                        object = eList.get(0);
                    }
                }
                if (object instanceof EPackage) {
                    ePackage = (EPackage)object;
                }
            }
        }
        if (ePackage == null) {
            this.error(new PackageNotFoundException(string, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
        return ePackage;
    }

    protected void setFeatureValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        this.setFeatureValue(eObject, eStructuralFeature, object, -1);
    }

    protected void setFeatureValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        try {
            this.helper.setValue(eObject, eStructuralFeature, object, n);
        }
        catch (RuntimeException runtimeException) {
            this.error(new IllegalValueException(eObject, eStructuralFeature, object, runtimeException, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
    }

    protected void setFeatureValues(ManyReference manyReference) {
        List list = this.helper.setManyReference(manyReference, this.getLocation());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XMIException xMIException = (XMIException)iterator.next();
                this.error(xMIException);
            }
        }
    }

    protected void setAttribValue(EObject eObject, String string, String string2) {
        EStructuralFeature eStructuralFeature;
        int n = string.indexOf(":");
        String string3 = null;
        String string4 = string;
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if ((eStructuralFeature = this.getFeature(eObject, string3, string4)) == null) {
            this.error(new FeatureNotFoundException(string, eObject, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        } else {
            int n2 = this.helper.getFeatureKind(eStructuralFeature);
            if (n2 == 1 || n2 == 2) {
                this.setFeatureValue(eObject, eStructuralFeature, string2, -2);
            } else {
                this.setValueFromId(eObject, (EReference)eStructuralFeature, string2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setValueFromId(EObject eObject, EReference eReference, String string) {
        Object object;
        Object[] objectArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        Object[] objectArray2 = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            block12: {
                objectArray = stringTokenizer.nextToken();
                int n3 = objectArray.indexOf("#");
                if (n3 != -1) {
                    if (n3 == 0) {
                        objectArray = objectArray.substring(1);
                        break block12;
                    } else {
                        object = this.setAttributes(null);
                        InternalEObject internalEObject = (InternalEObject)(objectArray2 == null ? this.createObjectFromFeatureType(eObject, eReference) : this.createObjectFromTypeName(eObject, (String)objectArray2, eReference));
                        this.setAttributes(object);
                        this.handleProxy(internalEObject, (String)objectArray);
                        this.objects.pop();
                        objectArray2 = null;
                        ++n2;
                        continue;
                    }
                }
                if (objectArray.indexOf(":") != -1) {
                    objectArray2 = objectArray;
                    continue;
                }
            }
            if (bl) {
                object = eReference.getEOpposite();
                bl2 = object == null || object.isTransient() || eReference.isMany();
                bl3 = bl2 || !object.isMany();
                bl = false;
            }
            if (bl3 && (object = this.xmlResource.getEObject((String)objectArray)) != null) {
                this.setFeatureValue(eObject, eReference, object);
                objectArray2 = null;
                ++n2;
                continue;
            }
            if (bl2) {
                if (n == this.capacity) {
                    this.growArrays();
                }
                this.identifiers[n] = objectArray;
                this.positions[n] = n2;
                ++n;
            }
            objectArray2 = null;
            ++n2;
        }
        if (n2 == 0) {
            this.setFeatureValue(eObject, eReference, null, -2);
            return;
        }
        if (n > 5) {
            objectArray = new Object[n];
            int[] nArray = new int[n];
            System.arraycopy(this.identifiers, 0, objectArray, 0, n);
            System.arraycopy(this.positions, 0, nArray, 0, n);
            object = new ManyReference(eObject, eReference, objectArray, nArray, this.getLineNumber(), this.getColumnNumber());
            this.forwardManyReferences.add(object);
            return;
        }
        int n4 = 0;
        while (n4 < n) {
            SingleReference singleReference = new SingleReference(eObject, eReference, this.identifiers[n4], this.positions[n4], this.getLineNumber(), this.getColumnNumber());
            this.forwardSingleReferences.add(singleReference);
            ++n4;
        }
    }

    protected void handleProxy(InternalEObject internalEObject, String string) {
        URI uRI;
        if (this.oldStyleProxyURIs) {
            uRI = URI.createURI(string.startsWith("/") ? string : "/" + string);
            internalEObject.eSetProxyURI(uRI);
        } else {
            URI uRI2 = URI.createURI(string);
            if (this.resolve && uRI2.isRelative() && uRI2.hasRelativePath() && !EPackage.Registry.INSTANCE.containsKey(uRI2.trimFragment().toString())) {
                uRI2 = this.helper.resolve(uRI2, this.resourceURI);
            }
            uRI = uRI2;
            internalEObject.eSetProxyURI(uRI);
        }
        if (uRI.trimFragment().equals(this.resourceURI)) {
            this.sameDocumentProxies.add(internalEObject);
        }
    }

    protected void growArrays() {
        int n = this.capacity;
        this.capacity *= 2;
        Object[] objectArray = new Object[this.capacity];
        int[] nArray = new int[this.capacity];
        System.arraycopy(this.identifiers, 0, objectArray, 0, n);
        System.arraycopy(this.positions, 0, nArray, 0, n);
        this.identifiers = objectArray;
        this.positions = nArray;
    }

    protected boolean isError() {
        return this.types.peek() == ERROR_TYPE;
    }

    protected EStructuralFeature getFeature(EObject eObject, String string, String string2) {
        EClass eClass;
        this.eClassFeatureNamePair.eClass = eClass = eObject.eClass();
        this.eClassFeatureNamePair.featureName = string2;
        EStructuralFeature eStructuralFeature = (EStructuralFeature)this.eClassFeatureNamePairToEStructuralFeatureMap.get(this.eClassFeatureNamePair);
        if (eStructuralFeature == null) {
            eStructuralFeature = this.helper.getFeature(eClass, this.helper.getURI(string), string2);
            EClassFeatureNamePair eClassFeatureNamePair = new EClassFeatureNamePair();
            eClassFeatureNamePair.eClass = eClass;
            eClassFeatureNamePair.featureName = string2;
            this.eClassFeatureNamePairToEStructuralFeatureMap.put(eClassFeatureNamePair, eStructuralFeature);
        }
        return eStructuralFeature;
    }

    public static String getXMLEncoding(byte[] byArray) {
        int n;
        String string = null;
        if (byArray.length >= 4) {
            if (byArray[0] == -2 && byArray[1] == -1 || byArray[0] == 0 && byArray[1] == 60) {
                string = "UnicodeBig";
            } else if (byArray[0] == -1 && byArray[1] == -2 || byArray[0] == 60 && byArray[1] == 0) {
                string = "UnicodeLittle";
            } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                string = "UTF8";
            }
        }
        String string2 = null;
        try {
            string2 = string != null ? new String(byArray, 0, byArray.length, string) : new String(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        if (!string2.startsWith("<?xml")) {
            return "UTF-8";
        }
        int n2 = string2.indexOf("?>");
        int n3 = string2.indexOf("encoding", 6);
        if (n3 == -1 || n3 > n2) {
            return "UTF-8";
        }
        int n4 = string2.indexOf("\"", n3);
        if (n4 == -1 || n4 > n2) {
            n4 = string2.indexOf("'", n3);
            n = string2.indexOf("'", n4 + 1);
        } else {
            n = string2.indexOf("\"", n4 + 1);
        }
        return string2.substring(n4 + 1, n);
    }

    static class EClassFeatureNamePair {
        public EClass eClass;
        public String featureName;

        EClassFeatureNamePair() {
        }

        public boolean equals(Object object) {
            EClassFeatureNamePair eClassFeatureNamePair = (EClassFeatureNamePair)object;
            return eClassFeatureNamePair.eClass == this.eClass && eClassFeatureNamePair.featureName == this.featureName;
        }

        public int hashCode() {
            return this.eClass.hashCode() ^ this.featureName.hashCode();
        }
    }

    protected static class ManyReference
    implements XMLHelper.ManyReference {
        private EObject object;
        private EStructuralFeature feature;
        private Object[] values;
        private int[] positions;
        private int lineNumber;
        private int columnNumber;

        ManyReference(EObject eObject, EStructuralFeature eStructuralFeature, Object[] objectArray, int[] nArray, int n, int n2) {
            this.object = eObject;
            this.feature = eStructuralFeature;
            this.values = objectArray;
            this.positions = nArray;
            this.lineNumber = n;
            this.columnNumber = n2;
        }

        public EObject getObject() {
            return this.object;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int[] getPositions() {
            return this.positions;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    protected static class SingleReference {
        private EObject object;
        private EStructuralFeature feature;
        private Object value;
        private int position;
        private int lineNumber;
        private int columnNumber;

        public SingleReference(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n, int n2, int n3) {
            this.object = eObject;
            this.feature = eStructuralFeature;
            this.value = object;
            this.position = n;
            this.lineNumber = n2;
            this.columnNumber = n3;
        }

        public EObject getObject() {
            return this.object;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public Object getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    protected static class MyStack
    extends ArrayList {
        public Object peek() {
            int n = this.size();
            return n == 0 ? null : this.get(n - 1);
        }

        public void push(Object object) {
            this.add(object);
        }

        public Object pop() {
            int n = this.size();
            return n == 0 ? null : this.remove(n - 1);
        }
    }
}

