/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;

public class XMLHelperImpl
implements XMLHelper {
    protected static final Integer INTEGER_DATATYPE_IS_MANY = new Integer(2);
    protected static final Integer INTEGER_DATATYPE_SINGLE = new Integer(1);
    protected static final Integer INTEGER_IS_MANY_ADD = new Integer(3);
    protected static final Integer INTEGER_IS_MANY_MOVE = new Integer(4);
    protected EPackage noNamespacePackage;
    protected XMLResource.XMLMap xmlMap;
    protected XMLResource resource;
    protected Map packages = new HashMap();
    protected Map featuresToKinds = new HashMap();
    protected String processDanglingHREF;
    protected DanglingHREFException danglingHREFException;
    protected Map prefixesToURIs = new HashMap();

    public static String saveString(Map hashMap, List list, String string, XMLHelper xMLHelper) throws Exception {
        if (xMLHelper == null) {
            xMLHelper = new XMIHelperImpl();
        }
        if (!hashMap.containsKey("DECLARE_XML")) {
            hashMap = new HashMap<String, Boolean>(hashMap);
            hashMap.put("DECLARE_XML", Boolean.FALSE);
        }
        XMISaveImpl xMISaveImpl = new XMISaveImpl(hashMap, xMLHelper, string);
        ((XMLHelperImpl)xMLHelper).processDanglingHREF = (String)hashMap.get("PROCESS_DANGLING_HREF");
        xMISaveImpl.traverse(list);
        char[] cArray = xMISaveImpl.toChar();
        return new String(cArray);
    }

    public XMLHelperImpl() {
    }

    public XMLHelperImpl(XMLResource xMLResource) {
        this();
        this.resource = xMLResource;
    }

    public void setNoNamespacePackage(EPackage ePackage) {
        this.noNamespacePackage = ePackage;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePackage;
    }

    public void setXMLMap(XMLResource.XMLMap xMLMap) {
        this.xmlMap = xMLMap;
        if (xMLMap != null && xMLMap.getNoNamespacePackage() != null) {
            this.setNoNamespacePackage(xMLMap.getNoNamespacePackage());
        }
    }

    public XMLResource.XMLMap getXMLMap() {
        return this.xmlMap;
    }

    public XMLResource getResource() {
        return this.resource;
    }

    public void setResource(XMLResource xMLResource) {
        this.resource = xMLResource;
    }

    public Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        return eObject.eGet(eStructuralFeature, false);
    }

    public String getQName(EClass eClass) {
        Object object;
        String string = this.getName(eClass);
        if (this.xmlMap != null && (object = this.xmlMap.getInfo(eClass)) != null) {
            String string2 = object.getTargetNamespace();
            return this.getQName(string2, string);
        }
        object = eClass.getEPackage();
        this.packages.put(object, null);
        if (object.getNsPrefix().equals("")) {
            return string;
        }
        return object.getNsPrefix() + ":" + string;
    }

    protected String getQName(String string, String string2) {
        if (string == null) {
            if (this.noNamespacePackage != null) {
                this.packages.put(this.noNamespacePackage, null);
            }
            return string2;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
        if (ePackage == null || ePackage.getNsPrefix().equals("")) {
            return string2;
        }
        this.packages.put(ePackage, null);
        return ePackage.getNsPrefix() + ":" + string2;
    }

    public String getName(ENamedElement eNamedElement) {
        XMLResource.XMLInfo xMLInfo = null;
        if (this.xmlMap != null) {
            xMLInfo = this.xmlMap.getInfo(eNamedElement);
        }
        if (xMLInfo != null && xMLInfo.getName() != null) {
            return xMLInfo.getName();
        }
        return eNamedElement.getName();
    }

    public String getQName(EStructuralFeature eStructuralFeature) {
        XMLResource.XMLInfo xMLInfo;
        String string = this.getName(eStructuralFeature);
        if (this.xmlMap != null && (xMLInfo = this.xmlMap.getInfo(eStructuralFeature)) != null) {
            return this.getQName(xMLInfo.getTargetNamespace(), string);
        }
        return string;
    }

    public String getID(EObject eObject) {
        return this.resource == null ? null : this.resource.getID(eObject);
    }

    public String getIDREF(EObject eObject) {
        return this.resource == null ? null : this.resource.getURIFragment(eObject);
    }

    protected URI handleDanglingHREF(EObject eObject) {
        if (!"DISCARD".equals(this.processDanglingHREF)) {
            DanglingHREFException danglingHREFException = new DanglingHREFException("The object '" + eObject + "' is not contained in a resource.", this.resource.getURI().toString(), 0, 0);
            if (this.danglingHREFException == null) {
                this.danglingHREFException = danglingHREFException;
            }
            this.resource.getErrors().add(danglingHREFException);
        }
        return null;
    }

    public String getHREF(EObject eObject) {
        URI uRI;
        Object object;
        InternalEObject internalEObject = (InternalEObject)eObject;
        URI uRI2 = internalEObject.eProxyURI();
        if (uRI2 == null) {
            object = eObject.eResource();
            if (object == null) {
                uRI2 = this.handleDanglingHREF(eObject);
                if (uRI2 == null) {
                    return null;
                }
            } else {
                uRI2 = object.getURI().appendFragment(object.getURIFragment(eObject));
            }
        }
        if (!uRI2.isRelative() && !((URI)(object = this.resource.getURI())).isRelative() && ((URI)object).isHierarchical() && (uRI = uRI2.deresolve((URI)object, true, true, false)).hasRelativePath()) {
            uRI2 = uRI;
        }
        return uRI2.toString();
    }

    public int getFeatureKind(EStructuralFeature eStructuralFeature) {
        Integer n = (Integer)this.featuresToKinds.get(eStructuralFeature);
        if (n != null) {
            return n;
        }
        this.computeFeatureKind(eStructuralFeature);
        n = (Integer)this.featuresToKinds.get(eStructuralFeature);
        if (n != null) {
            return n;
        }
        return 5;
    }

    public EObject createObject(EFactory eFactory, String string) {
        EPackage ePackage = eFactory.getEPackage();
        EClass eClass = (EClass)ePackage.getEClassifier(string);
        if (eClass == null && this.xmlMap != null) {
            eClass = (EClass)this.xmlMap.getClassifier(ePackage.getNsURI(), string);
        }
        if (eClass != null) {
            return eFactory.create(eClass);
        }
        return null;
    }

    public EStructuralFeature getFeature(EClass eClass, String string, String string2) {
        EStructuralFeature eStructuralFeature = this.getFeatureWithoutMap(eClass, string2);
        if (eStructuralFeature == null && this.xmlMap != null && (eStructuralFeature = this.xmlMap.getFeature(eClass, string, string2)) != null) {
            this.computeFeatureKind(eStructuralFeature);
        }
        return eStructuralFeature;
    }

    protected EStructuralFeature getFeatureWithoutMap(EClass eClass, String string) {
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(string);
        if (eStructuralFeature != null) {
            this.computeFeatureKind(eStructuralFeature);
        }
        return eStructuralFeature;
    }

    protected void computeFeatureKind(EStructuralFeature eStructuralFeature) {
        EClassifier eClassifier = eStructuralFeature.getEType();
        if (eClassifier instanceof EDataType) {
            if (eStructuralFeature.isMany()) {
                this.featuresToKinds.put(eStructuralFeature, INTEGER_DATATYPE_IS_MANY);
            } else {
                this.featuresToKinds.put(eStructuralFeature, INTEGER_DATATYPE_SINGLE);
            }
        } else if (eStructuralFeature.isMany()) {
            EReference eReference = (EReference)eStructuralFeature;
            EReference eReference2 = eReference.getEOpposite();
            if (eReference2 == null || eReference2.isTransient() || !eReference2.isMany()) {
                this.featuresToKinds.put(eStructuralFeature, INTEGER_IS_MANY_ADD);
            } else {
                this.featuresToKinds.put(eStructuralFeature, INTEGER_IS_MANY_MOVE);
            }
        }
    }

    public String getJavaEncoding(String string) {
        return string;
    }

    public String getXMLEncoding(String string) {
        return string;
    }

    public EPackage[] packages() {
        Set set = this.packages.keySet();
        EPackage[] ePackageArray = new EPackage[set.size()];
        set.toArray(ePackageArray);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((EPackage)object).getNsPrefix().compareTo(((EPackage)object2).getNsPrefix());
            }
        };
        Arrays.sort(ePackageArray, comparator);
        return ePackageArray;
    }

    public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        int n2 = this.getFeatureKind(eStructuralFeature);
        switch (n2) {
            case 1: 
            case 2: {
                EClassifier eClassifier = eStructuralFeature.getEType();
                EDataType eDataType = (EDataType)eClassifier;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (n2 == 2) {
                    InternalEList internalEList = (InternalEList)eObject.eGet(eStructuralFeature);
                    if (n == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            internalEList.addUnique(eFactory.createFromString(eDataType, string));
                        }
                        if (!internalEList.isEmpty()) break;
                        internalEList.clear();
                        break;
                    }
                    if (object == null) {
                        internalEList.addUnique(null);
                        break;
                    }
                    internalEList.addUnique(eFactory.createFromString(eDataType, (String)object));
                    break;
                }
                if (object == null) {
                    eObject.eSet(eStructuralFeature, null);
                    break;
                }
                eObject.eSet(eStructuralFeature, eFactory.createFromString(eDataType, (String)object));
                break;
            }
            case 3: 
            case 4: {
                InternalEList internalEList = (InternalEList)eObject.eGet(eStructuralFeature);
                if (n == -1) {
                    internalEList.addUnique(object);
                    break;
                }
                if (n == -2) {
                    internalEList.clear();
                    break;
                }
                if (n2 == 3) {
                    internalEList.addUnique(n, object);
                    break;
                }
                internalEList.move(n, object);
                break;
            }
            default: {
                eObject.eSet(eStructuralFeature, object);
            }
        }
    }

    public List setManyReference(XMLHelper.ManyReference manyReference, String string) {
        EStructuralFeature eStructuralFeature = manyReference.getFeature();
        int n = this.getFeatureKind(eStructuralFeature);
        InternalEList internalEList = (InternalEList)manyReference.getObject().eGet(eStructuralFeature);
        BasicEList basicEList = new BasicEList();
        Object[] objectArray = manyReference.getValues();
        int[] nArray = manyReference.getPositions();
        if (n == 3) {
            int n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                if (objectArray[n2] != null) {
                    try {
                        internalEList.addUnique(nArray[n2], objectArray[n2]);
                    }
                    catch (RuntimeException runtimeException) {
                        basicEList.add(new IllegalValueException(manyReference.getObject(), eStructuralFeature, objectArray[n2], runtimeException, string, manyReference.getLineNumber(), manyReference.getColumnNumber()));
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = objectArray.length;
            while (n4 < n5) {
                if (objectArray[n4] != null) {
                    try {
                        internalEList.move(nArray[n4], objectArray[n4]);
                    }
                    catch (RuntimeException runtimeException) {
                        basicEList.add(new IllegalValueException(manyReference.getObject(), eStructuralFeature, objectArray[n4], runtimeException, string, manyReference.getLineNumber(), manyReference.getColumnNumber()));
                    }
                }
                ++n4;
            }
        }
        if (basicEList.isEmpty()) {
            return null;
        }
        return basicEList;
    }

    public void setProcessDanglingHREF(String string) {
        this.processDanglingHREF = string;
    }

    public DanglingHREFException getDanglingHREFException() {
        return this.danglingHREFException;
    }

    public URI resolve(URI uRI, URI uRI2) {
        return uRI.resolve(uRI2);
    }

    public void addPrefix(String string, String string2) {
        this.prefixesToURIs.put(string, string2);
    }

    public String getURI(String string) {
        return (String)this.prefixesToURIs.get(string);
    }
}

