/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXWrapper;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoadImpl
implements XMLLoad {
    protected static final int BUFFER_SIZE = 200;
    protected XMLResource resource;
    protected InputStream is;
    protected XMLHelper helper;
    protected Map options;

    public XMLLoadImpl(XMLHelper xMLHelper) {
        this.helper = xMLHelper;
    }

    public void load(XMLResource xMLResource, InputStream inputStream, Map map) throws IOException {
        this.resource = xMLResource;
        this.is = inputStream;
        this.options = map;
        try {
            SAXParser sAXParser = this.makeParser();
            String string = this.getEncoding();
            xMLResource.setEncoding(string);
            InputSource inputSource = new InputSource(this.is);
            String string2 = xMLResource.getURI().toString();
            inputSource.setPublicId(string2);
            inputSource.setSystemId(string2);
            sAXParser.parse(inputSource, this.makeDefaultHandler());
            this.helper = null;
            if (!xMLResource.getErrors().isEmpty()) {
                XMIException xMIException;
                Exception exception = (Exception)xMLResource.getErrors().get(0);
                if (exception instanceof XMIException && (xMIException = (XMIException)exception).getWrappedException() != null) {
                    throw new Resource.IOWrappedException(xMIException.getWrappedException());
                }
                throw new Resource.IOWrappedException(exception);
            }
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new Resource.IOWrappedException(sAXException.getException());
            }
            throw new Resource.IOWrappedException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Resource.IOWrappedException(parserConfigurationException);
        }
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        return sAXParserFactory.newSAXParser();
    }

    protected DefaultHandler makeDefaultHandler() {
        return new SAXWrapper(new SAXXMLHandler(this.resource, this.helper, this.options));
    }

    protected String getEncoding() throws IOException {
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        byte[] byArray = this.readBuffer();
        return XMLHandler.getXMLEncoding(byArray);
    }

    protected byte[] readBuffer() throws IOException {
        int n;
        if (this.is.available() == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[200];
        this.is.mark(200);
        int n2 = n = this.is.read(byArray, 0, 200);
        while (n != -1 && n2 < 200) {
            n = this.is.read(byArray, n2, 200 - n2);
            if (n == -1) continue;
            n2 += n;
        }
        if (n2 < 200) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray2 = byArray;
        }
        this.is.reset();
        return byArray;
    }
}

