/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;

public class XMLMapImpl
implements XMLResource.XMLMap {
    protected static final String XSD2ECORE = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";
    protected Map ecoreToXMLInfo = new HashMap();
    protected EPackage noNamespacePkg;
    protected String idAttributeName;
    protected Map urisToNamesToClassifiers;
    protected Map eClassToFeatures;
    protected Set processedEPackages = new HashSet();

    public XMLMapImpl() {
        this.eClassToFeatures = new HashMap();
    }

    public void add(ENamedElement eNamedElement, XMLResource.XMLInfo xMLInfo) {
        this.ecoreToXMLInfo.put(eNamedElement, xMLInfo);
    }

    public XMLResource.XMLInfo getInfo(ENamedElement eNamedElement) {
        XMLResource.XMLInfo xMLInfo = (XMLResource.XMLInfo)this.ecoreToXMLInfo.get(eNamedElement);
        if (xMLInfo == null) {
            Iterator iterator = eNamedElement.getEAnnotations().iterator();
            while (iterator.hasNext()) {
                EAnnotation eAnnotation = (EAnnotation)iterator.next();
                if (!XSD2ECORE.equals(eAnnotation.getSource())) continue;
                xMLInfo = new XMLInfoImpl();
                EMap eMap = eAnnotation.getDetails();
                xMLInfo.setName((String)eMap.get("name"));
                xMLInfo.setTargetNamespace((String)eMap.get("targetNamespace"));
                String string = (String)eMap.get("representation");
                if ("element".equals(string)) {
                    xMLInfo.setXMLRepresentation(0);
                    continue;
                }
                if ("attribute".equals(string)) {
                    xMLInfo.setXMLRepresentation(1);
                    continue;
                }
                if (!"simple-content".equals(string)) continue;
                xMLInfo.setXMLRepresentation(2);
            }
            if (xMLInfo != null) {
                this.ecoreToXMLInfo.put(eNamedElement, xMLInfo);
            }
        }
        return xMLInfo;
    }

    public void setNoNamespacePackage(EPackage ePackage) {
        this.noNamespacePkg = ePackage;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePkg;
    }

    public void setIDAttributeName(String string) {
        this.idAttributeName = string;
    }

    public String getIDAttributeName() {
        return this.idAttributeName;
    }

    public EClassifier getClassifier(String string, String string2) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
        if (ePackage != null) {
            Object object;
            if (this.processedEPackages.add(ePackage)) {
                if (this.urisToNamesToClassifiers == null) {
                    this.urisToNamesToClassifiers = new HashMap();
                }
                this.getInfoForClassifiers(ePackage);
                object = this.ecoreToXMLInfo.entrySet().iterator();
                while (object.hasNext()) {
                    EClassifier eClassifier;
                    Map.Entry entry = (Map.Entry)object.next();
                    Object k = entry.getKey();
                    if (!(k instanceof EClassifier) || (eClassifier = (EClassifier)k).getEPackage() != ePackage) continue;
                    XMLResource.XMLInfo xMLInfo = (XMLResource.XMLInfo)entry.getValue();
                    String string3 = xMLInfo.getTargetNamespace();
                    if (string3 == null) {
                        string3 = string;
                    }
                    if (!(k instanceof EClassifier) || xMLInfo.getName() == null) continue;
                    HashMap hashMap = (HashMap)this.urisToNamesToClassifiers.get(string3);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        this.urisToNamesToClassifiers.put(string3, hashMap);
                    }
                    hashMap.put(xMLInfo.getName(), k);
                }
            }
            if ((object = (Map)this.urisToNamesToClassifiers.get(string)) != null) {
                return (EClassifier)object.get(string2);
            }
        }
        return null;
    }

    private void getInfoForClassifiers(EPackage ePackage) {
        Iterator iterator = ePackage.getEClassifiers().iterator();
        while (iterator.hasNext()) {
            this.getInfo((ENamedElement)iterator.next());
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String string, String string2) {
        Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            XMLResource.XMLInfo xMLInfo = this.getInfo(eStructuralFeature);
            if (xMLInfo == null) continue;
            String string3 = xMLInfo.getTargetNamespace();
            String string4 = xMLInfo.getName();
            if (!(string == null ? string3 == null && (string2.equals(string4) || string4 == null && string2.length() == 0) : string.equals(string3) && string2.equals(string4))) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public List getFeatures(EClass eClass) {
        EList eList = (EList)this.eClassToFeatures.get(eClass);
        if (eList == null) {
            String string;
            eList = new UniqueEList();
            Iterator iterator = eClass.getESuperTypes().iterator();
            while (iterator.hasNext()) {
                eList.addAll(this.getFeatures((EClass)iterator.next()));
            }
            EList eList2 = eClass.getEAttributes();
            eList.addAll(eList2);
            EList eList3 = eClass.getEReferences();
            eList.addAll(eList3);
            EAnnotation eAnnotation = eClass.getEAnnotation(XSD2ECORE);
            if (eAnnotation != null && (string = (String)eAnnotation.getDetails().get("feature-order")) != null) {
                int n = eList.size();
                int n2 = n - eList3.size() - eList2.size();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n3 = n2;
                    while (n3 < n) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n3);
                        if (string2.equals(eStructuralFeature.getName())) {
                            eList.move(n2, eStructuralFeature);
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            this.eClassToFeatures.put(eClass, eList);
        }
        return eList;
    }
}

